/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nH4g
 */

package {
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        public var _bitmapData:BitmapData;
        public var _bitmap:Bitmap;
        
        public var cellArray:Array;
        public var originalArray:Array = [];
        public var neighborArray:Array = [];
        
        public var _width:int = 465;
        public var _height:int = 465;
        public var _half:int = 465 / 2;
        
        public var walk:int = 0;
        public var _label:Label;
        
        public function FlashTest() {
            // write as3 code here..
            _bitmapData = new BitmapData(_width, _height, false, 0x292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            cellArray = [];
            var i:int, j:int;
            for (i = 0; i < _width; i += 1)
            {
                cellArray[i] = [];
                
                for (j = 0; j < _height; j += 1)
                {
                    cellArray[i].push(false);
                }
            }
            
            cellArray[_half][_half] = true;
            originalArray.push(_half + _width * _half);
            neighborArray.push((_half - 1) + width * _half, (_half + 1) + width * _half, _half + width * (_half - 1), _half + width * (_half + 1));
            
            _bitmapData.setPixel(_half, _half, 0x999999);
            walk += 1;
            
            _label = new Label(this, 10, 10, "walk " + String(walk));
            
            stage.frameRate = 60;
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        public function onLoop(e:Event):void
        {
            var tx:int;
            var ty:int;
            var randIndex:int;
            var pick:int;
            var temp:int;
            
            //pick Random neighbor cell
            randIndex = Math.random() * neighborArray.length;
            pick = neighborArray.splice(randIndex, 1);
            
            originalArray.push(pick);
            tx = pick % _width;
            ty = pick / _width;
            
            //fill New Cell
            _bitmapData.setPixel(tx, ty, 0x999999);
            walk += 1;
            
            if (tx - 1 > 0)
            {
                temp = tx - 1 + ty * _width;
                if (neighborArray.indexOf(temp) == -1 && originalArray.indexOf(temp) == -1)
                {
                    neighborArray.push(temp);
                }
            }
            if (tx + 1 < _width - 1)
            {
                temp = tx + 1 + ty * _width;
                if (neighborArray.indexOf(temp) == -1 && originalArray.indexOf(temp) == -1)
                {
                    neighborArray.push(temp);
                }
            }
            if (ty - 1 > 0)
            {
                temp = tx + (ty - 1) * _width;
                if (neighborArray.indexOf(temp) == -1 && originalArray.indexOf(temp) == -1)
                {
                    neighborArray.push(temp);
                }
            }
            if (ty + 1 < _height - 1)
            {
                temp = tx + (ty + 1) * _width;
                if (neighborArray.indexOf(temp) == -1 && originalArray.indexOf(temp) == -1)
                {
                    neighborArray.push(temp);
                }
            }
            
            _label.text = "walk " + String(walk);
        }
    }
}