/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nFdM
 */

// forked from mousepancyo's SAKURA
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.utils.Dictionary;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "60")]
    
    public class Main extends Sprite
    {
        
        private const NUM_SAKURA:int = 300;
        private const IMG_URL:String = "http://www.digifie.jp/assets/images/sakura.png";
        
        private var _loader:Loader;
        private var _canvas:BitmapData;
        private var _ctf:ColorTransform;
        
        private var _dict:Dictionary = new Dictionary(true);
        
        private var _sakura:BitmapData;
        private var _sakuraList:Vector.<Sprite> = Vector.<Sprite>([]);
        
        private var _isDown:Boolean;
        private var _oldP:Point = new Point();
        private var _distP:Point = new Point();
        
        public function Main()
        {
            Wonderfl.capture_delay(10);            
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            loadImage(IMG_URL)
        }
        
        private function loadImage(url:String):void
        {
            var context:LoaderContext = new LoaderContext;
            context.checkPolicyFile = true;
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
            _loader.load(new URLRequest(url), context);
        }
        
        private function onLoaded(e:Event):void
        {
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaded);
            _sakura = new BitmapData(_loader.width, _loader.height, true, 0);
            _sakura.draw(_loader);
            setup();
        }
        
        private function setup():void
        {
            _canvas = new BitmapData(465, 465, false, 0);
            addChild(new Bitmap(_canvas));
            _ctf = new ColorTransform(.75, .75, .75);
            addSakura();
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        
        private function addSakura():void
        {
            var n:int = NUM_SAKURA;
            while(n--){
                var sak:Sprite = new Sprite();
                var bmd:BitmapData = _sakura.clone();
                var bm:Bitmap = new Bitmap(bmd);
                sak.addChild(bm);
                bm.x = -bm.width * .5;
                bm.y = -bm.height * .5;
                sak.scaleX = sak.scaleY = Math.random() * 1.2 + .3;
                sak.x = Math.random() * 300 - 200;
                sak.y = Math.random() * -500 - 100;
                sak.filters = [new BlurFilter(4, 4)];
                sak.blendMode = "add";
                _dict[sak] = {vx:2 - sak.scaleX, vy:Math.random() * sak.scaleY + 1, inix:sak.x, iniy:sak.y};
                addChild(sak);
                _sakuraList.push(sak);
            }
        }
        
        private function fall(sak:Sprite):void
        {
            sak.rotationX += Math.random() * 10 - _distP.x * .01; 
            sak.rotationY += Math.random() * 10 - _distP.y * .01;
            var vx:Number = _dict[sak].vx;
            var vy:Number = _dict[sak].vy;
            var dist:Number = Point.distance(new Point(sak.x, sak.y), _distP);
            vx = vx + (180 - (sak.rotationY % 360)) * (.003 - _distP.x / dist);
            vy = vy - (180 - (sak.rotationX % 180)) * (.008 - _distP.y / dist);
            sak.x += vx;
            sak.y += vy;
            if(sak.x > 500 || sak.x < -500) sak.x = _dict[sak].inix;
            if(sak.y > 500 || sak.y < -600) sak.y = _dict[sak].iniy;
        }
        
        private function update(e:Event):void
        {
            if(_isDown){
                _distP = new Point(mouseX - _oldP.x, mouseY - _oldP.y);
                _oldP = new Point(mouseX, mouseY);
            }else{
                if(Math.abs(_distP.x) > 0){
                    _distP.x = _distP.x * .98;
                }else{
                    _distP.x = 0;
                }
                if(Math.abs(_distP.y) > 0){
                    _distP.y = _distP.y * .95;
                }else{
                    _distP.y = 0;
                }
            }
            //
            var n:int = NUM_SAKURA;
            while(n--){
                fall(_sakuraList[n]);
            }
            _canvas.lock();
            _canvas.draw(stage);
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(16, 16));
            _canvas.colorTransform(_canvas.rect, _ctf);
            _canvas.unlock();
        }
        
        private function onDown(e:MouseEvent):void
        {
            _oldP = new Point(mouseX, mouseY);
            _isDown = true;
        }
        
        private function onUp(e:MouseEvent):void
        {
            _isDown = false;
        }
    }
}