/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nEF2
 */

package {
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.utils.getTimer;
	import idv.cjcat.stardust.common.particles.ParticleCollection;
	import idv.cjcat.stardust.common.particles.ParticleIterator;
	import idv.cjcat.stardust.common.particles.ParticleList;
	import idv.cjcat.stardust.twoD.particles.Particle2D;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends Sprite {
		
		private const COUNT:int = 50000;
		
		private var label:Label;
		
		public function Main() {
			new PushButton(this, 10, 10, "Array", spliceArray);
			new PushButton(this, 10, 40, "Linked List", spliceLinkedList);
			
			label = new Label(this, 10, 70);
		}
		
		private function spliceArray(e:Event):void {
			var array:Array = new Array(COUNT);
			var i:int = 0;
			for (i = 0; i < COUNT; i++) array[i] = new Particle2D();
			
			var t:int = getTimer();
			for (i = 0; i < COUNT; i++) array.splice(0, 1);
			label.text = "Array splicing: " + (getTimer() - t) + "ms";
		}
		
		private function spliceLinkedList(e:Event):void{
			var list:ParticleCollection = new ParticleList();
			var i:int = 0;
			for (i = 0; i < COUNT; i++) list.add(new Particle2D());
			
			var iter:ParticleIterator = list.getIterator();
			var t:int = getTimer();
			while (iter.particle) iter.remove();
			label.text = "Linked list splicing: " + (getTimer() - t) + "ms";
		}
	}
}