/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nDDg
 */

// forked from ProjectNya's マウスを追う (2)
////////////////////////////////////////////////////////////////////////////////
// マウスを追う (2)
//
// マウスの動きとムービークリップ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=94
// [AS3.0] マウスの動きを追尾する (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1269
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import __AS3__.vec.Vector;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    import gs.*;
    import gs.easing.*;
    import gs.plugins.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var leader:Leader;
        private static var max:uint = 6;
        private var circles:Array;
        private var tracks:Vector.<Point>;
        private static var interval:uint = 20;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
            //addChild(new Stats());
        }

        private function init():void {
            leader = new Leader(0x000000);
            addChild(leader);
            var cx:uint = stage.stageWidth/2;
            var cy:uint = stage.stageHeight/2;
            leader.x = cx;
            leader.y = cy;
            var colors:Array = new Array();
            colors.push(0x444444);
            colors.push(0x444444);
            colors.push(0x444444);
            circles = new Array();
            tracks = new Vector.<Point>();
            for (var n:uint = 0; n < max; n++) {
                var circle:Circle = new Circle(colors[n]);
                addChild(circle);
                circle.x = cx;
                circle.y = cy;
                circles.push(circle);
             
            TweenMax.to(circle, 3, {glowFilter:{color:0x000000, blurX:10, blurY:10, strength:20, quality:3}});
            //TweenMax.to(circle, 1, {tint:0xff9900}); 
                for (var t:uint = 0; t < interval; t++) {
                    tracks.push(new Point(cx, cy));
                }
            }
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            leader.update();
            for (var n:uint = 0; n < max; n++) {
                var circle:Object = circles[n];
                circle.update(tracks[interval*(n + 1) - 1]);
            }
            tracks.unshift(new Point(leader.x, leader.y));
            tracks.pop();
            
            
        }
        
    }

}


//////////////////////////////////////////////////
// Leaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;

class Leader extends Sprite {
    private static var radius:uint = 10;
    private var color:uint = 0xFFFFFF;
    private var target:Object = {x: 0, y: 0};
    private static var deceleration:Number = 0.16;

    public function Leader(c:uint) {
        color = c;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function update():void {
        x += (stage.mouseX - x)*deceleration;
        y += (stage.mouseY - y)*deceleration;
    }

}


//////////////////////////////////////////////////
// Circleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Point;

class Circle extends Sprite {
    private static var radius:uint = 10;
    private var color:uint = 0xFFFFFF;

    public function Circle(c:uint) {
        color = c;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function update(track:Point):void {
        x = track.x;
        y = track.y;
    }

}
