/**
 * Copyright kamipoo ( http://wonderfl.net/user/kamipoo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nCe6
 */

/**
 * Papervision3Dでのインデックスソートのサンプル
 * 
 * 2010.07.20 作成
 * 
 * @author Shuhei Kamiya<loftimg.jp>
 * @see http://loftimg.jp/blog/actionscript/papervision3d-index-sort.php
 */
package
{
    import com.bit101.components.Label;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.util.ViewportLayerSortMode;
    
    public class PV3DSortModeExample extends Sprite
    {
        
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _renderer:BasicRenderEngine;
        private var _viewport1:Viewport3D;
        private var _viewport2:Viewport3D;
        
        public function PV3DSortModeExample()
        {
            super();
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _init3d();
            _initObject();
            _initScreen();
        }
        
        private function _init3d():void
        {
            _scene = new Scene3D();
            _camera = new Camera3D();
            _renderer = new BasicRenderEngine();
            
            _viewport1 = new Viewport3D(stage.stageWidth/2, stage.stageHeight, false, false, true, true);
            
            _viewport2 = new Viewport3D(stage.stageWidth/2, stage.stageHeight, false, false, true, true);
            _viewport2.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT; //右側に表示されるViewportのソートモードをインデックスソートにする
            
            _viewport2.x = stage.stageWidth/2;
            
            addChild(_viewport1);
            addChild(_viewport2);
        }
        
        /**
         * DisplayObject3Dを3D空間上に配置する
         * Viewport.containerSprite.getChildLayerを実行してViewportLayerを生成する。
         * ViewportLayer.layerIndexに任意の値を入れる事によって深度を設定する（数値が大きい方が手前）
         */
        private function _initObject():void
        {
            var p1:DisplayObject3D = _scene.addChild(_createPlane(0xFF0000, 200, 200));
            var p2:DisplayObject3D = _scene.addChild(_createPlane(0x0000FF, 200, 200));
            
            p2.z = 100;
            
            //インデックスソートで利用するインデックスを設定する
            //数値が大きいほど手前に表示される
            _viewport2.getChildLayer(p1).layerIndex = 100;
            _viewport2.getChildLayer(p2).layerIndex = 0;
            
            var t:ITween = BetweenAS3.parallel(
                BetweenAS3.to(p1, {rotationX: 360, rotationY: 360, rotationZ: 360}, 5),
                BetweenAS3.to(p2, {rotationX: -360, rotationY: -360, rotationZ: -360}, 5)
            );
            t.stopOnComplete = false;
            t.onUpdate = _render;
            t.play();
        }
        
        private function _initScreen():void
        {
            new Label(this, 5, 2, "Z Sort");
            new Label(this, stage.stageWidth/2 + 5, 2, "Index Sort");
            
            graphics.lineStyle(1, 0x999999);
            graphics.moveTo(stage.stageWidth/2, 0);
            graphics.lineTo(stage.stageWidth/2, stage.stageHeight);
        }
        
        private function _createPlane(color:uint, width:Number, height:Number):Plane
        {
            var material:ColorMaterial = new ColorMaterial(color, 1, false);
            material.doubleSided = true;
            var plane:Plane = new Plane(material, width, height, 2, 2);
            return plane;
        }
        
        private function _render():void
        {
            _renderer.renderScene(_scene, _camera, _viewport1);
            _renderer.renderScene(_scene, _camera, _viewport2);
        }
    }
}