/**
 * Copyright fra978 ( http://wonderfl.net/user/fra978 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nBtL
 */

package {
    
    import flash.geom.*
    import flash.display.*
    
    [SWF(width="465", height="465", backgroundColor="0x000000", framerate="65")]
    
    public class colorSpectrum extends Sprite
    {
        private var divs:int = 32;
        private var colWidth:Number = divideSpace ();
        
       public function colorSpectrum ()
        {
           for ( var i:int = 0; i<divs; i++ )
            {
                setGradEll ( i );
            } 
        }

        private function setGradEll ( i:int ):void
        {
            var w:Number = colWidth * 3;
            var h:Number = stage.stageHeight;
            var X:Number = colWidth * i;
            var Y:Number = 0;
            
            var nColorPercent:Number = ( ( i / colWidth)  );
                        
            // Calculate the radians of the angle to use for rotating color values.
            var nRadians:Number = (-360 * nColorPercent) * (Math.PI / 180);
            trace ("RAD= " + nRadians);
                        
            // Calculate the RGB channels based on the angle.
            var nR:Number = Math.cos(nRadians)                   * 10 + 128 << 16;
            var nG:Number = Math.cos(nRadians + 2 * Math.PI / 3) * 127 + 128 << 8;
            var nB:Number = Math.cos(nRadians + 4 * Math.PI / 3) * 127 + 128;
                        
            // OR the individual color channels together.
            var nColor:Number = nR | nG | nB;
            trace ("COL= "+nColor);
            
            var fillType:String = GradientType.RADIAL;
            var colors:Array = [nColor, nColor];
            var alphas:Array = [.8, 0];
            var ratios:Array = [0, 255];
            var matr:Matrix = new Matrix();
            matr.createGradientBox(w, h, 0, X, Y);
            var spreadMethod:String = SpreadMethod.PAD;
            this.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr, spreadMethod);  
            this.graphics.drawRect (X, Y, w, h);
        }
        
        
       private  function divideSpace () : Number    
        {
            var num:Number = stage.stageWidth / divs;
            return num;
        }
        
            
        private function setRandomDim ( type:String ) : Number
        {
            var num:Number;
            switch (type)
            {
                case "w" :
                    num = Math.floor ( Math.random () * ( stage.stageWidth - (-200)  + (-200)) );
                break;
                case "h" :
                    num = Math.floor ( Math.random () * ( stage.stageHeight - (-200)  + (-200)) );
                break;
            }
            //trace (num)
            return  num
        }
    }
}