/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nBfD
 */

// forked from 084's flash on 2010-3-9

// 普通に改造してから question タグに気付くというこの始末。
// 084さんすみません。 diff 数を抑えてあるので見比べるならこちらを。
// 真ん中あたりに解説あります。
package {
import flash.display.Sprite;
import flash.events.Event;
import flash.media.Video;
	public class Bouncing extends Sprite {
		private var ball:Ball;
		private var vx:Number;
		private var vy:Number;
		
		public function Bouncing() {
			init();
		}
		
		private function init():void {
			//stage.scaleMode = StageScaleMode.NO_SCALE;
			//stage.align = StageAlign.TOP_LEFT;
			ball = new Ball();
			ball.x = stage.stageWidth / 2;
			ball.y = stage.stageHeight / 2;
			vx = Math.random() * 10 - 5;
			vy = Math.random() * 10 - 5;
			addChild(ball);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void {
			ball.x += vx;
			ball.y += vy;
			var left:Number = 0;
			var right:Number = stage.stageWidth;
			var top:Number = 0;
			var bottom:Number = stage.stageHeight;
			
			if (ball.x  + ball.radius > right) {
				ball.x = right - ball.radius;
                                ball.changeColor();
				vx *= -1;
			}else if (ball.x - ball.radius < left) {
				ball.x = left + ball.radius;
                                ball.changeColor();
				vx *= -1;
			}
			if (ball.y + ball.radius > bottom) {
				ball.y = bottom - ball.radius;
                                ball.changeColor();
				vy *= -1;
			}else if (ball.y - ball.radius < top) {
				ball.y = top + ball.radius;
                                ball.changeColor();
				vy *= -1;
			}
		}
	}
}

// Sprite や Shape のインスタンスを作ると、もれなく Graphics
// オブジェクトが付いてきます。 graphics プロパティで参照できるやつです。
// これはベクター描画のための情報（具体的には円を描く時の線の太さや半径、
// 色など）を保持します。
//
// ベクター画像では描画の要求があるたびにその情報に基づいて図形を計算、
// 描画します。円の公式を使って点(x, y)を求めるような感じです。
// 拡大するときはよりきめ細かく点(x, y)を求めればよいので、ベクター画像
// は拡大しても綺麗に描画されます。対照的にビットマップ画像では拡大すると
// ジャギります。これは既に1ピクセルごとに色が割り当てられているからです。
//
// 閑話休題。
// 結論としては、この Graphics オブジェクトを更新しない限りは円の色は
// 変わりません。 Ball インスタンスの color プロパティは独立した値で、
// drawCircle の color パラメータとは一切無関係です。壁と衝突する
// たびに graphics.drawCircle() を呼び出す必要があるというわけです。
//
// draw 系のメソッドはあくまで描画情報を追加するだけで、古い情報を新しい
// ものと置き換えるわけではありません。これらを呼び出す前にまず clear を
// 呼び出し Graphics オブジェクトの描画情報をリセットすべきだと私は
// 考えます。
// 衝突のたびに同じ半径・違う色を持つ円を追加すると、見た目はひとつの円で
// あるにも関わらず、一度の描画に何度も円を重ね描きしてしまうようになると
// 思われるです。
// （ちゃんと検証していないのでこのあたり推測で語ってます）

import flash.display.Sprite;
	 class Ball extends Sprite {
		public var radius:Number;
		public var color:uint;
		public var vx:Number = 0;
		public var vy:Number = 0;
			
		public function Ball(radius:Number = 40,color:uint=0xff0000 ):void {
			this.radius = radius;
			this.color = color;
		    init();
		}
		public function init():void {
			graphics.beginFill(color);
			graphics.drawCircle(0, 0, radius);
			graphics.endFill();
		}

        public function changeColor():void
        {
            graphics.clear();
			graphics.beginFill(0xFFFFFF * Math.random());
			graphics.drawCircle(0, 0, radius);
        }
	}