/**
 * Copyright seikimaiii ( http://wonderfl.net/user/seikimaiii )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nB7r
 */

package
{
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.net.FileReference;
    import flash.net.FileReferenceList;
    import flash.net.FileFilter;
    import flash.net.URLRequest;
    
    [SWF(frameRate="30",width=400,height=30,backgroundColor=0)]
    
    public class Uploader extends MovieClip
    {
        private var _progressBar:MovieClip;
        
        private var _status:TextField;
        
        private var _browseButton:TextButton;
        private var _uploadButton:TextButton;
        private var _doneButton:TextButton;
        
        private var _fileReferenceList:FileReferenceList;
        private var _currentFile:FileReference;
        private var _currentFileIndex:Number;
        
        public function Uploader():void
        {
            // Draw background
            graphics.beginFill(0x333333, 1);
            graphics.drawRoundRect(0, 0, 400, 30, 10);
            graphics.endFill();
            
            _progressBar = new MovieClip();
            _progressBar.graphics.beginFill(0x00ACE6, 1);
            _progressBar.graphics.drawRoundRect(0, 0, 400, 30, 10);
            _progressBar.graphics.endFill();
            addChild(_progressBar);
            _progressBar.width = 0;
            
            // Status text field
            _status = new TextField();
            _status.multiline = false;
            _status.width = 300;
            _status.x = 10;
            _status.y = 6;
            _status.text = "status";
            _status.setTextFormat(new TextFormat("Verdana", 10, 0xFFFFFF));
            _status.selectable = false;
            addChild(_status);
            
            // Browse button
            _browseButton = new TextButton("browse", new Rectangle(0, 0, 60, 14));
            _browseButton.x = 300;
            _browseButton.y = 15;
            addChild(_browseButton);
            _browseButton.addEventListener(MouseEvent.CLICK, OnBrowse);
            
            // Upload button
            _uploadButton = new TextButton("upload", new Rectangle(0, 0, 60, 14));
            _uploadButton.x = 360;
            _uploadButton.y = 15;
            addChild(_uploadButton);
            _uploadButton.addEventListener(MouseEvent.CLICK, OnUpload);
            
            // Upload button
            _doneButton = new TextButton("done", new Rectangle(0, 0, 60, 14));
            _doneButton.x = 360;
            _doneButton.y = 15;
            addChild(_doneButton);
            _doneButton.visible = false;
            _doneButton.addEventListener(MouseEvent.CLICK, OnDone);
            
        }
        
        public function UpdateStatusText(text:String):void
        {
            _status.text = text;
            _status.setTextFormat(new TextFormat("Verdana", 10, 0xFFFFFF));
        }
        
        public function OnBrowse(e:MouseEvent):void
        {
            _fileReferenceList = new FileReferenceList();
            _fileReferenceList.browse(new Array(new FileFilter("mp3s/images", "*.mp3;*.jpg;*.jpeg;*.png;*.gif;")));
            _fileReferenceList.addEventListener(Event.SELECT, OnFileSelect);
        }
        
        public function OnFileSelect(e:Event):void
        {
            UpdateStatusText("Selected " + _fileReferenceList.fileList.length + " files");
        }
        
        public function OnUpload(e:MouseEvent):void
        {
            _currentFileIndex = 0;
            _browseButton.visible = false;
            _uploadButton.visible = false;
            // Loop through files
            UploadFiles();
        }
        
        public function UploadFiles():void
        {
            // Reset the progress bar
            _progressBar.width = 0;
            // Get the file reference
            _currentFile = _fileReferenceList.fileList[_currentFileIndex++];
            // Update the status
            UpdateStatusText("Uploading [" + _currentFileIndex + " of " + _fileReferenceList.fileList.length + "]: " + _currentFile.name);
            // Add event listener
            _currentFile.addEventListener(ProgressEvent.PROGRESS, OnFileUploadProgress);
            _currentFile.addEventListener(Event.COMPLETE, OnFileUploadComplete);
            // Upload!
            _currentFile.upload(new URLRequest("http://music.lunchbin.com/demo/demo.php?action=upload"));
        }
        
        public function OnFileUploadProgress(e:ProgressEvent):void
        {
            _progressBar.width = Math.floor((e.bytesLoaded/e.bytesTotal) * 400);
        }
        
        public function OnFileUploadComplete(e:Event):void
        {
            if (_currentFileIndex < _fileReferenceList.fileList.length)
            {
                UploadFiles();
            }
            else
            {
                UpdateStatusText("Finished!");
                _doneButton.visible = true;                
            }
        }

        public function OnDone(e:MouseEvent):void
        {
            // Close the window
        }
    }
}

import flash.display.MovieClip;
import flash.display.Shape;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.MouseEvent;

class TextButton extends MovieClip
{
    private var _text:TextField;
    private var _bg:MovieClip;
    
    public function TextButton(text:String, size:Rectangle):void
    {
        _text = new TextField();
        _text.multiline = false;
        _text.text = text;
        _text.setTextFormat(new TextFormat("Verdana", 10, 0xFFFFFF));
        _text.selectable = false;
        _text.height = 16;
        _text.x = -Math.floor(_text.textWidth/2) - 2;
        _text.y = -Math.floor(_text.textHeight/2) - 2;
        addChild(_text);
        
        // Background (invisible)
        _bg = new MovieClip();
        _bg.graphics.beginFill(0xFFFFFF, 0);
        _bg.graphics.drawRect(0 - Math.floor(size.width/2), 0 - Math.floor(size.height/2), size.width, size.height);
        _bg.graphics.endFill();
        _bg.buttonMode = true;
        _bg.useHandCursor = true;
        addChild(_bg);
        
        addEventListener(MouseEvent.MOUSE_OVER, OnMouseOver);
        addEventListener(MouseEvent.MOUSE_OUT, OnMouseOut);
    }
    
    public function OnMouseOver(e:MouseEvent):void
    {
        _text.setTextFormat(new TextFormat("Verdana", 10, 0x000000));
    }
    
    public function OnMouseOut(e:MouseEvent):void
    {
        _text.setTextFormat(new TextFormat("Verdana", 10, 0xFFFFFF));
    }
}

















