/**
 * Copyright fiona_snow ( http://wonderfl.net/user/fiona_snow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nAnr
 */

package {
    import flash.display.Stage;
    import flash.events.FullScreenEvent;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.BitmapDataChannel;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(frameRate='60', width='465', height='465', backgroundColor='0x00')]
    
    public class Main extends Sprite {
        private var bmpdata:BitmapData;
        private var bmp:Bitmap;
        private var colortrans:ColorTransform;
        private var filter:BlurFilter;
        private var particles:Array;
        
        private var particle_number:int = 20000;
        private var size:int = 465;
        
        public var _x:Number = Math.random() * size;
        public var _y:Number = Math.random() * size;
        public var RGB:int, a:int;
        
        public function Main() {
            //初期設定
            init();
            
            //イベント監視
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
            stage.addEventListener(MouseEvent.CLICK, clickaction);
        }
        
        public function init():void {
            a = 2;
            RGB = 0xff0000;
            
            //BitmapDataを作成
            bmpdata = new BitmapData(size, size, false, 0x000000);
            
            //Bitmapを作成
            bmp = new Bitmap(bmpdata);
            //表示リストに追加
            addChild(bmp);
            
            //エフェクト
            colortrans = new ColorTransform( 0.95, 0.99, 0.99 );
            filter     = new BlurFilter( 2, 2, 1 );
            
            //パーテイクル
            particles = new Array(particle_number);
            for(var i:int = 0; i < particle_number; i++){
                //配列particlesにParticleインスタンスを格納
                particles[i] = new Particle(Math.random() * size, Math.random() * size);
            }
        }
        
        private function clickaction(e:MouseEvent):void {
            
            if(a == 1){
                RGB = 0xff0022;
                a++;
            }else if(a == 2){
                RGB = 0x55dd00;
                a++;
            }else if(a == 3){
                RGB = 0x0022ff;
                a = 1;
            }
        }
        
        private function enterframeHandler(e:Event):void {
            //パーティクルの描画
            bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter );
            bmpdata.colorTransform( bmpdata.rect, colortrans );
            
            _x += Math.random() * 17;
            _y += Math.random() * 11;
            
            if(_x > 2000 || _y > 2000){
                _x += -_x + Math.random() * 33;
                _y += -_y + Math.random() * 22;
            }else if(_x < -2000 || _y < -size -2000){
                _x += -_x - Math.random() * 27;
                _y += -_y - Math.random() * 33;
            }
            
            bmpdata.lock();
            for(var  i:int = 0; i < particle_number; i++){
                var p:Particle = particles[i];
                
                var diffX:Number = _x - p.x;
                var diffY:Number = _y - p.y;
                
                var acc:Number = 200 / (diffX * diffX + diffY * diffY);
                var accX:Number = acc * diffX;
                var accY:Number = acc * diffY;
                
                p.x += p.vx += accX;
                p.y += p.vy += accY;
                
                p.vx *= 0.96;
                p.vy *= 0.96;
                
                //ステージ
                if(p.x > size)　p.x -= size;
                else if(p.x < 0) p.x += size;
                if(p.y > size) p.y -= size;
                else if(p.y < 0) p.y += size;
                
                bmpdata.setPixel(p.x, p.y, RGB);
            }     
            bmpdata.unlock();
        }
    }
}

//パーティクルクラス
class Particle {
    //位置
    public var x:Number;
    public var y:Number;
    //加速度
    public var ax:Number = 0;
    public var ay:Number = 0;
    //速度
    public var vx:Number = 0;
    public var vy:Number = 0;
    function Particle( px:Number, py:Number ) {
        x = px;
        y = py;
    }
}