/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nAdb
 */

package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import flash.display.Sprite;
    import flash.events.Event;
 
    [SWF(backgroundColor="0x414647")]
    public class Main extends Sprite
    {
        public var world:b2World;
        public var scale:Number = 10;
        public var box2dMouseY:Number;
        public var box2dMouseX:Number;
 
        public function Main()
        {
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
            var gravity:b2Vec2 = new b2Vec2(0, 0);
            world = new b2World(worldAABB, gravity, true);
            trace( "world.GetBodyCount() : " + world.GetBodyCount() );
 
            var draw:b2DebugDraw = new b2DebugDraw();
            draw.m_sprite = this;
            draw.m_drawScale = scale;
            draw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            trace( "world.GetBodyCount() : " + world.GetBodyCount() );
            world.SetDebugDraw(draw);
 
            Shape.world = world;
            Shape.scale = scale;
            Shape.create( { shape:Shape.RECT, x:0, y:465, width:465, height:1 } );
 
            var bodyB:b2Body = Shape.create( { shape:Shape.CIRCLE, x:200, y:180, radius:17, density:0, restitution:0.6, name:"b" } );
            var bodyA:b2Body = Shape.create( { shape:Shape.RECT, x:220, y:180, width:50, height:20, density:1, restitution:0.8 , name:"a" } );
 
            var joint:b2RevoluteJointDef = new b2RevoluteJointDef();
            joint.Initialize(bodyA, bodyB, new b2Vec2(bodyA.GetWorldCenter().x -2.5, bodyA.GetWorldCenter().y));
            joint.lowerAngle = 10 / (180/Math.PI);
            joint.upperAngle = 50 / (180/Math.PI);
            joint.enableLimit = true;
            joint.motorSpeed = 4;
            
            world.CreateJoint(joint);
 
            new Additions(this);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        private function onEnterFrame(event:Event):void 
        {
            world.Step(1 / 60, 10);
            box2dMouseX = stage.mouseX / scale;
            box2dMouseY = stage.mouseY / scale;
        }
   }
}
 
import Box2D.Collision.b2AABB;
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2Shape;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
import Box2D.Dynamics.Joints.b2MouseJoint;
import Box2D.Dynamics.Joints.b2MouseJointDef;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
 
class Shape
{
    public static const CIRCLE:int = 0;
    public static const RECT:int = 1;
 
    public static var world:b2World;
    public static var scale:Number;
 
    public static function addVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
    }
 
    public static function setVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
    }
 
    public static function addAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
    }
 
    public static function setAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
    }
 
    public static function create(params:Object):b2Body
    {
        var def:b2BodyDef = new b2BodyDef();
        if (params.angle) def.angle = params.angle * Math.PI / 180;
 
        var shape:b2ShapeDef;
        if (params.shape == Shape.RECT)
        {
            def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
            shape = new b2PolygonDef();
            b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
        }
        else if (params.shape == Shape.CIRCLE)
        {
            def.position.Set(params.x / scale, params.y / scale);
            shape = new b2CircleDef();
            b2CircleDef(shape).radius = params.radius / scale;
        }
 
        shape.density = params.density;
        shape.restitution = params.restitution;
 
        var body:b2Body = world.CreateBody(def);
        body.CreateShape(shape);
 
        if (shape.density > 0) body.SetMassFromShapes();
        if (body.m_userData && params["name"]) 
        {
            Sprite(body.m_userData).name = params["name"];
            trace( "Sprite(body.m_userData).name : " + Sprite(body.m_userData).name );
            
        }
        return body;
    }
}

class Additions
{
    private var main:Main;
    private var _mouseJoint:b2MouseJoint;
    private var timeStep:Number = 1/60;
    public function Additions(mainArg:Main)
    {
        main = mainArg;
        main.stage.addEventListener(MouseEvent.MOUSE_DOWN, createMouse);
        main.stage.addEventListener(MouseEvent.MOUSE_UP, destroyMouse);
        main.addEventListener(Event.ENTER_FRAME, updateMouse);
    }
    
    /**
     * Taken from actionsnippet aka zevan roser's QuickBox2D class from the quickbox2D library
     * @param    e
     */
    private function createMouse(e:MouseEvent):void 
    {
            var body:b2Body = GetBodyAtMouse();
            var _mouseJointDef:b2MouseJointDef
            if (body /*&& body.para*/)
            {
                _mouseJointDef=new b2MouseJointDef();
                _mouseJointDef.body1 = main.world.GetGroundBody();
                _mouseJointDef.body2 = body;
                _mouseJointDef.target.Set(main.box2dMouseX, main.box2dMouseY);
                _mouseJointDef.maxForce=3000;
                _mouseJointDef.timeStep=timeStep;
                _mouseJoint=main.world.CreateJoint(_mouseJointDef) as b2MouseJoint;
            }
        }
    /**
     * Taken from aka actionsnippet zevan roser's QuickBox2D class from the quickbox2D library
     * @param    e
     */
        
    private function destroyMouse(evt:*):void 
    {
        if (_mouseJoint) 
        {
            trace( "_mouseJoint : " + _mouseJoint );
            main.world.DestroyJoint(_mouseJoint);
            _mouseJoint=null;
        }
    }
    /**
     * Taken from actionsnippet or zevan roser's QuickBox2D class from the quickbox2D library
     * @param    e
     */
    private function GetBodyAtMouse(includeStatic:Boolean = false):b2Body 
    {
        var mouseXWorldPhys:Number = main.box2dMouseX;
        var mouseYWorldPhys:Number = main.box2dMouseY;
        var _mousePVec:b2Vec2 = new b2Vec2(mouseXWorldPhys, mouseYWorldPhys);
        var aabb:b2AABB = new b2AABB();
        aabb.lowerBound.Set(mouseXWorldPhys - 0.001, mouseYWorldPhys - 0.001);
        aabb.upperBound.Set(mouseXWorldPhys + 0.001, mouseYWorldPhys + 0.001);
        var k_maxCount:int=10;
        var shapes:Array = new Array();
        var count:int = main.world.Query(aabb, shapes, k_maxCount);
        var body:b2Body=null;
        for (var i:int = 0; i < count; ++i) {
            if (shapes[i].GetBody().IsStatic()==false||includeStatic) {
                var tShape:b2Shape=shapes[i] as b2Shape;
                var inside:Boolean=tShape.TestPoint(tShape.GetBody().GetXForm(),_mousePVec);
                if (inside) {
                    body=tShape.GetBody();
                    break;
                }
            }
        }
        return body;
    }
    /**
     * Taken from aka actionssnippet or zevan roser's QuickBox2D class from the quickbox2D library
     * @param    e
     */
    
    private function updateMouse(e:Event):void 
    {
            if (_mouseJoint) {
                 
                var p2:b2Vec2=new b2Vec2(main.box2dMouseX,main.box2dMouseY);
                _mouseJoint.SetTarget(p2);
            }
        
    }
}

























































