/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n9aS
 */

// forked from grLynx's flash on 2009-3-17
package {
        import org.papervision3d.view.BasicView;
        import org.papervision3d.materials.BitmapMaterial;
        import org.papervision3d.materials.utils.MaterialsList;
        import org.papervision3d.objects.primitives.Cube;
        
        import net.hires.debug.Stats;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
        import flash.display.BitmapData;
        
        import flash.geom.Point;

	[SWF(backgroundColor="#000000", frameRate="60")]

	public class PrivyetPaperVision3D extends BasicView	{
		private var cube:Cube;
		private var materials:MaterialsList;
                private var bmp:BitmapData;
                private var offsets:Array;
                private var deltas:Array;
                private var seed:Number = Math.random()*100;
		
		public function PrivyetPaperVision3D() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		public function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);

                        bmp = new BitmapData(100, 100, false, 0);
                        materials = new MaterialsList( { all : new BitmapMaterial( bmp ) } );
                        cube = new Cube( materials, 500, 500, 500, 5, 5, 5 );

                        offsets = [];
                        deltas = [];
                        for (var i:int = 0; i < 3; i++) {
                            offsets[i] = new Point(0, 0);
                            deltas[i] = new Point((1 - 2*Math.random())*5, (1 - 2*Math.random())*5);
                        }
                        
			scene.addChild(cube);

			// Запуск счётчика кадров
			addChild( new Stats );

			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void {
			// Расчёт сцены
                        cube.rotationX += 0.01 / Math.PI * 180;
                        cube.rotationY += 0.02 / Math.PI * 180;
                        cube.rotationZ += 0.03 / Math.PI * 180;


                        for (var i:int = 0; i < 3; i++) {
                            offsets[i].x += deltas[i].x;
                            offsets[i].y += deltas[i].y;
                        }
                        bmp.fillRect(bmp.rect, 0);
                        bmp.perlinNoise(50, 50, 3, seed, true, true, 2, false, offsets);
                        
                        renderer.renderScene( scene, camera, viewport );
		}
	}
}