/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n99D
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite
	{
		private var _arrayBtn:Array;
		private var _clearbtn:CreateRoundRectButton;
		private var _onPositionX:Number;
		private var _cleard:Boolean = false;
		private var _numArray:Array = new Array();
		private var _first:Boolean = true;
		
		public function Main()
		{
			this.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
		}
		
		private function init(e:Event):void
		{
			this.removeEventListener(Event.ADDED_TO_STAGE, init, false);
			createBtn();
			this.addEventListener(Event.ENTER_FRAME, onEnter, false, 0, true);
		}
		
		private function createBtn():void
		{
			_arrayBtn = new Array();
			var btnNum:Number = 15;
			
			for (var i:int = 0; i < btnNum; i++) {
				var button:CreateRoundRectButton = 
					new CreateRoundRectButton(0, 20 * i, 100, 20, 10, 1, (Math.random() * 0.9 + 0.1) * 0xFFFFFF, "ボタン" + (i + 1), 0x000000);
				_arrayBtn.push(button);
			}
			
			var len:int = _arrayBtn.length;
			for (var i:int = 0; i < len; i++) {
				this.stage.addChild(_arrayBtn[i]);
			}
			
			_clearbtn = new CreateRoundRectButton(0, 20 * (btnNum + 1), 100, 20, 10, 1, (Math.random() * 0.9 + 0.1) * 0xFFFFFF, "clear", 0x000000);
			this.stage.addChild(_clearbtn);
			_clearbtn.setBtnX(this._onPositionX);
			_clearbtn.addEventListener(MouseEvent.CLICK, clear, false, 0, true);
			
		}
		
		// クリアメソッド
		private function clear(e:MouseEvent):void
		{	
			this._first = true;
			this._cleard = true;
			//this._onPositionX = 0;
//			var len:int = _arrayBtn.length;
//			for (var i:int = 0; i < len; i++) {
//				//this.stage.removeChild(_arrayBtn[i]);
//			}
//			this.stage.removeChild(_clearbtn);
//			//createBtn();
		}
		
		private function onEnter(e:Event):void
		{
			_clearbtn.setBtnX(0);
			//　クリアボタンが押された
			//trace(this._cleard);
			if (this._cleard) {
				var len:int = _arrayBtn.length;
				//trace("_onPosition",this._onPositionX);
				for (var i:int = 0; i < len; i++) {
					//trace( _arrayBtn[i].getBtnX());
					if (_first) {
						_numArray[i] = _arrayBtn[i].getBtnX();
					}
					else 
					{
						if (_numArray[i] > 0) {
							_numArray[i] -= 2 
						}
						else {
							_numArray[i] = 0;
						}
						trace(_numArray[i]);
						_arrayBtn[i].setBtnX(_numArray[i]);
					}
				}
				_first = false;
					//this.stage.removeChild(_arrayBtn[i]);
			}
			
			if (this._cleard) {
				for (var i:int = 0; i < len; i++) {
					this._cleard = false;
					if (Math.abs(_arrayBtn[i].getBtnX()) != 0) {
						this._cleard = true;
					}
				}
			}
		}
	}
}

//import fl.motion.Color;

import flash.display.Shape;
import flash.display.SimpleButton;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.utils.Timer;

class CreateRoundRectButton extends Sprite
{
	private var _x:Number;
	private var _y:Number;
	private var _w:Number;
	private var _h:Number;
	private var _rad:Number;
	private var _linW:Number;
	private var _col:uint;
	private var _txt:String;
	private var _txtCol:uint;
	
	private var _btn:SimpleButton;
	private var _labl:TextField;
	private var _onPositionX:Number = 0;
	
	public function CreateRoundRectButton(x:Number, y:Number, w:Number, h:Number, rad:Number,
										  linW:Number, col:uint, txt:String, txtCol:uint) {
		_x = x;
		_y = y;
		_w = w;
		_h = h;
		_rad = rad;
		_linW = linW;
		_col = col;
		_txt = txt;
		_txtCol = txtCol;

		_btn = createBtn();
		addChild(_btn);
		_labl = createLabel();
		_labl.mouseEnabled = false;
		addChild(_labl);
		
		this.addEventListener(Event.ENTER_FRAME, onEnter);
		this.addEventListener(MouseEvent.CLICK, move, false, 0, true);
		
	}
	
	private function createBtn():SimpleButton
	{		
		//	interpolateColor(fromColor:uint, toColor:uint, progress:Number):uint
		//  [静的] あるカラー値から別のカラー値にスムーズにブレンドします。
		// var ovCol:uint = Color.interpolateColor(_col, 0xFFFFFF, 0.3);
		//var dnCol:uint = Color.interpolateColor(_col, 0x000000, 0.3);
		var ovCol:uint = 0xB0C4DE;
		var dnCol:uint = 0x191970;		var btn:SimpleButton = new SimpleButton();
		btn.upState = createRoundRect(_col);
		btn.overState = createRoundRect(ovCol);
		btn.downState = createRoundRect(dnCol);
		btn.hitTestState = btn.upState;
		return btn;
	}
	
	private function createLabel():TextField
	{
		var txt:TextField = new TextField();
		txt.width = _w;
		txt.height = _h;
		txt.x = _x;
		txt.y = _y + 2;
		
		var format:TextFormat = new TextFormat();
		format.font = "Gothic";
		format.color = _txtCol;
		format.size = 10;
		format.bold = true;
		format.align = TextFormatAlign.CENTER;
		
		txt.defaultTextFormat = format;
		txt.text = _txt;
		txt.selectable = false;
		
		return txt;
	}
	
	private function createRoundRect(col:uint):Shape
	{
		var rRect:Shape = new Shape();
		rRect.graphics.lineStyle(_linW, _col);
		rRect.graphics.beginFill(col, 0.5);
		rRect.graphics.drawRoundRect(_x, _y, _w, _h, _rad);
		rRect.graphics.endFill();
		return rRect;
	}
	
	private function move(e:MouseEvent):void {
		var progress:Number = Math.random() * 100;
		//trace(progress);
		if (this._onPositionX == 0) {
			this._onPositionX = progress;
		}
		else {
			this._onPositionX += progress;
		}
	}
	
	private function onEnter(e:Event):void
	{
		this._btn.x = this._btn.x * 0.9 + this._onPositionX * 0.1;
		this._labl.x = this._labl.x * 0.9 + this._onPositionX * 0.1;
	}
	
	public function getBtnX():Number
	{
		return this._btn.x;
	}
	
	public function setBtnX(arg:Number):void
	{
		this._btn.x = arg;
		this._labl.x = arg;
	}
}