/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n8tW
 */

// forked from ChevyRay's Blob Trail Effect
package
{
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.display.DisplayObjectContainer;
    import flash.geom.ColorTransform;
    import flash.ui.Mouse;
    
    
    public class BlobTrail  extends Sprite
    {
        private const FRAMERATE:int = 60;
        private var _stageW:int;
        private var _stageH:int;
        private var _ct:ColorTransform;
        private const EASING_FACTOR:Number = 0.15;
        
        public var bitmap:Bitmap;
        public var canvas:BitmapData;
        public var circle:Shape = new Shape();
        public var matrix:Matrix = new Matrix();
        public var overlay:Shape = new Shape();
        
        public function BlobTrail():void
        {
            stage.frameRate = FRAMERATE;
            
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.quality = StageQuality.LOW;
            stage.stageFocusRect = false;
            stage.tabChildren = false;
            
            _stageW = stage.stageWidth;
            _stageH = stage.stageHeight;
            
            Mouse.hide();
            
            // run app
            run(); 
        }        
        
        private function run():void 
        {
            var xorTexture:BitmapData = new XORTexture(_stageW, _stageH);            
            _ct = new ColorTransform(1, 1, 1, .15);
            
            // background
            graphics.beginFill(0x333333);
            graphics.drawRect(0, 0, _stageW, _stageH);
            
            // main display object
            canvas = new BitmapData(_stageW, _stageH, true, 0);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            
            // mouse trailer
            //circle.graphics.beginFill(0x00CED1);
            circle.graphics.beginBitmapFill( xorTexture );
            circle.graphics.drawCircle(0, 0, 16);
            circle.filters = [new BlurFilter(6, 6, 1)];
            
            //overlay.graphics.beginFill(0x000000, 0.05);
            overlay.graphics.beginBitmapFill( xorTexture );
            overlay.graphics.drawRect(0, 0, _stageW, _stageH);
            
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            canvas.draw(overlay, null, _ct);            
            var dx:Number = mouseX - matrix.tx;
            var dy:Number = mouseY - matrix.ty;
            matrix.tx += dx * EASING_FACTOR;
            matrix.ty += dy * EASING_FACTOR;
            canvas.draw(circle, matrix);
        }      
    }
}

import flash.display.BitmapData;

internal class XORTexture extends BitmapData
{   
    public function XORTexture(width:int, height:int)
    {
        super(width, height, false, 0x0);
        var color:uint;
        var rbg_color:uint;
        
        for (var w:int = 0; w < width; w++)
        {
            for (var h:int = 0; h < height; h++)
            {
                color = w ^ h;
                rbg_color = color << 16 | color << 8 | color;
                this.setPixel(w, h, rbg_color);
            }
        }
    }
}