/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n8s9
 */

package {

    import flash.display.Sprite
    import flash.display.Graphics
    import flash.text.TextField
    import flash.text.TextFormat
    
    public class FlashTest extends Sprite {
        
        private var _sequence:Array
        private var _tableau:Array
        
        private var _debug:TextField
        private var _canvas:Sprite
        
        public function FlashTest() {
            // data
            var seq:Array = [8, 6, 6, 4, 4, 4, 4, 4, 4]
            var i:int = -1
            
            // init
            _sequence = seq.concat()
            _tableau = []
            for(i=0; i<_sequence.length; i++){
                _tableau[i] = new Array(_sequence[i])
                for(var j:int=0; j<_sequence[i]; j++){
                    _tableau[i][j] = -1
                }
            }
            
            // fill the tableau
            var x:int
            for(i=_sequence.length-1; i>0; i--){
                while(_sequence[i] > 0){
                    x = pick(i)
                    push(i, x)
                }
            }
            
            output(seq)
        }
        
        private function pick(i:int):int {
            lbl : for(var j:int=0; j<i-1; j++){
                for(var k:int=0; k<_tableau[j].length; k++){
                    if(_tableau[j][k] == i+1) continue lbl
                }
                if(_sequence[j] > _sequence[j+1]){
                    return j
                }
            }
            return i-1
        }
        
        private function push(x:int, y:int):void {
            _sequence[x] -= 1
            _sequence[y] -= 1
            _tableau[x][_sequence[x]] = y + 1
            _tableau[y][_sequence[y]] = x + 1
        }
        
        private function output(input:Array):void {
            var i:int, j:int
            
            // print the tableau
            var result:String = "sequence: " + input.join(" ") + "\n\n"
            for(i=0; i<_tableau.length; i++) result += (i+1) + " | " + _tableau[i].join(" ") + "\n"
            with(addChild(_debug = new TextField)){
                text = result
                autoSize = "left"
            }
            
            // render the tableau
            var centerX:Number = stage.stageWidth / 2
            var centerY:Number = stage.stageHeight / 2
            var angle:Number
            var x1:Number, y1:Number, x2:Number, y2:Number
            
            addChild(_canvas = new Sprite)
            var g:Graphics = _canvas.graphics
            
            // render edges
            g.lineStyle(1, 0x0)
            for(i=0; i<_tableau.length; i++){
                angle = Math.PI*2 * i/_tableau.length
                x1 = centerX + 100 * Math.cos(angle)
                y1 = centerY + 100 * Math.sin(angle)
                for(j=0; j<_tableau[i].length; j++){
                    angle = Math.PI*2 * (_tableau[i][j]-1)/_tableau.length
                    x2 = centerX + 100 * Math.cos(angle)
                    y2 = centerY + 100 * Math.sin(angle)
                    g.moveTo(x1, y1)
                    g.lineTo(x2, y2)
                }
            }
            g.lineStyle()
            
            // render vertices
            g.beginFill(0x6699cc)
            for(i=0; i<_tableau.length; i++){
                angle = Math.PI*2 * i/_tableau.length
                x1 = centerX + 100 * Math.cos(angle)
                y1 = centerY + 100 * Math.sin(angle)
                g.drawCircle(x1, y1, 20)
                var lbl:TextField = new TextField
                lbl.autoSize = "center"
                lbl.defaultTextFormat = new TextFormat(null, 16)
                lbl.text = (i+1).toString()
                lbl.x = x1 - lbl.width/2
                lbl.y = y1 - lbl.height/2
                _canvas.addChild(lbl)
            }
            g.endFill()
        }
        
    }
    
}