/**
 * Copyright yashikei ( http://wonderfl.net/user/yashikei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n8HP
 */

package {
    import __AS3__.vec.Vector;
    
    import flash.events.Event;
    import flash.filters.*;
    
    import frocessing.color.ColorHSV;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.core.geom.renderables.Line3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;

    public class PapervisionTest extends BasicView
    {
        private var sphere:Sphere;
        private var line:Lines3D;
        private const A:Number = 10.0, B:Number = 25.0, C:Number = 8.0/3.0, D:Number = 0.01;
        
        private var xx:Number, yy:Number, zz:Number;
        
        //HSB->RGB
        private var hsv:ColorHSV;
        private var glow:GlowFilter;
        
        //Planeを格納するためのVector
        private var particles:Vector.<Plane>;
        
        public function PapervisionTest()
        {
            super(465, 465, true, false, CameraType.SPRING);
            //初期化
            hsv = new ColorHSV(0, 1, 1);
            glow = new GlowFilter(0, 1, 8, 8, 2);
            particles = new Vector.<Plane>();
            xx = yy = zz = 1;
            
            //球の生成
            sphere = new Sphere(new ColorMaterial(0xffffff), 3);
            sphere.x = sphere.y = sphere.z = 1;
            scene.addChild(sphere);
            
            //フィルターを有効にする
            sphere.useOwnContainer = true;
            sphere.filters = [new BlurFilter(8,8,4), glow];
            //カメラが追うものを球に設定
            camera.target = sphere;
            //各パラメータの設定
            SpringCamera3D(camera).mass = 20;
            SpringCamera3D(camera).damping = 30;
            SpringCamera3D(camera).stiffness = 8;
            
            line = new Lines3D(null);
            scene.addChild(line);
            startRendering();
        }

    }
        
        //public function onFlame(event:Event):void{
        //}
        
        
}