/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n7lF
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.display.Bitmap;
    import flash.display.BitmapData;
	import flash.filters.BlurFilter;

	[SWF(width = "460", height = "460", backgroundColor = "0x000000", fps = "30")] 
	public class Practice17 extends Sprite{
		private var bitmap:BitmapData;
		private var blur:BlurFilter = new BlurFilter(4, 4, 6);
		private var point:Point = new Point();
		private var count:int;
		private var circle:Circle;
		
		public function Practice17() {
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			var img:Bitmap = new Bitmap(bitmap);
			stage.addChild(img);
			stage.addEventListener(Event.ENTER_FRAME, update);
			circle=new Circle(230, 230, 230);
			this.addChild(circle);
		}
		
		private function update(e:Event):void {
			circle.update();
			bitmap.lock()
			bitmap.applyFilter(bitmap, bitmap.rect, point, blur)
			bitmap.draw(this);
			bitmap.unlock();
		}
	}
}
import flash.display.MovieClip;
class Circle extends MovieClip {
	private var radius:Number;
	public var count:int;
	
	public function Circle(xx:Number,yy:Number,rr:Number):void {
		x = xx;
		y= yy;
		radius = rr;
	}
	
	public function update():void {
		graphics.clear();
		count = (count + 1) % 400;
		for (var i:int = 0; i < count; i++) {
			var r:Number = i / count;
			graphics.lineStyle(1, getColor(r));
			if (i == 0) {
				graphics.moveTo(radius *r* Math.cos(i), radius * Math.sin(i));
			}else {
				graphics.lineTo(radius *r* Math.cos(i), radius * Math.sin(i));
			}
		}
	}

	private function getColor(v:Number):Number {
		var r:Number = Math.cos(Math.PI * ((v - 0.81) * 1.1)) * 255;
		var g:Number = Math.cos(Math.PI * ((v - 0.50) * 1.0)) * 255;
		var b:Number = Math.cos(Math.PI * ((v - 0.19) * 1.1)) * 255;
		r = Math.max(0, Math.min(255, r));
		g = Math.max(0, Math.min(255, g));
		b = Math.max(0, Math.min(255, b));
		return (r<<16)+(g<<8)+b;
	}
}