/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n6zn
 */

/**
 * ◆よくきた。
 * 
 * ◆ここは　7ばんめの
 * 　「おまえのばしょ」だ。
 * 
 * ◆しかし　いまは
 * 　わたしのばしょだ。
 * 
 * ◆うばいかえせばよい。
 * 
 * ◆・・・・できるものなら。
 * 
 * 
 * MOTHER2のルミネホール風エフェクト
 * @author alumican.net
 */
package
{
	import com.bit101.components.Label;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.ShaderFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Camera;
	import flash.media.Video;
	import net.hires.debug.Stats;
	
	public class Main extends Sprite
	{
		//----------------------------------------
		//CLASS CONSTANTS
		
		private const W:int = 465;
		private const H:int = 465;
		
		
		
		
		
		//----------------------------------------
		//VARIABLES
		
		private var _camera:Camera;
		private var _video:Video;
		private var _filter:LumineHallFilter;
		private var _canvas:BitmapData;
		private var _canvasRect:Rectangle;
		private var _canvasPoint:Point;
		private var _canvasMatrix:Matrix;
		
		
		
		
		
		//----------------------------------------
		//STAGE INSTANCES
		
		
		
		
		
		//----------------------------------------
		//METHODS
		
		public function Main():void
		{
			//Wonderfl.capture_delay(10);
			Wonderfl.disable_capture();
			
			_camera = Camera.getCamera();
			if (_camera)
			{
				var h0:int = 32;
				var h1:int = 105;
				
				_canvas = new BitmapData(W, H - h0 - h1, false, 0x0);
				_canvasRect = new Rectangle(0, 0, _canvas.width, _canvas.height);
				_canvasPoint = new Point();
				_canvasMatrix = new Matrix(-1, 0, 0, 1, _canvas.width, 0);
				
				var bmp:Bitmap = addChild( new Bitmap(_canvas) ) as Bitmap;
				bmp.y = h0;
				
				_video = new Video(_canvas.width, _canvas.height);
				_video.attachCamera(_camera);
				
				_filter = new LumineHallFilter();
				
				var frame0:DisplayObjectContainer = addChild( Base64ImageLoader.load("iVBORw0KGgoAAAANSUhEUgAAAdEAAAAgCAIAAADCGNXEAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAHHRFWHRTb2Z0d2FyZQBBZG9iZSBGaXJld29ya3MgQ1M0BrLToAAABSlJREFUeJztXTFyG0cQ7CtdcAECBlQJgQIFdhWYWRkTxwJ/oR/YT9ET/AtDv1AIle0qBQ4QMGDA4AKWVgEhco/c2ZvB7uIWvO5EU1ezM3NzrZPQ1QSb1fISDS7WvXPYbrriMbBa7gBsd8uTrM942pj8YVzz81XUb1frvmnw8dOVc+6vPzelY3y56d59A7ACmvdnJ1ef8bQx+cO45uerqd86BwBuj+Jxg0c4d3r1GU8bkz+Ma36+mvrN6s0lGqzWvXP4uum08YfewZLvxw//94b9bA31GafH5A/jufKnRQM0aO7fz8oY2H7uTPn4ctMAaJZo0Lw/cw7Y2Ptq6vvIVZ9x3pj8YTxj/tj13D8228/drusBLPvuYt1XpaEAoB5XdUz+MJ43f+x67uBNDleZhjKYjXpchTH5w3je/AnpuQqtxMcgXzqr0VByaTS5ekk5KXOm9M3VK9cMCfXJH/Jntvx5pudKWgkEzcLPj+gsDxoKhtpKsK+UE4l9jWZUr9HoQfIeVPsR4pS+4Zpl5i++Hw/kD/kzK/68Ol+8vbjqP366+m39y///bK//a3ddf9veLe7ax+v/bs9vr7t339qzm7O79vp28ZADIBj7Z1//ehes8/r3Nth3tdwFcoZ1Do/lexzP0e3nfHEbjP292frK9cP7SZv/8DnJH/KH/BnjTwtfExn+A+IUmoUESWfx6zzqHZE62fUXzZxSjnw2z37s9cP7yTd/Xfshfw7rS/6E6kzFn2a1vARkrUTQLDSw+tcGZwt76MQ5PU1HytHsR4pT+qo0o0zzl96PBuQP+fMi+dMCT3WHi3XvgO3fHSD42iQe+Gft/rjB2eweukgvQUsK5+j2E0Za33HNKNf85fdD/pA/s+WP7M91oq/Nv77dLQNeOZfgj3NH9Po5he9Pmke3HwT9eil9rb5F+/zH3A/5Q/7MjT8xf25Y+7BqN6fyM+y6e0naj0k7m27+yfZD/sT3Q/7E93Mi/Bnz5/q6hnDdh0pDmcqfKPn4JI1JU0exHzHH2teqM6bMX7o++UP+zJU/UX/u8K6k6wNIvsJgnYjmEtREcvn+5NiHqo5xPyl9Nf7NXPOXrk/+kD+z5U/MnwvB+ybFvq9N8hVC8NCFfXNlfJHW+0qp4+9E4yvU7Efj30yZ//DnSP6QP+TP2H3F/Lml4Uyai3x2PCfXnGl1Du9r9yeG62Qb7aj1x/uSP/G+5E+873H589OfK2hDVmh8hYN8hW+uhC/SfF8J+7H6CgdnE/ybKfOXrp+tL/kTP0v+1Mef9v4PSRuyPu+BbqI5Zfxey2y+PwX8e5f2o8Fhf1v2UPg3NfVzPd/S9cmf5yB/Xhh/9u/cB4+bH9/rI3jmg5PyrbFf3/a9lim+v++D/KnuPWU/kj8xpb5fx78Ozx9q7UX+kD/kz3P+7N+5k+Nw39yTOsb8U4HGnzhnkD9xkD9xHJM/ez1XQq7PDpr6qu/B1GgoCt+fdbapYPUnptQX+6boieQP+UP+DPNH3rnTQ/498k9zQlpbbbwnjg3yh0hBAf68Ol+8hdEHd8zY4IP7EPseTKu3MVdcwwxzjskfxrXxpxY9V8IxfZTEywP5Q6SgBH+q1xaUPjjpegWfy2qYYc4gf4gUZOdPle/cocfNqqFIqI27tc3jo+bZxkH+TI2aZxtHYf7E/LlTxWGPm+SDOx2/ZM3znMps5E+d85zKbDXwp0Y9lxockQLyh0hBaf5UqS3YvydUVbOyzzu1zeOj5tk0IH+mRc2zaVCUPz8ATyikGW02MpgAAAAASUVORK5CYII=") ) as DisplayObjectContainer;
				var frame1:DisplayObjectContainer = addChild( Base64ImageLoader.load("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") ) as DisplayObjectContainer;
				frame1.y = H - h1;
				
				addEventListener(Event.ENTER_FRAME, _update);
				
				var stats:Stats = addChild( new Stats() ) as Stats;
				stats.y = H - 45;
			}
			else
			{
				new Label(this, 10, 10, "NO WEBCAM");
			}
		}
		
		private function _update(e:Event):void
		{
			_canvas.draw(_video, _canvasMatrix);
			_canvas.applyFilter(_canvas, _canvasRect, _canvasPoint, _filter);
		}
	}
}





/**
 * カスタムフィルタ
 */
import flash.display.Shader;
import flash.filters.ShaderFilter;
import flash.utils.ByteArray;
class LumineHallFilter extends ShaderFilter
{
	private static var _data:Vector.<int> = Vector.<int>([
		-91, 1, 0, 0, 0, -92, 14, 0, 76, 117, 109, 105, 110, 101, 72, 97, 108, 108, 68, 111, 116, 115, -96, 12, 110, 97, 109, 101, 115, 112, 97, 99, 101, 0, 65, 108, 117, 109, 105, 99, 97, 110, 0, -96, 12, 118, 101, 110, 100, 111, 114, 0, 65, 108, 117, 109, 105, 99, 97, 110, 46, 110, 101, 116, 0, -96, 8, 118, 101, 114, 115, 105, 111, 110, 0, 1, 0, -96, 12, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 76, 117, 109, 105, 110, 101, 32, 72, 97, 108, 108, 32, 102, 114, 111, 109, 32, 77, 79, 84, 72, 69, 82, 50, 0, -95, 1, 2, 0, 0, 12, 95, 79, 117, 116, 67, 111, 111, 114, 100, 0, -93, 0, 4, 115, 114, 99, 0, -95, 2, 4, 1, 0, 15, 100, 115, 116, 0, -95, 1, 4, 2, 0, 15, 99, 111, 108, 111, 114, 48, 0, -94, 4, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94, 4, 109, 97, 120, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, -94, 4, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 62, 32, -96, -95, 61, -64, -64, -63, 62, 96, -32, -31, 63, -128, 0, 0, -95, 1, 4, 3, 0, 15, 99, 111, 108, 111, 114, 49, 0, -94, 4, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94, 4, 109, 97, 120, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, -94, 4, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 61, -128, -128, -127, 62, 0, -128, -127, 62, 64, -64, -63, 63, -128, 0, 0, -95, 1, 4, 4, 0, 15, 99, 111, 108, 111, 114, 50, 0, -94, 4, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94, 4, 109, 97, 120, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, -94, 4, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 62, -96, -96, -95, 62, -64, -64, -63, 62, 64, -64, -63, 63, -128, 0, 0, -95, 1, 4, 5, 0, 15, 99, 111, 108, 111, 114, 51, 0, -94, 4, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94, 4, 109, 97, 120, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, 63, -128, 0, 0, -94, 4, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 63, 48, -80, -79, 63, 112, -16, -15, 62, -16, -16, -15, 63, -128, 0, 0, -95, 1, 1, 0, 0, 2, 116, 104, 114, 101, 115, 104, 111, 108, 100, 0, -94, 1, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, 0, 0, -94, 1, 109, 97, 120, 86, 97, 108, 117, 101, 0, 63, -128, 0, 0, -94, 1, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 63, 0, 0, 0, -95, 1, 8, 1, -128, 8, 117, 115, 101, 71, 114, 97, 121, 115, 99, 97, 108, 101, 0, -94, 8, 109, 105, 110, 86, 97, 108, 117, 101, 0, 0, 0, -94, 8, 109, 97, 120, 86, 97, 108, 117, 101, 0, 1, 0, -94, 8, 100, 101, 102, 97, 117, 108, 116, 86, 97, 108, 117, 101, 0, 1, 0, 29, 6, 0, -63, 0, 0, 16, 0, 50, 0, 0, 16, 64, -128, 0, 0, 50, 6, 0, 32, 64, -128, 0, 0, 4, 7, 0, -63, 6, 0, -96, 0, 3, 7, 0, -63, 6, 0, 16, 0, 26, 6, 0, 49, 7, 0, 16, 0, 29, 7, 0, -63, 0, 0, -16, 0, 3, 7, 0, -63, 6, 0, -80, 0, 29, 6, 0, 49, 7, 0, 16, 0, 29, 7, 0, -63, 6, 0, 16, 0, 2, 7, 0, -63, 6, 0, -80, 0, 29, 7, 0, 49, 7, 0, 16, 0, 50, 0, 0, 16, 63, -128, 0, 0, 42, 7, 0, 32, 0, 0, -64, 0, 29, 1, -128, 64, 0, -128, 0, 0, 50, 0, 0, 16, 64, 64, 0, 0, 42, 0, 0, 16, 7, 0, -128, 0, 29, 1, -128, 32, 0, -128, 0, 0, 29, 1, -128, 16, 1, -128, 64, 0, 46, 1, -128, 16, 1, -128, -128, 0, 29, 1, -128, 64, 1, -128, -64, 0, 50, 0, 0, 16, 63, -128, 0, 0, 42, 7, 0, 16, 0, 0, -64, 0, 29, 1, -128, 32, 0, -128, 0, 0, 50, 0, 0, 16, 64, 64, 0, 0, 42, 0, 0, 16, 7, 0, -64, 0, 29, 1, -128, 16, 0, -128, 0, 0, 29, 2, -128, -128, 1, -128, -128, 0, 46, 2, -128, -128, 1, -128, -64, 0, 29, 1, -128, 32, 2, -128, 0, 0, 29, 1, -128, 16, 1, -128, 64, 0, 45, 1, -128, 16, 1, -128, -128, 0, 52, 0, 0, 0, 1, -128, -64, 0, 29, 1, 0, -13, 2, 0, 27, 0, 53, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 16, 63, -128, 0, 0, 29, 7, 0, -63, 6, 0, -80, 0, 1, 7, 0, -63, 0, 0, -16, 0, 29, 8, 0, -63, 7, 0, 16, 0, 48, 9, 0, -15, 8, 0, 16, 0, 29, 10, 0, -13, 9, 0, 27, 0, 50, 2, -128, -128, 1, 0, 0, 0, 40, 1, -128, -128, 2, -128, 0, 0, 29, 2, -128, 64, 0, -128, 0, 0, 52, 0, 0, 0, 2, -128, 64, 0, 42, 0, 0, 32, 10, 0, 0, 0, 29, 2, -128, -128, 0, -128, 0, 0, 29, 2, -128, 32, 2, -128, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 16, 10, 0, 0, 0, 1, 0, 0, 16, 10, 0, 64, 0, 29, 7, 0, -128, 0, 0, -64, 0, 1, 7, 0, -128, 10, 0, -128, 0, 50, 0, 0, 16, 64, 64, 0, 0, 4, 7, 0, 64, 0, 0, -64, 0, 3, 7, 0, 64, 7, 0, 0, 0, 42, 0, 0, 32, 7, 0, 64, 0, 29, 2, -128, -128, 0, -128, 0, 0, 29, 2, -128, 32, 2, -128, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 2, -128, -128, 0, 52, 0, 0, 0, 1, -128, 64, 0, 29, 1, 0, -13, 4, 0, 27, 0, 53, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 1, -128, -128, 0, 29, 1, 0, -13, 4, 0, 27, 0, 53, 0, 0, 0, 0, 0, 0, 0, 29, 1, 0, -13, 5, 0, 27, 0, 54, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 29, 2, -128, -128, 1, -128, 64, 0, 46, 2, -128, -128, 1, -128, -128, 0, 52, 0, 0, 0, 2, -128, 0, 0, 29, 1, 0, -13, 2, 0, 27, 0, 53, 0, 0, 0, 0, 0, 0, 0, 29, 1, 0, -13, 3, 0, 27, 0, 54, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0
	]);
	
	public function LumineHallFilter():void
	{
		var byte:ByteArray = new ByteArray();
		var n:int = _data.length;
		for (var i:uint = 0; i < n; ++i)
		{
			byte.writeByte(_data[i]);
		}
		super( new Shader(byte) );
	}
}





/**
 * Base64化された画像データを表示可能な形式に変換するクラス
 * 
 * 使い方 :
 * var data:String = "Base64化された画像データ";
 * var display:DisplayObjectContainer = Base64ImageLoader.load(data);
 * if (display != null)
 *     addChild(display);
 */
class Base64ImageLoader
{
    import flash.display.DisplayObjectContainer;
    import flash.display.Loader;
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;

    static public function load(data:String):DisplayObjectContainer
    {
        var byteArray:ByteArray;
        var base64Decoder:Base64Decoder;
        var loader:Loader;
        
        base64Decoder = new Base64Decoder();
        base64Decoder.decode(data);
        
        try {
            byteArray = base64Decoder.toByteArray();
            byteArray.position = 0;
        } catch (e:Error) {
            return null;
        }
        
        loader = new Loader();
        loader.loadBytes(byteArray);
        
        return loader;
    }
}