/**
 * Copyright atsushi015 ( http://wonderfl.net/user/atsushi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n6iZ
 */

package {
    import flash.display.Sprite;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var surface:BasicView = new BasicView;
            var sphere:Sphere = new Sphere(new HetaframeMaterial);
            
            addChild(surface);
            surface.scene.addChild(sphere);
            surface.startRendering();
        }
    }
}

	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.material.TriangleMaterial;
	import org.papervision3d.core.render.command.RenderTriangle;
	import org.papervision3d.core.render.data.RenderSessionData;
	import org.papervision3d.core.render.draw.ITriangleDrawer;
	
	/**
	* The WireframeMaterial class creates a wireframe material, where only the outlines of the faces are drawn.
	* <p/>
	* Materials collects data about how objects appear when rendered.
	*/
	class HetaframeMaterial extends TriangleMaterial implements ITriangleDrawer
	{
		
		/**
		* The WireframeMaterial class creates a wireframe material, where only the outlines of the faces are drawn.
		*
		* @param	asset				A BitmapData object.
		*/
		public function HetaframeMaterial( color:Number=0xFF00FF, alpha:Number=1, thickness:Number = 0 )
		{
			this.lineColor     = color;
			this.lineAlpha     = alpha;
			this.lineThickness = thickness;

			this.doubleSided = false;
		}
		
		/**
		 *  drawTriangle
		 */
		override public function drawTriangle(tri:RenderTriangle, graphics:Graphics, renderSessionData:RenderSessionData, altBitmap:BitmapData=null, altUV:Matrix=null):void{
			var x0:Number = tri.v0.x;
			var y0:Number = tri.v0.y;
			
			if( lineAlpha )
			{
				graphics.lineStyle( lineThickness, lineColor, lineAlpha );
				graphics.beginFill(0xFFFFFF);
				moveTo( graphics, x0, y0 );
				hetaLineTo( graphics, tri.v1.x, tri.v1.y );
				hetaLineTo( graphics, tri.v2.x, tri.v2.y );
				hetaLineTo( graphics, x0, y0 );
				graphics.endFill();
				graphics.lineStyle();

				renderSessionData.renderStatistics.triangles++;
			}
			
		}
	        
		// ヘタ字処理用
	        private var lineX:Number;
	        private var lineY:Number;
	        private var lineDgr:Number;
	        private const lineInterval:Number = 8;
	        
	        public function moveTo(graphics:Graphics, x:Number, y:Number):void {
	        		lineX = x;
	        		lineY = y;
	        		graphics.moveTo(x, y);
	        }
	        
	        public function hetaLineTo(graphics:Graphics, x:Number, y:Number):void {
		        	var xDiff:Number = x - lineX;
		        	var yDiff:Number = y - lineY;
		        	var length:Number = Math.sqrt(xDiff*xDiff + yDiff*yDiff);
	        		
	        		while (length > 0) {
		        		xDiff = x - lineX;
		        		yDiff = y - lineY;
		        		
		        		// 書こうとしてるラインの角度所得
	        			lineDgr = Math.atan2(yDiff, xDiff);
	        			
	        			lineDgr = lineDgr - Math.random() * 0.2 + Math.random() * 0.7;	// 太めになるように
	        			xDiff = Math.cos(lineDgr) * (lineInterval > length ? length : lineInterval);
	        			yDiff = Math.sin(lineDgr) * (lineInterval > length ? length : lineInterval);
	        			
	        			lineX += xDiff;
	        			lineY += yDiff;
	        			graphics.lineTo(lineX, lineY);
	        			length -= lineInterval;
	        		}
	        }
		
		
		
		// ______________________________________________________________________ TO STRING

		/**
		* Returns a string value representing the material properties in the specified WireframeMaterial object.
		*
		* @return	A string.
		*/
		public override function toString(): String
		{
			return 'HetaframeMaterial - color:' + this.lineColor + ' alpha:' + this.lineAlpha;
		}
	}
