/**
 * Copyright merrycat ( http://wonderfl.net/user/merrycat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n6E9
 */

// forked from gaina's soundtest21
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    [SWF(width = 465, height = 465)]
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var _container:Sprite;
        private var _bitmapdata:BitmapData;
        private var _len:Number;
        
        public function Main():void 
        {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            _len = Math.round(Math.sqrt(465 * 465 + 465 * 465));
            
            _container = new Sprite();
            _container.x = stage.stageWidth / 2;
            _container.y = stage.stageHeight / 2;
            addChild(_container);
            
            _bitmapdata = new BitmapData(_len, _len, false, 0xFF000000);
            
            var _bitmap:Bitmap = new Bitmap(_bitmapdata);
            _bitmap.x = -(_len / 2);
            _bitmap.y = -(_len / 2);
            _container.addChild(_bitmap);
            
            Security.allowDomain("takasumi-nagai.com");
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound003.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10, new SoundTransform(0.5, 0));
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            bytes.position = 0;
            
            
            
            var _temp:BitmapData = new BitmapData(_len, _len, false, 0xFF000000);
            
            _temp.lock();
            for (var i:int = 0; i < 512; i++)
            {
                var data:Number = bytes.readFloat();
                
                var p:Number = data * 1000000;
                var p2:Number = p;
                var p3:Number = p;
                
                if (p > 256) p = 256;
                if (p2 > 0xFFFFFF) p2 = 0xFFFFFF;
                if (p3 < 0x000FFF) p3 = 0;
                
                var _x:Number = _len / 512 * i;
                var _y:Number = _len / 512 * i;
                
                _temp.setPixel(_x, 200, p);
                _temp.setPixel(200, _y, p);
                _temp.setPixel(_x, 400, p2);
                _temp.setPixel(400, _y, p2);
                _temp.setPixel(_x, 150, p3);
                _temp.setPixel(300, _y, p3);
                
                _temp.setPixel(_x, 140, p);
                _temp.setPixel(290, _y, p);
                _temp.setPixel(_x, 390, p2);
                _temp.setPixel(390, _y, p2);
                _temp.setPixel(_x, 190, p3);
                _temp.setPixel(190, _y, p3);
            }
            _temp.unlock();
            _bitmapdata.draw(_temp);
            
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, true, 0);
            _bytes.position = 0;
            
            var _data:Number = 0;
            
            for (var j:int = 0; j < 512; j++ )
            {
                _data += _bytes.readFloat();
            }
            
            if (_data > 36)
            {
                _container.rotation += 30;
            }
            
        }
    }
}