/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n5s5
 */

package {
  import flash.display.Sprite;
  import flash.events.SampleDataEvent;
  import flash.media.Sound;
  
  public class ch31ex6 extends Sprite {
    public function ch31ex6() {
      var sound:Sound = new Sound();
      sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onBufferSound);
      sound.play();      
    }
    protected function onBufferSound(event:SampleDataEvent):void {
      //for every sample, from the requested position through 8k samples later
      for (var t:int = event.position; t < event.position + 8192; t++) {
        //to generate a wave with any amplitude (volume) and frequency (pitch)
        //amplitude * sin(frequency * time)
        
        //the sin of this has 1 peak every seconds--is a 1Hz wave
        var tNormalized:Number = (t / 44100) * (2 * Math.PI);

        //write middle-C (261Hz) at full (1.0) volume to the LEFT channel
        event.data.writeFloat(1.0 * Math.sin(tNormalized*261.626));
        //write G4 (392Hz) at low (0.2) volume to RIGHT channel 
        event.data.writeFloat(0.2 * Math.sin(tNormalized*391.995));
      }
    }
  }
}