/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n4go
 */

// forked from actionscriptbible's Chapter 23 Example 3
package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.Point;
  import flash.geom.Rectangle;
  import flash.net.URLRequest;
  import flash.system.LoaderContext;
  import flash.ui.Multitouch;
  import flash.ui.MultitouchInputMode;

  [SWF(backgroundColor="#404040", width="1024", height="768")]
  public class ch23ex3 extends Sprite {
    protected var holder:DisplayObjectContainer;
    protected var cropRect:Rectangle;
    public function ch23ex3() {
      
        var test:Class = Multitouch;
        if (Multitouch.supportsGestureEvents) {
          Multitouch.inputMode = MultitouchInputMode.GESTURE;
          var l:Loader = new Loader();
          l.load(new URLRequest(
            "http://actionscriptbible.com/files/bluemarble.jpg"),
            new LoaderContext(true)
          );
          l.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
        } else {
          trace("Sorry, this example requires multitouch.");
        }
      
       
      
    }
    protected function onLoadComplete(event:Event):void {
      this.x = stage.stageWidth/2; this.y = stage.stageHeight/2;
      this.transform.perspectiveProjection.projectionCenter = 
        new Point(stage.stageWidth/2, stage.stageHeight * 0.25);
      this.transform.perspectiveProjection.fieldOfView = 70;
      
      var content:DisplayObject = LoaderInfo(event.target).content;
      holder = LoaderInfo(event.target).loader;
      content.x = -content.width/2; content.y = -content.height/2;
      var targetWidth:Number = stage.stageWidth * 0.7;
      var scale:Number = Math.min(1, targetWidth / content.width);
      holder.z = 100;
      holder.scaleX = holder.scaleY = scale;
      addChild(holder);
      stage.addEventListener(GestureEvent.GESTURE_TWO_FINGER_TAP, onDoubleTap);
      stage.addEventListener(TransformGestureEvent.GESTURE_PAN, onGesture);
      stage.addEventListener(TransformGestureEvent.GESTURE_ROTATE, onGesture);
      stage.addEventListener(TransformGestureEvent.GESTURE_SWIPE, onGesture);
      stage.addEventListener(TransformGestureEvent.GESTURE_ZOOM, onGesture);
    }
    protected function onDoubleTap(event:GestureEvent):void {
      holder.transform.matrix3D.identity();
    }
    protected function onGesture(event:TransformGestureEvent):void {
      switch (event.type) {
        case TransformGestureEvent.GESTURE_PAN:
          var SCALE:Number = 0.5;
          holder.rotationY -= event.offsetX * SCALE;
          holder.rotationX += event.offsetY * SCALE;
          break;
        case TransformGestureEvent.GESTURE_ROTATE:
          holder.rotationZ += event.rotation;
          break;
        case TransformGestureEvent.GESTURE_ZOOM:
          holder.scaleX *= event.scaleX;
          holder.scaleY = holder.scaleX;
          break;
      }
    }
  }
}