/**
 * Copyright aktm ( http://wonderfl.net/user/aktm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n4Jj
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
	import flash.filters.DropShadowFilter;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Mouse;
	import flash.geom.ColorTransform;
    
    [SWF(backgroundColor = 0xFFFFFF, width = 500, height = 500, frameRate = 1)]
    import flash.display.Loader;
    public class Main extends Sprite {
  
        private var _seco:Sprite;
		private var _minu:Sprite;
		private var _hour:Sprite;
		private var maru:Sprite;
		private var _tf:TextField;
		private var _bitDate:BitmapData;
		private var _bitmap:Bitmap;
		private var _ctf:ColorTransform = new ColorTransform(1, 1, 1, 1, -0x5, -0x5, -0x5, -0x5);
		private var _character:Array = ["★","*","#"];
		

		public function Main() {
			
		
			
			var loader:Loader = new Loader();
			var urlRequest:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/3/34/34b9/34b9cbd29caf5b5b39768856d4f10e9b8f1b5c4e");
			loader.load(urlRequest);
			addChild(loader);
			


			//秒針
			_seco=new Sprite();
			_seco.graphics.beginFill(0x330000);
			_seco.graphics.drawRect(-1,-80,2,80);
			_seco.x = 250;
			_seco.y = 230;
			
			var dropShadow:DropShadowFilter = new DropShadowFilter();
            dropShadow.color = 0x333333;
            _seco.filters = [ dropShadow];
			this.addChild(_seco);
			
			//分針
			_minu = new Sprite();
			_minu.graphics.beginFill(0x330000);
			_minu.graphics.drawRect(-2,-75,4,75);
            _minu.x = 250;
			_minu.y = 230;
			
			var dropShadow2:DropShadowFilter = new DropShadowFilter();
            dropShadow2.color = 0x333333;
            _minu.filters = [ dropShadow2];
			this.addChild(_minu);
			
			
			//時針
			_hour = new Sprite();
			_hour.graphics.beginFill(0x330000);
			_hour.graphics.drawRect(-3,-60,6,60);
			_hour.x = 250;
			_hour.y = 230;
			
			var dropShadow1:DropShadowFilter = new DropShadowFilter();
            dropShadow1.color = 0x333333;
            _hour.filters = [ dropShadow1];
			this.addChild(_hour);
			
			
			//中心の円
			maru = new Sprite();
			maru.graphics.beginFill(0x330000);
			maru.graphics.drawCircle(0,0,7);
			maru.graphics.endFill();
			maru.x = 250;
			maru.y = 230;
			
			var dropShadow3:DropShadowFilter = new DropShadowFilter();
            dropShadow3.color = 0x333333;
            maru.filters = [ dropShadow3];

			this.addChild(maru);
			
			
			this.addEventListener(Event.ENTER_FRAME,onEnter);
			
			_tf = new TextField();
			_tf.defaultTextFormat = new TextFormat("_sans",20,0x330000);
			_tf.text = _character[0];
			_tf.selectable = false;
			_tf.autoSize = "left";
			this.addChild(_tf);
			
			Mouse.hide();
			stage.addEventListener(Event.ENTER_FRAME, onEnter2);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
			
			}
			private function setupScreen():void{
				_bitDate = new BitmapData(500, 500,false, 0x000000);
				_bitmap = new Bitmap(_bitDate,PixelSnapping.NEVER,true);
				this.addChild(_bitmap);
			}
			private function onEnter(event:Event):void{  
               var date:Date = new Date();  
               _seco.rotation = (date.seconds + date.milliseconds / 1000) * -6 - 90;
			   _minu.rotation = (date.minutes + date.seconds / 60) * -6;
			   _hour.rotation = (date.hours + date.minutes / 60) * -30;
			
            }
            private function onEnter2(event:Event):void{
            	  _tf.x = stage.mouseX - _tf.width/2;
            	  _tf.y = stage.mouseY - _tf.height/2;
            	  _bitDate.draw(this,new Matrix(0.99,0,0,0.99));
            	  _ctf.blueMultiplier = stage.mouseX/500;
            	  _ctf.greenMultiplier = stage.mouseY/500;
            	  _bitDate.colorTransform(_bitDate.rect,_ctf);
            	  
            	  
            	
            }
            private function onMove(event:MouseEvent):void{
            	  _tf.text = _character[Math.floor(Math.random()*_character.length)];
            	  
            }
    }
}
