/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n4DK
 */

/**
 * Progression4とGAE/P kay frameworkとでAMFでのやりとりをする
 * http://meemeer.sitemix.jp/blog/?p=462
 */

package {
    import flash.display.Sprite;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
    import com.bit101.components.Label;
    /**
     * ...
     * @author meemeer
     */
    [SWF(width="465", height="465", frameRate="60")]
    
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var label:Label = new Label(this, 0, 0, '');            
            
            new Amf('service.echo',
                function(res:Object):void {
                    trace(res);
                    label.text = res as String;
                },
                {
                    onStart:function():void {
                        trace('amf start');
                    },
                    onComplete:function():void {
                        trace('amf end');
                    }
                },
                "PyAMF test 日本語"
            ).execute();
        }
    }
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * AMF接続を行うコマンド側
 * new AMF('[接続先のclass.function]', '[callback]', initObject, '... [引数]').execute();
 * @author m_emem
 * 
 * @version 0.0.1
 * @see http://meemeer.sitemix.jp/blog/
 * @see http://meemeer.sitemix.jp/blog/?p=7
 */
class Amf extends Command 
{
    private var _amf:AmfConnect;
    private var _func:String;
    private var _args:Object;
    private var _callback:Function;
    
    /**
     * 新しい AmfCommand インスタンスを作成します。
     */
    public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
    {
        _func = func;
        _callback = callback;
        _args = args;
        
        // 親クラスを初期化します。
        super( _execute, _interrupt, initObject );
    }
    
    /**
     * 実行されるコマンドの実装です。
     */
    private function _execute():void 
    {
        _amf = AmfConnect.instance;
        _amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
        
        var params:Array = [_func, _callback];
        params.push.apply(params, _args);
        _amf.execute.apply(_amf, params);
        
        // 
        //executeComplete();
    }
    
    /**
     * 中断されるコマンドの実装です。
     */
    private function _interrupt():void 
    {
    }
    
    private function _complete(e:Event):void
    {
        _amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
        latestData = _amf.data;
        
        _amf.data = null;
        _func = null;
        _callback = null;
        _args = null;
        
        if (_amf.error != null) {
            super.throwError(this, new Error(_amf.error));
        } else {
            super.executeComplete();
        }
    }
    
    /**
     * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
     */
    public override function clone():Command 
    {
        return new Amf( _func, _callback, this, _args );
    }
}


import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * AMF接続を行うAMF設定側
 * @author m_emem
 * 
 * @version 0.0.1
 * @see http://meemeer.sitemix.jp/blog/
 * @see http://meemeer.sitemix.jp/blog/?p=7
 */
class AmfConnect
{
    private static var _instance:AmfConnect;
    public var dispatcher:IEventDispatcher;
    public var nc:NetConnection;
    public var error:Object;
    
    //private var gatewayUrl:String = 'http://localhost:18080/gateway';
    private var gatewayUrl:String = 'http://meemeer-lab.appspot.com/gateway';
    private var callback:Function;
    public var data:Object;
    
    public function AmfConnect() 
    {
        if (_instance === null) {
            _instance = this;
            init();
        } else {
            throw new Error('Singleton class');
        }
    }
    
    public static function get instance():AmfConnect
    {
        if (_instance === null) {
            _instance = new AmfConnect();
        }
        return _instance;
    }
    
    private function init():void
    {
        dispatcher = new EventDispatcher();
        error = null;
        
        nc = new NetConnection();
        nc.objectEncoding = ObjectEncoding.AMF3;
        nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
        nc.connect(gatewayUrl);
    }
    
    private function onNetStatus(e:NetStatusEvent):void 
    {
        trace("Connection error, error code: (" +e.info.code + ")", "System message");
    }
    
    public function execute(_func:String, _callback:Function, ... _args:Array):void
    {
        callback = _callback;
        
        var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
        params.push.apply(params, _args);
        nc.call.apply(nc, params);
    }
    
    private function onResultHandler(result:Object):void
    {
        if (callback != null) {
            data = callback.call(null, result);
        } else {
            data = result;
        }
        dispatcher.dispatchEvent(new Event(Event.COMPLETE));
    }
    
    private function onFaultHandler(fault:Object):void
    {
        data = fault;
        error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
        dispatcher.dispatchEvent(new Event(Event.COMPLETE));
    }
    
}