/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n4B0
 */

package {
    import com.bit101.components.Label;
    import com.bit101.components.NumericStepper;
    import flash.display.Sprite;
    import flash.events.Event;
    import net.user1.logger.Logger;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0xFFFFFF")]
    public class Main extends Sprite {
        private var _reactor:Reactor;
        private var _room:Room;
        
        private var _stepper:NumericStepper;
        private var _sendCount:int;
        
        public function Main() {
            _reactor = new Reactor();
            _reactor.getConnectionMonitor().setHeartbeatFrequency(1000);
            //_reactor.getLog().setLevel(Logger.DEBUG);
            _reactor.addEventListener(ReactorEvent.READY, onReady);
            _reactor.connect("tryunion.com", 80);
            
            new Label(this, 10, 10, "call room.sendMessage() for");
            _stepper = new NumericStepper(this, 140, 10);
            _stepper.minimum = 0; _stepper.maximum = 300;
            new Label(this, 230, 10, "times per second");
            
            var stats:UnionStats = new UnionStats(_reactor);
            stats.x = 465 - stats.width;
            addChild(stats);
            
            _sendCount = 0;
        }
        
        private function onReady(event:ReactorEvent):void {
            _room = _reactor.getRoomManager().createRoom("StressTest");
            _room.join();
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(event:Event):void {
            if (!_reactor.isReady() || !_room.clientIsInRoom()) { return; }
            
            _sendCount += _stepper.value;
            while (_sendCount >= stage.frameRate) {
                _sendCount -= stage.frameRate;
                _room.sendMessage(Math.random().toString(), true, null, Math.random().toString());
            }
        }
    }
}
//package ore.orelib.commons {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.DropShadowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.Statistics;
    
    //public 
    class UnionStats extends Sprite {
        private var _reactor:Reactor;
        private var _fpsCount:int;
        private var _updateTimer:Timer;
        
        private var _fpsLabel:TextField;
        private var _stageFpsLabel:TextField;
        private var _pingLabel:TextField;
        private var _memLabel:TextField;
        private var _downLabel:TextField;
        private var _upLabel:TextField;
        private var _peakMemLabel:TextField;
        private var _peakDownLabel:TextField;
        private var _peakUpLabel:TextField;
        
        public function UnionStats(reactor:Reactor) {
            _reactor = reactor;
            _fpsCount = 0;
            _updateTimer = new Timer(1000);
            _updateTimer.addEventListener(TimerEvent.TIMER, update);
            
            graphics.beginFill(0x444444, 0.8);
            graphics.drawRect(0, 0, 110, 92);
            graphics.endFill();
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(5, 37, 100, 2);
            graphics.endFill();
            
            addChild(createTextField("FPS:", 2, 2, 35, "left"));
            addChild(createTextField("Mem:", 2, 18, 35, "left"));
            addChild(createTextField("Ping:", 2, 42, 35, "left"));
            addChild(createTextField("Down:", 2, 58, 35, "left"));
            addChild(createTextField("Up:", 2, 74, 35, "left"));
            addChild(createTextField("/", 69, 2, 7, "center"));
            addChild(createTextField("/", 69, 18, 7, "center"));
            addChild(createTextField("/", 69, 58, 7, "center"));
            addChild(createTextField("/", 69, 74, 7, "center"));
            
            addChild(_fpsLabel = createTextField("0", 37, 2, 32, "right"));
            addChild(_stageFpsLabel = createTextField("0", 76, 2, 32, "left"));
            addChild(_pingLabel = createTextField("-1", 37, 42, 71, "center"));
            addChild(_memLabel = createTextField("0.00", 37, 18, 32, "right"));
            addChild(_downLabel = createTextField("0.00", 37, 58, 32, "right"));
            addChild(_upLabel = createTextField("0.00", 37, 74, 32, "right"));
            addChild(_peakMemLabel = createTextField("0.00", 76, 18, 32, "left"));
            addChild(_peakDownLabel = createTextField("0.00", 76, 58, 32, "left"));
            addChild(_peakUpLabel = createTextField("0.00", 76, 74, 32, "left"));
            
            addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
            addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);
            enable();
        }
        
        private function createTextField(text:String, x:int, y:int, width:int, align:String):TextField {
            var result:TextField = new TextField();
            result.x = x; result.y = y;
            result.width = width;
            result.filters = [new DropShadowFilter(1, 45, 0x444444, 1, 1, 1)];
            result.mouseEnabled = result.selectable = false;
            var format:TextFormat = new TextFormat("_sans", 9, 0xFFFFFF, true);
            format.align = align;
            result.defaultTextFormat = format;
            result.text = text;
            return result;
        }
        
        private function startDragHandler(event:MouseEvent):void { startDrag(); }
        private function stopDragHandler(event:MouseEvent):void { stopDrag(); }
        private function enterFrameHandler(event:Event):void { _fpsCount++; }
        
        private function update(event:TimerEvent):void {
            _fpsLabel.text = _fpsCount.toString();
            _fpsCount = 0;
            if (stage) { _stageFpsLabel.text = stage.frameRate.toString(); }
            
            if (!_reactor.isReady()) { return; }
            var stats:Statistics = _reactor.getStatistics();
            _pingLabel.text = _reactor.self().getPing().toString();
            _memLabel.text = stats.getTotalMemoryMB().toFixed(2);
            _downLabel.text = stats.getKBReceivedPerSecond().toFixed(2);
            _upLabel.text = stats.getKBSentPerSecond().toFixed(2);
            _peakMemLabel.text = stats.getPeakMemoryMB().toFixed(2);
            _peakDownLabel.text = stats.getPeakKBReceivedPerSecond().toFixed(2);
            _peakUpLabel.text = stats.getPeakKBSentPerSecond().toFixed(2);
        }
        
        public function enable():void {
            _reactor.enableStatistics();
            _reactor.getStatistics().start();
            
            _fpsCount = 0;
            _updateTimer.start();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function disable():void {
            _reactor.getStatistics().stop();
            _reactor.disableStatistics();
            
            _updateTimer.stop();
            removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
    }
//}