/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n499
 */

// http://honkidasu-tokei.com/ ←こちらのflashバージョン
// 背景画像は適当にflickrから猫。http://wonderfl.net/c/suNP2←こちらを参考にさせて頂いてます。
// http://d.hatena.ne.jp/nitoyon/20090908/easy_open_face←文字縁取りはこちらを参考にさせて頂いてます。

package
{
    import flash.display.Bitmap;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    public class HonkidasuTokei extends Sprite
    {
        static public const API:String = "http://api.flickr.com/services/feeds/photos_public.gne";
        static public const NS_MEDIA:String = "http://search.yahoo.com/mrss/";
        private var _loader:URLLoader;
        private var _imgLoad:Loader;
        
        private var _labels:Array =
        [
            "新しい1日。夜はこれから。今日から本気出す。",
            "まだまだ時間はたっぷりある。焦りは禁物。2時から本気だす。",
            "普通の人は寝てると思うとやるせなくなる。3時から本気だす。",
            "この時間になると妙に人恋しくなって寂しい気持ちになる。\n心を落ち着かせて4時から本気だす。",
            "あっという間に時間が過ぎてしまった。一歩踏み出す勇気を蓄えて、\n5時から本気だす。",
            "だんだん空が白み始めた。夜が明けるまで我慢の時。6時から本気だす。",
            "外が明るい。1日はこれから。力を貯めて、7時から本気出す。",
            "小学生が登校している。元気すぎて気力を奪われた。8時から本気だす。",
            "まだ頭が寝てる。これでは力が出ない。9時から本気出す。",
            "朝から飛ばしすぎると夕方まで持たない。10時から本気出す。",
            "みんな動いているのに自分だけ取り残された気分。気が重い。\n11時から本気出す。",
            "おなか減った。昼に何食べるか考えてたら集中できない。\n12時から本気出す。",
            "昼だ。飯食って気分を切り替えて、13時から本気出す。",
            "飯食っておなかいっぱい。これでは頭がまわらない。\n14時から本気出す。",
            "おなかいっぱいを通り過ぎて眠たい。15時から本気出す。",
            "なにもかも中途半端な時間帯。ここは雌伏の時。16時から本気だす。",
            "1日の疲れがピークに達してきた。ここで無理しても意味が無い。\n17時から本気だす。",
            "日が傾いている。一日が終わる。でも焦ってはいけない。\n18時から本気だす。",
            "空がほぼ暗くなる。お腹も減ったしキリが悪い。19時から本気だす。",
            "体の節々が疲れてる。ストレッチして整えて、20時から本気出す。",
            "ラストスパートに向けて力を溜める。21時から本気出す。",
            "追い詰められないと本気になれないから、22時から本気出す。",
            "終わり良ければ全て良し。23時から本気出す。",
            "一日終わり。今日はチャンスがなかった。明日から本気出す。",
        ];
        
        private var _date:Date;
        private var _h:Number;
        private var _m:Number;
        private var _s:Number;
        
        private var _bg:Bitmap;
        private var _time:TextField;
        private var _label:TextField;
        public function HonkidasuTokei()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate = 30;
            
            _loader = new URLLoader();
            _loader.addEventListener(Event.COMPLETE, _onComplete);
            _loader.load(new URLRequest(API + "?format=rss_200&tags=" + "cat"));
            
            _bg = new Bitmap();
            _time = _createTextField(60, true);
            _time.y = 150;
            _label = _createTextField(14, false);
            _label.y = 250;
            addChild(_bg);
            addChild(_time);
            addChild(_label);
        }
        
        private function _onComplete(e:Event):void
        {
            var xml:XML = XML(e.target.data);
            var media:Namespace = new Namespace(NS_MEDIA);
            var imgs:Array = [];
            for each(var node:XML in xml..item)
            {
                imgs.push(node.media::content.@url)
            }
            _imgLoad = new Loader();
            _imgLoad.contentLoaderInfo.addEventListener(Event.COMPLETE, _onCompleteImg);
            var n:int = Math.random()*imgs.length;
            _imgLoad.load(new URLRequest(imgs[n]), new LoaderContext(true));
        }
        
        private function _onCompleteImg(e:Event):void
        {
            _bg.bitmapData = Bitmap(e.target.loader.content).bitmapData;
            var s:Number;
            if(_bg.width > _bg.height)
            {
                s = 465/_bg.height;
            }
            else
            {
                s = 465/_bg.width;
            }
            _bg.scaleX = _bg.scaleY = s;
            
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        private function _update(e:Event):void
        {
            _date = new Date();
            _h = _date.getUTCHours() + 9;
            _m = _date.getUTCMinutes();
            _s = _date.getUTCSeconds();
            _updateTime();
            _updateLabel();
        }
        
        private function _updateTime():void
        {
            _time.text = _hoge(_h, _m, _s);
        }
        
        private function _updateLabel():void
        {
            _label.text = _labels[_h];
        }
        
        private function _createTextField(size:Number, bold:Boolean):TextField
        {
            var tf:TextField = new TextField();
            var format:TextFormat = new TextFormat();
            format.font = "verdana";
            format.color = 0xFFFFFF;
            format.bold = bold;
            format.size = size;
            tf.defaultTextFormat = format;
            tf.width = 465;
            tf.filters = [new GlowFilter(0x444444, 1, 2, 2, 16, 1)];
            tf.autoSize = TextFieldAutoSize.CENTER;
            return tf;
        }
        
        private function _hoge(h:Number, m:Number, s:Number):String
        {
            var hh:String = String(h+100).substring(1, 3);
            var mm:String = String(m+100).substring(1, 3);
            var ss:String = String(s+100).substring(1, 3);
            return hh + ":" + mm + ":" + ss;
        }
    }
}