/**
 * Copyright mex_ny ( http://wonderfl.net/user/mex_ny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n46F
 */

// forked from mex's 【AS100本ノック】7回目：ローディング（バー） 
/* 
 * AS100本ノック
 * 7回目のお題は「ローディング（バー）」
 * あなたなりの「ローディング（バー）」を表現してください。
 *
 * 2進数で1から100まで表示してみたテスト
 */
package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.events.MouseEvent;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.tweens.IIObjectTween;
    import org.libspark.betweenas3.easing.Cubic;
    import org.libspark.betweenas3.tweens.IObjectTween;
    import org.libspark.betweenas3.events.TweenEvent;


        
    public class LoadingBar extends Sprite {
        private const TILE_WIDTH:uint = 14 , TILE_HEIGHT:uint = 10 , SIZE:uint = 465;
        private var _width:uint, _height:uint , _timer:Timer , _bg:Sprite , tileWidth:uint ,prevPercent:uint,
        _imageLoader:Loader , _loadedList:Array , _isLoadComplete:Boolean , _loadedCounter:uint , loadedLength:uint , _isLoadingAnimationComplete:Boolean;
        
        public function LoadingBar() {
            _width = _height = SIZE;
//            Wonderfl.capture_delay( 10 );
            init();
        }
        
        private function init():void
        {
            _loadedList = new Array();
            _isLoadingAnimationComplete = false;
            _isLoadComplete = false;
            _loadedCounter = 0;
            
            addBackGround();
            startImageLoad();
            startTimer();
            
        }
        
		private function addBackGround():void
		{
		    var g:Graphics;
		    
		    var sp:Sprite = new Sprite();
		    addChild( sp );
		    g = sp.graphics;
		    g.beginFill( 0x000000 );
		    g.drawRect( 0 , 0 , _width , _height );
		    g.endFill();
		    
		    
		    _bg = new Sprite();
		    addChild( _bg );
		    g = _bg.graphics;
		    g.beginFill( 0x000000 );
		    g.drawRect( 0 , 0 , 14 * 7 , TILE_HEIGHT );
		    g.endFill();
		    _bg.x = ( _width - _bg.width ) >> 1;
		    _bg.y = ( _height - _bg.height ) >> 1;
		 }
		 
		 private function startImageLoad():void
		 {
		     var date:Date , urlRequest:URLRequest , url:String;
		     date = new Date();
		     url = "http://image.dev-mex.com/dummy.jpg";
		     url +="?" + String( date.getTime() );
		     
		    _imageLoader = new Loader();
			_imageLoader.contentLoaderInfo.addEventListener( Event.COMPLETE , eventCompleteHandler , false , 0 , true );
			_imageLoader.contentLoaderInfo.addEventListener( ProgressEvent.PROGRESS , progressEventProgressHandler , false , 0 , true );
			_imageLoader.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR , ioErrorEventIoErrorHandler , false , 0 , true );
		    _imageLoader.load( new URLRequest( url ) );
		 }
		 
		private function ioErrorEventIoErrorHandler( $evt:IOErrorEvent ):void
		{
			_imageLoader.contentLoaderInfo.removeEventListener( Event.COMPLETE , eventCompleteHandler  );
			_imageLoader.contentLoaderInfo.removeEventListener( ProgressEvent.PROGRESS , progressEventProgressHandler );
			_imageLoader.contentLoaderInfo.removeEventListener( IOErrorEvent.IO_ERROR , ioErrorEventIoErrorHandler );
			removeTimer();
		}
		 
		private function progressEventProgressHandler( $evt:Event ):void
		{
			_loadedList.push( Math.floor( $evt.target.bytesLoaded / $evt.target.bytesTotal * 100 ) );
			loadedLength = _loadedList.length;
		}
		 
		private function eventCompleteHandler( $evt:Event ):void
		{
			_imageLoader.contentLoaderInfo.removeEventListener( Event.COMPLETE , eventCompleteHandler  );
			_imageLoader.contentLoaderInfo.removeEventListener( ProgressEvent.PROGRESS , progressEventProgressHandler );
			_isLoadComplete = true;
		}
		
		private function startTimer():void
		{
			_timer = new Timer( 1 , 1 );
			_timer.addEventListener( TimerEvent.TIMER , timerHandler , false , 0 , true);
			_timer.addEventListener( TimerEvent.TIMER_COMPLETE , timerCompleteHandler , false , 0 , true );
			_timer.start();
		}
		
		private function removeTimer():void
		{
			if ( _timer != null )
			{
				_timer.removeEventListener( TimerEvent.TIMER , timerHandler );
				_timer.removeEventListener( TimerEvent.TIMER_COMPLETE , timerCompleteHandler );
				_timer = null;
			}
		}
		
		private function timerHandler( e:TimerEvent ):void
		{
            loaderAnimation();
		}
		
		private function timerCompleteHandler( e:TimerEvent ):void
		{
			removeTimer();

			if ( !_isLoadComplete || _loadedCounter <= loadedLength || _loadedList.length == 0 || !_isLoadingAnimationComplete ) startTimer();
		}

		private function loaderAnimation():void
		{
			var percent:uint , percentStr:String, i:uint , len:uint , tail:Tail;

			percent = _loadedList.shift();
			if ( percent != 0 && prevPercent != percent ) {
				_loadedCounter += 1;	
				percentStr = uint( 128 | percent ).toString(2).substr( 1 );
				len = percentStr.length;

				for ( i = 0; i < len; i++ )
				{
					if ( percentStr.substr( i , 1 ) == "1" )
					{
						tail = new Tail( i , TILE_WIDTH , TILE_HEIGHT );
						_bg.addChild( tail );
					}
				}
				if ( percent == 100 )
				{
					_isLoadingAnimationComplete = true;
					removeTimer();
					loadComplete();
				}
				
				prevPercent = percent;
			}
		}
		
		private function loadComplete():void
		{
			addImage();
		}
		
		private function addImage():void
		{
			addChild( _imageLoader );
			var t:IObjectTween = BetweenAS3.tween( _imageLoader , { alpha:1 } , { alpha:0 } , 0.5 , Cubic.easeIn );
			t.addEventListener( TweenEvent.COMPLETE , tweenEventCompleteHandler , false , 0 , true );
			t.play();
		}
		
		private function tweenEventCompleteHandler( $evt:TweenEvent ):void
		{
			var t:IObjectTween = $evt.target as IObjectTween;
			t.removeEventListener( TweenEvent.COMPLETE , tweenEventCompleteHandler );

			buttonMode = true;
			t.target.addEventListener( MouseEvent.CLICK , mouseEventClickHandler , false , 0 , true );
		}
		
		
		private function mouseEventClickHandler( $evt:MouseEvent ):void
		{
			$evt.target.removeEventListener( MouseEvent.CLICK , mouseEventClickHandler );
			buttonMode = false;
			
			
			removeChild( _imageLoader );
			_imageLoader.unload();
			_imageLoader = null;
			
			while ( _bg.numChildren > 0 )
			{
				_bg.removeChildAt( 0 );
			}
			
			while ( numChildren > 0 )
			{
				removeChildAt( 0 );
			}
			_bg = null;
			
			init();
		}
		
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.filters.GlowFilter;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Cubic;

class Tail extends Sprite
{
	public function Tail( num:uint , w:uint , h:uint )
	{
		var sp:Sprite = new Sprite();
		addChild( sp );

		var g:Graphics = sp.graphics;
		g.beginFill( 0xB8DEC5 );
		g.drawRect( 0 , 0 , w , h );
		g.endFill();

		x = w * num;

		sp.filters = [ new GlowFilter(0x00cc00 , 0.6 , 16 , 16 , 3 , 3 ) ];
		
		BetweenAS3.tween( sp , { alpha:0 } , null , 1.0 , Cubic.easeOut ).play();
	}
}
