/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n42O
 */

// forked from dizgid's Matrix3D.pointAt()	
/**
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#pointAt()
*/
package {
	import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.*;
    import flash.events.Event;
    import caurina.transitions.Tweener;

	[SWF(frameRate=60)]
    public class PointAtExample extends MovieClip {
        private var ellipse:Sprite = new Sprite();
        private var triangle:Shape = new Shape();
        
        private var centerX:Number = stage.stageWidth / 2;
        private var centerY:Number = stage.stageHeight / 2;

        public function PointAtExample():void {
        		this.graphics.beginFill(0x000000);
        		this.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
        		this.graphics.endFill();
        	
        		var ellipseShape:Shape = new Shape();
        		var size:Number = 80;
        		ellipse.addChild(ellipseShape);
            ellipseShape.graphics.beginFill(0xffffff, 0.3);
            ellipseShape.graphics.lineStyle(0, 0xffffff);
            ellipseShape.graphics.drawRect(-size*0.5,-size*0.5,size, size);
            ellipseShape.graphics.endFill();
            ellipseShape.rotationY = 90;
            ellipse.x = centerX;
            ellipse.y = centerY;
            ellipse.z = 1;

            
            triangle.graphics.lineStyle(0, 0xffffff);
            triangle.graphics.moveTo(0, 10);
            triangle.graphics.lineTo(100, 0);
            triangle.graphics.lineTo(0, -10);
            triangle.graphics.lineTo(0, 10);
            triangle.graphics.endFill();
            triangle.x = centerX;
            triangle.y = centerY;
            triangle.z = 1;
            
            addChild(ellipse);
            addChild(triangle);

            ellipse.addEventListener(Event.ENTER_FRAME, ellipseEnterFrameHandler);
            triangle.addEventListener(Event.ENTER_FRAME, triangleEnterFrameHandler);
            
            randomMove();
        }
        private function randomMove():void
        {
      	  	Tweener.addTween(ellipse, { 
				x:Math.random()*400-200 + centerX,
				y:Math.random()*400-200 + centerY,
				z:Math.random()*600-300,
				time:1.5, 
				transition:"linear",
				onComplete:function():void {
					randomMove();
				}
			} );
        }

        private function ellipseEnterFrameHandler(e:Event):void {
            ellipse.transform.matrix3D.pointAt(triangle.transform.matrix3D.position, Vector3D.X_AXIS, Vector3D.Y_AXIS);
        }
        
        private function triangleEnterFrameHandler(e:Event):void {
            triangle.transform.matrix3D.pointAt(ellipse.transform.matrix3D.position, Vector3D.X_AXIS, Vector3D.Y_AXIS);
        }
    }
}