/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n41Y
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite 
    {
        private const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/3/3f/3fc6/3fc658d396a794a4c74f4e29d3e66aff1819280b";
        
        private var foldImage:Fold;
        
        public function Main():void 
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler );
            
            loader.load( new URLRequest( IMAGE_URL ), new LoaderContext( true ) );
        }
        
        private function completeHandler( event:Event ):void {
            
            var loaderInfo:LoaderInfo = event.currentTarget as LoaderInfo;
            
            var image:Bitmap = loaderInfo.content as Bitmap;
            foldImage = new Fold( image );
            
            fitScale( foldImage, stage.stageWidth, stage.stageHeight );
            moveCenter( foldImage, stage.stageWidth, stage.stageHeight );
            
            addChild( foldImage );
            
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler( event:MouseEvent ):void {
            
            if( foldImage.opened )
                foldImage.close();
            
            else 
                foldImage.open();
        }
    }
    
}

import flash.display.*;
import flash.geom.Matrix;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.core.tweens.groups.SerialTween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.tweens.ITweenGroup;

function fitScale( target:DisplayObject, maxWidth:Number, maxHeight:Number ):DisplayObject {
    
    target.scaleX = maxWidth / target.width;
    target.scaleY = maxHeight / target.height;
    
    if ( target.scaleX < target.scaleY )
        target.scaleY = target.scaleX;
        
    else 
        target.scaleX = target.scaleY;
    
    return target;
}

function moveCenter( target:DisplayObject, width:Number, height:Number, offsetX:Number = 0, offsetY:Number = 0 ):DisplayObject {
    
    target.x = ( width - target.width ) / 2 + offsetX;
    target.y = ( height - target.height ) / 2 + offsetY;
    
    return target;
}

class Fold extends Sprite {
    
    private var _numFold:uint;
    public function get numFold():uint { return _numFold; }
    
    
    private var dividedImages:Array = new Array();
    
    private var dividedImageWidth:uint;
    private var tween:ITween;
    private var reverseTween:ITween;
    
    private var _opened:Boolean;
    public function get opened():Boolean { return _opened; }
    
    public function Fold( image:Bitmap, numFold:uint = 5, speed:Number = 0.1 ):void {
        
        image.visible = false;
        addChild( image );
        
        _numFold = numFold;
        dividedImageWidth = image.width / numFold;
        
        var matrix:Matrix = new Matrix();
        var tweens:Array = new Array();
        for ( var i:uint = 0; i < numFold; i++ ) {
            
            var dividedImageBitmapData:BitmapData = new BitmapData( dividedImageWidth, image.height, true, 0x0 );
            
            matrix.identity();
            matrix.translate( -i * dividedImageWidth, 0 );
            
            dividedImageBitmapData.draw( image, matrix );
            
            var dividedImage:Bitmap = new Bitmap( dividedImageBitmapData );
            dividedImage.x = i * dividedImageWidth;
            dividedImages.push( dividedImage );
            dividedImage.rotationY = -90;
            dividedImage.alpha = 0;
            
            addChildAt( dividedImage, 0 );
            
            tweens.push( BetweenAS3.tween( dividedImage, { rotationY:0, alpha:1 }, { rotationY: -90, alpha:0 }, speed ) );
        }
        tween = BetweenAS3.serialTweens( tweens );
        reverseTween = BetweenAS3.reverse( tween );
        open();
    }
    
    public function open():void {
        
        _opened = true;
        
        reverseTween.stop();
        tween.gotoAndPlay( tween.duration - reverseTween.position );
    }
    
    public function close():void {
        
        _opened = false;
        
        tween.stop();
        reverseTween.gotoAndPlay( tween.duration - tween.position );
    }
}