/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n3Bm
 */

// forked from christian's NOISE PATTERN
package
{
    import flash.events.*;
    import flash.display.*;
    import flash.net.FileReference;

    import com.bit101.components.*;
    import com.adobe.images.PNGEncoder;

    /*  @author SPANVEGA // CHRISTIAN  */

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '25')]

    public class NOISE_PATTERN_SAMPLE extends Sprite
    {
        private var g_com : Vector.<int> = new <int> [1, 2, 2, 2, 2];
        private var g_dat : Vector.<Number> = new <Number> [];

        private var W : uint, H : uint;

        private var panel_btn : CheckBox;
        private var panel_rec : Sprite;
        private var panel : Sprite;

        private var gs : Boolean = false;    // GRAYSCALE
        private var hi : uint = 0xFF;        // HIGH
        private var lo : uint = 0xA0;        // LOW
        private var sd : uint = 0xDC;        // SEED
        private var _h : uint = 25;          // HEIGHT
        private var _w : uint = 1;           // WIDTH
        private var ch : uint = 7;           // CHANNEL


        public function NOISE_PATTERN_SAMPLE ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init); 
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {removeEventListener (Event.ADDED_TO_STAGE, init);}

            stage.scaleMode = 'noScale';

            H = stage.stageHeight;
            W = stage.stageWidth;

            //

            g_dat.push (0, 0, W, 0, W, H, 0, H, 0, 0);

            setPattern ();

            setUI ();
        }

        private function setPattern () : void
        {
            graphics.clear ();
            graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsBitmapFill
                    (
                        NOISE_PATTERN.build (_w, _h, sd, lo, hi, ch, gs)
                    ),
                    new GraphicsPath (g_com, g_dat)
                ])
            );
        }

        private function setUI () : void
        {
            panel = new Sprite ();

            // --o BACKGROUND

            panel_rec = new Sprite ();
            panel_rec.graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsStroke
                    (
                        1, true, 'normal', 'none', 'round', 3, new GraphicsSolidFill (0xAAAAAA, 1)
                    ),
                    new GraphicsSolidFill (0xFFFFFF, 0.75), setGraphicsBorderPath (0, 0, 174, 152)
                ])
            );

            panel_rec.addEventListener (MouseEvent.MOUSE_DOWN, setDrag);
            panel_rec.addEventListener (MouseEvent.MOUSE_UP,   setDrag);

            panel.addChild (panel_rec);

            // --o CHECKBOX | BTN

            panel_btn = new CheckBox (panel, 5, 5, null, setDisplay);
            panel_btn.selected = true;

            // --o SLIDERS | OFFSETS

            var _lbl : Label = new Label (panel, 30, 1, 'NOISE PATTERN');

            var l__w : Label = new Label (panel, 30, 20, 'W');

            var n__w : NumericStepper = new NumericStepper (panel, 47, 20, setProp);
            n__w.setSize (55, 16);
            n__w.minimum = 1;
            n__w.value = _w;
            n__w.name = 'W';
            n__w.draw ();

            var l__h : Label = new Label (panel, 111, 20, 'H');

            var n__h : NumericStepper = new NumericStepper (panel, 128, 20, setProp);
            n__h.setSize (55, 16);
            n__h.minimum = 1;
            n__h.value = _h;
            n__h.name = 'H';
            n__h.draw ();

            var l__s : Label = new Label (panel, 30, 41, 'SEED');

            var b_sd : PushButton = new PushButton (panel, 70, 42, 'RANDOMIZE', setProp);
            b_sd.setSize (113, 16);
            b_sd.name = 'S';
            b_sd.draw ();
            

            var l_hl : Label = new Label (panel, 30, 58, 'RANGE');

            var s_hl : HRangeSlider = new HRangeSlider (panel, 70, 76, null);
            s_hl.labelPosition = 'top';
            s_hl.maximum = 0xFF;
            s_hl.highValue = hi;
            s_hl.lowValue  = lo;
            s_hl.width = 113;
            s_hl.name = 'R';
            s_hl.draw ();

            s_hl.addEventListener (Event.CHANGE, setProp); // # CONSTRUCTOR (DEF RANGE 0 | 100)

            // --o COMBO

            var cb_a : Array =
            [
                { label : 'RED', data : 1 },
                { label : 'GREEN', data : 2 },
                { label : 'RED | GREEN', data : 3 },
                { label : 'BLUE', data : 4 },
                { label : 'RED | BLUE', data : 5 },
                { label : 'GREEN | BLUE', data : 6 },
                { label : 'RED | GREEN | BLUE', data : 7 },
                { label : 'ALPHA', data : 8 },
            ];

            var cb_c : ComboBox = new ComboBox (panel, 70, 92, 'COLORS', cb_a);
            cb_c.addEventListener (Event.SELECT, setProp);
            cb_c.numVisibleItems = cb_a.length;
            // cb_c.selectedIndex = ch - 1;
            cb_c.setSize (113, 16);
            cb_c.name = 'C';
            cb_c.draw ();

            var c_gs : CheckBox = new CheckBox (panel, 70, 114, 'GRAYSCALE', setProp);
            c_gs.name = 'G';

            var b_sv : PushButton = new PushButton (panel, 70, 130, 'EXPORT', setExport);
            b_sv.setSize (113, 16);
            b_sv.draw ();

            //

            panel.x = W - (194 + 10);
            panel.y = 10;

            addChild (panel);
        }

        private function setProp (e : Event) : void
        {
            switch (e.target.name)
            {
                case 'W' : _w = e.target.value; break;
                case 'H' : _h = e.target.value; break;
                case 'G' : gs = e.target.selected; break;
                case 'S' : sd = Math.random () * 0xFFFFFF; break;
                case 'C' : ch = e.target.selectedItem.data; break;
                case 'R' : lo = e.target.lowValue; hi = e.target.highValue; break;
            }

            setPattern ();
        }

        private function setDisplay (e : Event) : void
        {
            panel.x = W - (e.target.selected ? 194 + 10 : 20);
            panel.y = 10;
        }

        private function setDrag (e : MouseEvent) : void
        {
            if (panel_btn.selected) panel[(e.type == 'mouseUp' ? 'stopDrag' : 'startDrag')]();
        }

        private function setGraphicsBorderPath (x : int, y : int, w : Number, h : Number) : GraphicsPath
        {
            var header_size : uint = 20;

            return new GraphicsPath
            (
                Vector.<int>([1, 2, 2, 2, 2, 2, 2]),
                Vector.<Number>
                ([
                    x, y,
                    x + w + header_size, y, x + w + header_size, y + h,
                    x + header_size, y + h, x + header_size, y + header_size,
                    x, y + header_size,  x, y
                ])
            );
        }

        private function setExport (e : Event) : void
        {
            new FileReference().save
            (
                PNGEncoder.encode (NOISE_PATTERN.b), 'NOISE_PATTERN.png'
            );
        }
    }
}

//

import flash.display.BitmapData;

internal class NOISE_PATTERN
{
    public static function build
    (
        width : uint, height : uint, seed : int, lo : uint, hi : uint, colors : uint, grayscale : Boolean
    ) : BitmapData
    {
        b = new BitmapData (width, height, true, 0x00FFFFFF);
        b.noise (seed, lo, hi, colors, grayscale);
        return b;
    }

    public static var b : BitmapData;
}