/**
 * Copyright Dan0 ( http://wonderfl.net/user/Dan0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n2uU
 */

// forked from wh0's 100
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.text.*;
    
    import com.greensock.TweenLite;
    import com.greensock.easing.Linear;
    import com.greensock.easing.Quad;
    public class FlashTest extends Sprite {
        
        private static const black:TextFormat = new TextFormat('MS PGothic', 12, 0x202020);
        private static const white:TextFormat = new TextFormat('MS PGothic', 12, 0xe0e0e0);
        private static const lightEngrave:Array = [new DropShadowFilter(1, 90, 0xffffff, 1, 0, 0, 2)];
        private static const darkEngrave:Array = [new DropShadowFilter(1, 270, 0x000000, 1, 0, 0, 2)];
        private static const shadow:Array = [new DropShadowFilter(2, 90, 0x000000, 0.25, 12, 12, 1, BitmapFilterQuality.HIGH)];
        private static const m:Matrix = new Matrix();
        
        private var YAWA:Object;
        private var authorId:String;
        private var page:int = 1;
        private var codes:Array = null;
        
        private var gallery:Sprite;
        private var intro:Sprite;
        private var top:Sprite;
        private var overview:Sprite;
        
        private var icon:Bitmap;
        private var cover:Bitmap;
        private var overviewMask:Shape;
        
        private var total:Number;
        
        public function FlashTest() {
            useYAWA(onReady);
            
            m.createGradientBox(stage.stageWidth * 2, stage.stageHeight * 2, 0, -stage.stageWidth * 0.5, -stage.stageHeight * 0.75);
            graphics.beginGradientFill(GradientType.RADIAL, [0xf0f0f0, 0xc0c0c0], [1, 1], [0, 255], m);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            gallery = new Sprite();
            gallery.x = 20;
            gallery.y = stage.stageHeight - 80;
            addChild(gallery);
            
            intro = new Sprite();
            addChild(intro);
            
            top = new Sprite();
            m.createGradientBox(stage.stageWidth, 24, Math.PI / 2, 0, 0);
            top.graphics.beginGradientFill(GradientType.LINEAR, [0x303030, 0x505050], [1, 1], [0, 255], m);
            top.graphics.drawRect(0, 0, stage.stageWidth, 24);
            top.graphics.beginFill(0x000000);
            top.graphics.drawRect(0, 23, stage.stageWidth, 1);
            top.y = -25;
            top.filters = shadow;
            addChild(top);
            
            overview = new Sprite();
            overview.x = 20;
            overview.y = stage.stageHeight - 20;
            addChild(overview);
            
            stage.frameRate = 60;
            Wonderfl.capture_delay(10);
        }
        
        private function onReady(o:Object):void {
            YAWA = o;
            YAWA.requestCodeInfo(onCodeInfo, loaderInfo.parameters.appId);
        }
        
        private function onCodeInfo(data:Object):void {
            authorId = data.user.name;
            hax(data.user.icon, iconComplete);
        }
        
        private function iconComplete(bmp:Bitmap):void {
            intro.x = (stage.stageWidth - bmp.width) >> 1;
            intro.y = (stage.stageHeight - bmp.height) >> 1;
            
            icon = bmp;
            icon.filters = [new ColorMatrixFilter([
                1. / 3, 1. / 3, 1. / 3, 0, 0,
                1. / 3, 1. / 3, 1. / 3, 0, 0,
                1. / 3, 1. / 3, 1. / 3, 0, 0,
                0, 0, 0, 0.5, 0
            ])];
            intro.addChild(icon);
            
            var nameText:TextField = new TextField();
            nameText.mouseEnabled = false;
            nameText.defaultTextFormat = black;
            nameText.filters = lightEngrave;
            nameText.text = authorId;
            nameText.width = nameText.textWidth + 4;
            nameText.height = nameText.textHeight + 4;
            nameText.y = icon.height + 4;
            nameText.x = (icon.width - nameText.textWidth) >> 1;
            intro.addChild(nameText);
            
            intro.y += 20;
            intro.alpha = 0;
            TweenLite.to(intro, 0.25, {y: intro.y - 20, alpha: 1, onComplete: introShowComplete});
            
            var topIcon:Bitmap = new Bitmap(bmp.bitmapData);
            topIcon.width = topIcon.height = 16;
            topIcon.x = topIcon.y = 4;
            top.addEventListener(MouseEvent.CLICK, function (e:MouseEvent):void {
                navigateToURL(new URLRequest('http://wonderfl.net/user/' + authorId));
                e.stopPropagation();
            });
            top.buttonMode = true;
            top.addChild(topIcon);
            
            var topNameText:TextField = new TextField();
            topNameText.mouseEnabled = false;
            topNameText.defaultTextFormat = white;
            topNameText.filters = [new DropShadowFilter(1, 270, 0x000000, 1, 0, 0)];
            topNameText.text = authorId;
            topNameText.width = topNameText.textWidth + 4;
            topNameText.height = topNameText.textHeight + 4;
            topNameText.x = 24;
            topNameText.y = 5;
            top.addChild(topNameText);
        }
        
        private function introShowComplete():void {
            var bd:BitmapData = new BitmapData(icon.width, icon.height, false);
            bd.draw(this, new Matrix(1, 0, 0, 1, -intro.x, -intro.y));
            icon.filters = [];
            cover = new Bitmap(bd);
            intro.addChild(cover);
            
            var sh:Shape = new Shape();
            sh.graphics.beginFill(0x000000);
            sh.graphics.drawRect(0, 0, icon.width, icon.height);
            intro.addChild(sh);
            cover.mask = sh;
            
            YAWA.requestUserInfo(onUserInfo, authorId);
        }
        
        private function onUserInfo(data:Object):void {
            var descText:TextField = new TextField();
            descText.mouseEnabled = false;
            descText.defaultTextFormat = white;
            descText.filters = darkEngrave;
            descText.text = '\u201c' + data.description + '\u201d';
            descText.width = descText.textWidth + 4;
            descText.height = descText.textHeight + 4;
            descText.x = stage.stageWidth - descText.width - 2;
            descText.y = 5;
            top.addChild(descText);
            
            onUserInfoCode(data);
        }
        
        private function onUserInfoCode(data:Object):void {
            TweenLite.to(cover.mask, 0.25, {y: -icon.height / data.codes_pages * page, onComplete: moveMaskComplete});
            if (page++ < data.codes_pages) {
                YAWA.requestUserInfo(onUserInfoCode, authorId, YAWA.USER_INFO_CODE, page);
            } else {
                codes = data.codes;
            }
        }
        
        private function moveMaskComplete():void {
            if (!codes) return;
            TweenLite.to(intro, 0.25, {y: intro.y + 20, alpha:0, onComplete: hideIntroComplete});
            TweenLite.to(top, 0.25, {y: 0});
        }
        
        private function hideIntroComplete():void {
            removeChild(intro);
            intro = null;
            icon = null;
            cover = null;
            
            codes.reverse(); // chronological order...
            
            var flow:Number = 0;
            var back:Shape = new Shape();
            var front:Shape = new Shape();
            back.graphics.beginFill(0xc0c0c0);
            front.graphics.beginFill(0x808080);
            for each (var code:Object in codes) {
                var dim:Number = Math.ceil(Math.sqrt(code.pv + 40) * 5);
                hax(code.thumb, bindCallback(code, flow, dim));
                back.graphics.drawRect(flow, -dim, dim, dim);
                front.graphics.drawRect(flow, -dim, dim, dim);
                flow += dim + 20;
            }
            total = flow - 20;
            
            overview.addChild(back);
            overview.addChild(front);
            
            overviewMask = new Shape();
            overviewMask.graphics.beginFill(0x000000, 0.25);
            overviewMask.graphics.drawRect(0, -gallery.y, stage.stageWidth, stage.stageHeight);
            overview.addChild(overviewMask);
            front.mask = overviewMask;
            
            overview.mouseEnabled = false;
            overview.scaleX = overview.scaleY = Math.min(0.1, (stage.stageWidth - 40) / total);
            overview.filters = [new DropShadowFilter(1, 90, 0x000000, 0.25, 2, 2, 1, BitmapFilterQuality.HIGH, true)];
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
        }
        
        private function onMouseWheel(e:MouseEvent):void {
            Wonderfl.log(e);
        }
        
        private function bindCallback(code:Object, flow:Number, dim:Number):Function {
            return function (bmp:Bitmap):void {
                var s:Sprite = new Sprite();
                s.x = flow;
                s.y = -dim;
                s.addEventListener(MouseEvent.CLICK, function (e:MouseEvent):void {
                    navigateToURL(new URLRequest(code.url));
                    e.stopPropagation();
                });
                s.buttonMode = true;
                
                bmp.width = bmp.height = dim;
                bmp.filters = shadow;
                s.addChild(bmp);
                
                var title:TextField = new TextField();
                title.mouseEnabled = false;
                title.defaultTextFormat = black;
                title.filters = lightEngrave;
                title.text = code.title;
                title.width = Math.min(dim, title.textWidth + 4);
                title.height = title.textHeight + 4;
                title.x = (dim - title.width) >> 1;
                title.y = dim + 4;
                s.addChild(title);
                
                var pv:TextField = new TextField();
                pv.mouseEnabled = false;
                pv.defaultTextFormat = black;
                pv.filters = lightEngrave;
                pv.text = code.pv + ' pv';
                pv.width = pv.textWidth + 4;
                pv.height = pv.textHeight + 4;
                pv.y = -pv.height - 4;
                s.addChild(pv);
                
                var lines:TextField = new TextField();
                lines.defaultTextFormat = black;
                lines.filters = lightEngrave;
                lines.text = code.lines + ' lines';
                lines.width = lines.textWidth + 4;
                lines.height = lines.textHeight + 4;
                lines.x = dim - lines.width;
                lines.y = -lines.height - 4;
                s.addChild(lines);
                
                if (dim < pv.width + lines.width) {
                    lines.x = dim - lines.width;
                    lines.y = -lines.height - 4;
                    pv.x = dim - pv.width;
                    pv.y = -pv.height - 4 + lines.y;
                }
                
                gallery.addChild(s);
                s.y += 20;
                s.alpha = 0;
                TweenLite.to(s, 0.25, {y: s.y - 20, alpha:1});
            }
        }
        
        private static const IDLE:int = 0;
        private static const DRAG:int = 1;
        private static const JUMP:int = 2;
        
        private var mouseMode:int = IDLE;
        private var downX:Number = NaN;
        private var startX:Number = NaN;
        
        private function onMouseDown(e:MouseEvent):void {
            if (mouseY < stage.stageHeight - 60) {
                mouseMode = DRAG;
                downX = mouseX;
                startX = overviewMask.x;
            } else {
                mouseMode = JUMP;
                refresh(overview.mouseX - stage.stageWidth / 2);
            }
        }
        
        private function onMouseUp(e:MouseEvent):void {
            mouseMode = IDLE;
            downX = NaN;
            startX = NaN;
        }
        
        private function onMouseMove(e:MouseEvent):void {
            if (mouseMode == DRAG) {
                refresh(downX - mouseX + startX);
            } else if (mouseMode == JUMP) {
                refresh(overview.mouseX - stage.stageWidth / 2);
            }
        }
        
        private function refresh(x:Number):void {
            overviewMask.x = Math.max(-20, Math.min(total + 20 - stage.stageWidth, x));
            gallery.x = -overviewMask.x;
        }
        
        private function hax(url:String, callback:Function=null):void {
            var l1:Loader = new Loader();
            var l2:Loader = new Loader();
            l1.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
                l2.loadBytes(l1.contentLoaderInfo.bytes);
            });
            if (callback != null) l2.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
                callback((l2.content as DisplayObjectContainer).getChildAt(0));
            });
            l1.load(new URLRequest(url));
        }
        
    }
}

import flash.net.*;
import flash.events.*;
import flash.display.*;

function useYAWA(onReady:Function, swfurl:String="http://swf.wonderfl.net/swf/usercode/8/8f/8f46/8f46608d59b94c39bf42b94a89c1819f9e3bce61.swf") : void {
    var loader:Loader = new Loader();
    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event) : void { onReady(e.target.content); });
    loader.load(new URLRequest(swfurl + "?t=" + String(int(new Date().time))));
}