/**
 * Copyright hacker_f21vgseo ( http://wonderfl.net/user/hacker_f21vgseo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n2Wg
 */

// forked from shohei909's ガララルームス(GARARA Rooms) mini var0.0
// forked from shohei909's パズルゲーム用マップ
//GARARA Rooms FIRST STAGE
//最初なので、もっと簡単な問題を作るつもりでしたが、割とむずかしくなってしまった気がします。
package {
    import flash.display.*;
    import caurina.transitions.Tweener;
    [SWF(width="465", height="465", backgroundColor="0x111111", frameRate="24")]
    public class Game extends Sprite {
        private var loaders:Vector.<Loader>, data:Data = new Data();
        static public var effectMap: EffectMap;
        function Game() {

            //マップデータの作成====================================================================  
            //o:何もなし　a:レンガ　b:鉄壁　c:木箱　d:鉄箱 e:梯子 f:鍵箱　　s:スタート　g:ゴール
            var o:Array = [], a:Array = [ ["brick"] ], b:Array = [ ["iron"] ], c:Array = [ ["wood"] ], d:Array = [ ["wall"] ],e:Array = [ ["lad"] ], f:Array = [ ["box"],["key"] ], s:Array = [ ["mirai"] ],　g:Array = [ ["lock"],["goal","clear"] ];
            data.stageMap[0] = [ //オリジナルのステージを作る場合、ここを編集する。
                [ o, o , o , o , o , o , o , o , o , o ],
                [ o, o , o , o , o , f , o , o , o , o ],
                [ o, o , o , o , d , d , d , o , o , o ],
                [ o, o , o , c , o , b , o , o , o , o ],
                [ g, o , e , d , d , d , d , e , o , o ],
                [ d, o , e , o , o , d , o , e , o , o ],
                [ s, o , a , o , o , o , o , e , o , o ]
            ];
            //=======================================================================================        
            
            
            loaders = data.load();
            var nowload:NowLoading = new NowLoading(stage,init);z
            for each(var loader:Loader in loaders){
                nowload.addLoader(loader);
            }
        }
        private function init():void{
            Tweener.addTween(stage.getChildAt(1),{alpha:0,time:3,onComplete:function():void{stage.removeChildAt(1)} });
            
            effectMap = new EffectMap(465,465);
            var room:Room = new Room(data);
            room.scaleX = room.scaleY = 2;
            
            addChild( room );
            addChild( effectMap );

            alpha=0; Tweener.addTween(this,{delay:1,alpha:1,time:3} );
            //addChild( new Stats() )
        }
    }
}
import flash.utils.ByteArray;
import flash.system.LoaderContext;
import flash.geom.*;
import flash.display.*;
import flash.text.TextField;
import flash.events.*;
import flash.net.*;
import caurina.transitions.*;

//オブジェクト作成はデータのロード後に行う。
class Room extends Sprite {


    //イメージの場所を記録した配列
    private var imgArray:Array;
    private var mapWidth:int,mapHeight:int;

    public var objects:Vector.<GameObject> = new Vector.<GameObject>;
    public var focus:GameObject;
    private var keyEvent:KeyboardEvent;
    
    private var data:Data;
    private var stageNum:int = 0 //現在のステージ番号
    public var wait:int = 0; //設定されている時間だけ一時停止
    public var stop:Boolean = false; //trueのとき一時停止
    
    
    private var bitmap:Bitmap;
    private var backmapData:BitmapData;
    
    public function Room(d:Data) {
        bitmap=new Bitmap( new BitmapData(1,1) );    
        addChild(bitmap);
        
        data = d;
        readData(data.stageMap[0]);    

        addEventListener("addedToStage",init);
    }

    private function init(e:Event):void{
        removeEventListener("addedToStage",init);
        
        addEventListener("enterFrame", onFrame );
        stage.addEventListener("keyDown", onKeyDown );
        stage.addEventListener("keyUp", onKeyUp );
    }
    
    private function readData(arr:Array):void {
        objects = new Vector.<GameObject>;
        focus = null;
        mapWidth=arr[0].length+2;
        mapHeight=arr.length+2;
        bitmap.bitmapData = new BitmapData(mapWidth * Data.cellWidth, mapHeight * Data.cellHeight, true, 0x0);
        backmapData = new BitmapData(mapWidth * Data.cellWidth, mapHeight * Data.cellHeight, true, 0x0);
        
        for(var i:int=0;i<mapHeight;i++){  
            for(var j:int=0;j<mapWidth;j++){
                if( i<mapHeight-1 && i>0 && j<mapWidth-1 && j>0 ){
                    var obj:Array = arr[i-1][j-1];
                    for(var k:int=0;k<obj.length;k++){
                        var name:String = obj[k][0];
                        var param:String = obj[k][1];
                        if(param == null){ param = "" }
                        if(name == "mirai"){
                            focus = Data.setObject( this, j, i, name, param);
                        }else{
                            Data.setObject( this, j, i, name, param);
                        }
                    }
                    if(i%4 == 0 && j%2 == 0){
                        Data.setObject( this, j, i, "acs", "" );
                    }
                }else if(i<mapHeight-1 && i>0){
                    Data.setObject( this, j, i, "wall", "");
                }else{
                    Data.setObject( this, j, i, "brick", "");
                }
                data.draw(backmapData, "room", "back", j*Data.cellWidth, i*Data.cellHeight, true );
            }
        }
        Sound.music()
    }
    public function jump( jumpers:Array,x:int,y:int, stage:int ):void{
        stageNum = stage 
        readData(data.stageMap[stageNum]);
        for each( var jumper:GameObject in jumpers ) {
            Data.jumpObject( this, y, x, jumper)
            focus = jumper;
        }
        onFrame(); wait=10;
    }
    
    public function check(x:int,y:int,type:String = ""):Vector.<GameObject>{
        var vec:Vector.<GameObject> = new Vector.<GameObject>()
        for each( var obj:GameObject in objects ){
            if(obj.mapX == x && obj.mapY == y && ( (obj.ability[type] != null && obj.ability[type] == true) || type == "" )){ vec.push(obj) }
        } 
        return vec;
    }
    
    public function checkName(name:String):Vector.<GameObject>{
        var vec:Vector.<GameObject> = new Vector.<GameObject>()
        for each( var obj:GameObject in objects ){
            if( obj.objectName == name ){ vec.push(obj) }
        } 
        return vec;
    }
    
    private function onFrame(e:Event = null):void {
        if(stop){
        }else{
            if (wait > 0) {
                wait--;
            }else{    
                bitmap.bitmapData.lock();
                bitmap.bitmapData.fillRect(bitmap.bitmapData.rect,0xFF000000);
                bitmap.bitmapData.draw(backmapData);
                
                for each( var o:GameObject in objects){
                    if(o.tween.length > 0){ o.move() }
                    if(o.tween.length == 0 && o.frame != null ){ o.frame(o) }
                    if( o.tween.length == 0 && keyEvent != null && o.key != null ){ 
                        o.key(keyEvent,o);
                    } 
                    if( o.anim != null ){ o.animation() }
                    data.draw(bitmap.bitmapData, o.type, o.state, o.x, o.y, o.dir!=o.rev );
                }
                if(focus != null){
                    x = -focus.x*scaleX+(-Data.cellWidth + stage.stageWidth)/2;
                    y = -focus.y*scaleY+(-Data.cellHeight + stage.stageHeight)/2;
                }
                bitmap.bitmapData.unlock();
            }
        }
    }
    
    private function onKeyDown(e:KeyboardEvent):void{ keyEvent = e; }
    private function onKeyUp(e:KeyboardEvent):void{ keyEvent = null; }
}

//マップに配置するオブジェクト
class GameObject extends Object {
    public var objectName:String = "null"            //オブジェクト名
    public var depth:int = 0;                //深度
    public var anim:Object;                //アニメーションに関するデータ
    public var dir:Boolean = true;        //向き
    public var rev:Boolean = false;        //画像反転

    //オブジェクトの性質を表す。
    public var ability:Object = {}; 
    
    public var frame:Function;    //毎フレーム呼び出される:void
    public var key:Function;    //キーボード操作で呼び出される(e:Event):void
    public var damage:Function;    //食べられたとき呼び出される。:void
    public var hit:Function;    //叩かれたとき呼び出される。:void
    public var open:Function;    //なかに入ろうとしたとき呼び出される。:Boolean
    public var kick:Function;    //蹴られたとき呼び出される。(dirX):Boolean
    public var react:Function;    //(戻り値:String)
    public var pick:Function;    //拾われたとき呼び出される:void
    public var param:String;    //マップ作成時に設定したパラメータ
    public var name:String;    //オブジェクトの名前
    public var room:Room;    //配置された部屋

    public var x:Number,y:Number;
    public var mapX:int,mapY:int;
    public var state:String;    //画像の状態
    public var type:String;        //使用する画像のタイプ
    public var count:int = 0;
    
    public var animState:String;//現在選択されているアニメーション
    
    //tween?
    public var tweenFrame:Vector.<int> = new Vector.<int>(); 
    public var tween:Vector.<Object> = new Vector.<Object>();                
    
    //アニメーション時に呼び出される
    public function animation():void{
        if(anim[animState]!=null){
            var data:Array = anim[animState];
            //配列から現在のカウントと一致するものを取り出す。
            data = data.filter(function(d:*, i:int, a:Array):Boolean{return d[0]==this.count},this);
            
            for each(var act:Array in data){
                switch(act[1]){
                    case "goto":
                        count = act[2];break;
                    case "action":
                        animState = act[2];
                        count = -1; break;
                    case "happen":
                        Happening.happen( act[2] );break;
                    default:
                        state = act[1];
                        if( act[2] != null && act[2] == true){rev = true}
                        else{rev = false}
                }
            }
            count++;
        }
    }
    
    public function action(state:String,count:int=0):void{
        animState = state; this.count = count;
    }
    public function addTween( o:Object, frame:int = 1, delay:int = 0):void{
        tween.push(o); tweenFrame.push(frame);
    };
    public function move():void{
        for(var str:String in tween[0]){
            this[str] = ( this[str]* (tweenFrame[0]-1) + tween[0][str] ) / tweenFrame[0];
        }
        tweenFrame[0]--;
        if( tweenFrame[0] == 0){ tween.shift(); tweenFrame.shift(); }
    }
}


//主人公に関するデータ用クラス
class Mirai{
    static public const name:String = "みらい";
    static public const age:int = 14;
    static public const gender:String = "♀";
    static public const info:String = "主人公";
     
    static public const anim:Object = {
        "stand": [[0,"w0"],[200,"action","sleep"]], 
        "walk1":[[0,"w1"],[2,"w0"],[200,"action","sleep"]],
        "walk2":[[0,"w2"],[2,"w0"],[200,"action","sleep"]],
        "sleep":[[0,"s0"],[96,"s1"],[100,"goto",-1]],
        "kick":[[0,"k0"],[1,"k1"],[11,"k0"],[12,"action","stand"]],
        "hit":[[0,"a0"],[4,"a1"],[5,"a2"],[11,"a1"],[12,"action","stand"]],
        "climb":[[0,"u"],[2,"u",true]],
        "turn":[[0,"t"],[2,"t",true],[3,"action","walk1"]],
        "sit":[[0,"s"]],
        "jump":[[0,"k0"],[1,"f"],[3,"s"],[5,"action","walk1"]],
        "touch":[[1,"f"],[3,"action","stand"]],
        //"dance":[ [0,"w2"],[2,"w0"],[10,"w2"],[32,"k0"],[103,"k1"],[34,"w2",true],[82,"w0",true],[73,"w2",true],[60,"s"],[92,"t",true],[162,"k0",true],[133,"k1",true],[20,"happen","danceEnd"]],
        "open":[ [0,"b"] ]
    }
    
    static public function fall(mirai:GameObject):void{
        if( mirai.room.check( mirai.mapX, mirai.mapY+1, "block" ).length == 0 && mirai.room.check( mirai.mapX, mirai.mapY+1, "climb" ).length == 0 && mirai.room.check( mirai.mapX, mirai.mapY, "climb" ).length == 0){
            mirai.addTween( {y:mirai.y+Data.cellWidth}, 4 );
            mirai.mapY++;
            mirai.action("sit");
            
            var targets:Vector.<GameObject> = mirai.room.check( mirai.mapX, mirai.mapY, "pick" );
            for each(var o:GameObject in targets) {
                o.pick(o);
            }
        }
    }
    
    static public function key(e:KeyboardEvent,mirai:GameObject):void{
        var c:int; var dirX:int; var targets:Vector.<GameObject>; var o:GameObject
        switch( Data.keyString[e.keyCode] ){
            case "→":
                if(mirai.dir){ 
                    if( mirai.room.check( mirai.mapX+1, mirai.mapY, "block" )==false ){
                        mirai.addTween( {x:mirai.x+Data.cellWidth}, 4 );
                        mirai.mapX++;
                        if(mirai.animState == "walk1"){ mirai.action("walk2"); 
                        }else{ mirai.action("walk1"); }
                    }else{ 
                        kick(mirai);
                    }
                }else{ 
                    mirai.action("turn");
                    mirai.addTween( {}, 2 );
                }
                mirai.dir = true;
                break;
            case "←":
                if(mirai.dir == false){ 
                    if( mirai.room.check( mirai.mapX-1, mirai.mapY, "block" )==false ){
                        mirai.addTween( {x:mirai.x-Data.cellWidth}, 4 );
                        mirai.mapX--;
                        if(mirai.animState == "walk1"){ mirai.action("walk2"); 
                        }else{ mirai.action("walk1"); }
                    }else { 
                        kick(mirai);
                    }
                    
                }else{ 
                    mirai.action("turn");
                    mirai.addTween( {}, 2 );
                }
                mirai.dir = false;
                break;
            case "↑":
                if( mirai.room.check( mirai.mapX, mirai.mapY, "climb" ).length > 0 && mirai.room.check( mirai.mapX, mirai.mapY, "block" ).length == 0 ){
                    mirai.action("climb");
                    mirai.addTween( {y:mirai.y-Data.cellHeight}, 4 );
                    mirai.mapY--;
                    Sound.se(4)
                }else if( (targets = mirai.room.check( mirai.mapX, mirai.mapY, "door" ) ).length > 0 && mirai.room.check( mirai.mapX, mirai.mapY, "lock" ).length == 0){
                    Sound.se(6);
                    mirai.action("open");
                    for each(o in targets){
                        o.open(o);
                    }
                }else{    
                    mirai.action("stand");
                }
                
                break;
            case "↓":
                if( mirai.room.check( mirai.mapX, mirai.mapY+1, "climb" ).length > 0 && mirai.room.check( mirai.mapX, mirai.mapY+1, "block" ).length == 0 ){
                    mirai.action("climb");
                    mirai.addTween( {y:mirai.y+Data.cellHeight}, 4 );
                    mirai.mapY++;
                    Sound.se(4)
                }else {
                    mirai.action("sit");
                }
                break;
            case "z":
                if(mirai.dir){ dirX = 1 }
                else{ dirX = -1 }
                mirai.action("hit");
                mirai.addTween( {}, 15 );
                targets = mirai.room.check( mirai.mapX + dirX, mirai.mapY, "hit" );
                for each( o in targets ){
                    o["hit"](o)
                }
                break;
            
        }
    
        targets = mirai.room.check( mirai.mapX, mirai.mapY, "pick" );
        for each(o in targets) {
            o.pick(o);
        }
    }
    //蹴り
    static private function kick(mirai:GameObject) :void{
        var dirX:int; var targets:Vector.<GameObject>; var o:GameObject;
        if(mirai.dir){ dirX = 1 }
        else{ dirX = -1 }
        if( mirai.room.check( mirai.mapX + dirX, mirai.mapY, "talk" ).length == 0 ){
            var jump:Boolean = false;
            targets = mirai.room.check( mirai.mapX + dirX, mirai.mapY, "block" );
            mirai.addTween( {}, 1 );
            if(targets.length > 0){
                for each( o in targets ){
                    if( o["kick"](o, dirX) ){ jump = true }
                }
            }
            if(jump){
                if(mirai.room.check( mirai.mapX, mirai.mapY-1, "block" ).length == 0){
                    mirai.action("jump");
                    mirai.addTween( {y:mirai.y-Data.cellHeight}, 4 );
                    mirai.mapY--;
                    mirai.addTween( {}, 1 );
                    if( mirai.room.check( mirai.mapX + dirX, mirai.mapY, "block" ).length == 0 ){
                        mirai.addTween( {x:mirai.x+Data.cellWidth*dirX}, 4 );
                        mirai.mapX += dirX;
                    }
                }else{
                    mirai.action("touch");
                    mirai.addTween( {}, 3 );
                }
            }else{ 
                mirai.action("kick");
                mirai.addTween( {}, 15 );
            }
        }
    }
}


/*後々、追加する予定のキャラクター
//弟に関するデータ用静的クラス
class Haru{
    static public const name:String = "はる";
    static public const age:String = "10";
    static public const gender:String = "♂";
    static public const info:String = "主人公の弟。怖がり。"
}
//イカツイおっさんに関するデータ用静的クラス
class Kaji{
    static public const name:String = "加地";
    static public const age:String = "?";
    static public const gender:String = "♂";
    static public const info:String = "イカツイおっさん。長身。猫背。";
}
*/

//障害物用データクラス
class Block{
    static public function fall(block:GameObject):void{
        if( block.room.check( block.mapX, block.mapY+1, "block" ).length == 0 ){
            block.addTween( {y:block.y+Data.cellHeight}, 4 );
            block.mapY++;
        }
    }
    
    static public function slide( block:GameObject, dirX:int ):Boolean{
        if( block.room.check( block.mapX + dirX, block.mapY, "block" ).length == 0 ){
            var targets:Vector.<GameObject> = block.room.check( block.mapX , block.mapY, "pick" );
            targets.push(block);
            for each( var o:GameObject in targets ){
                o.addTween( {x:o.x+Data.cellWidth*dirX}, 4 );
                o.mapX+=dirX; 
            }
            Sound.se(0);
            return false;
        }
        return true;
    }
    static public function clip( block:GameObject, dirX:int ):Boolean{
        return true;
    }
    static public function hit( block:GameObject ):void{
        block.ability["block"] = false;
        block.ability["hit"] = false;
        block.frame = fall;
        block.state = "sc";
        Sound.se(1,1)
    }
    static public function block( block:GameObject ):void{
        Sound.se(2,1)
    }
    static public function key( key:GameObject ):void{
        var par:Vector.<GameObject> = key.room.objects;
        var targets:Vector.<GameObject> = key.room.objects.filter( 
            function func(item:GameObject, index:int, vec:Vector.<GameObject>):Boolean {
                var bool:Boolean = ( item.ability.lock != null && item.param == this.param ) 
                return bool;
            } 
            ,key
        );
        for each( var o:GameObject in targets ){
                par.splice(par.indexOf(o),1)    
        }
        par.splice(par.indexOf(key),1)
        Sound.se(3)
    }
    static public function open( door:GameObject ):void{
        if( door.param == "clear" ){
            door.room.stop = true;
            Sound.music(2)
            Tweener.addTween(Game.effectMap.color, { a:0.7, time:4 } );
        }
    }
}

//探索イベント用データクラス
class Happening {
    static public function pick(o:GameObject):void {
        switch(o.param) {
        }
    }
    static public function happen(param:String):void{
        switch(param) {
        }
    }
}

//ゲームデータ用クラス
class Data{
    static public const keyString:Object = {37:"←",38:"↑",39:"→",40:"↓",88:"x",90:"z"}
    static public const URL:Object = {
        "room0":"http://assets.wonderfl.net/images/related_images/a/a9/a9e2/a9e20cefbcd7977d77e38ddfc199849352a4f232",
        "mirai0":"http://assets.wonderfl.net/images/related_images/a/ac/ac87/ac877ce6d163a55437b47cf54eaf8353b9e80698"
    }
    static public const URL_NAME:Array=["mirai0","room0"];
    
    static public const IMG_NAME:Object = {
        "room":["back","brick","wall","wood","iron","box","door0","door1","door2","door3","door4","happen","acs0","acs1","acs2","lad1","lad0","lad2","holl","key1","key2","key3","key4","sc"],
        "mirai":["w0","w1","w2","a0","a1","a2","s0","b",
                "t", "u", "u2", "s", "k0","k1","s1","f"]
    }
    
    static public const OBJECT:Object = {
        "mirai":[["depth",-5],["type","mirai"],["frame",Mirai.fall],["anim",Mirai.anim],["key",Mirai.key],["animState","stand"]],
        "back":[["depth",50],["type","room"],["state","back"]],
        "brick":[["depth",5],["type","room"],["state","brick"],["hit",Block.hit],["kick",Block.clip],["ability",{block:true,hit:true}]],
        "wall":[["depth",5],["type","room"],["state","wall"],["hit",Block.block],["kick",Block.clip],["ability",{block:true,hit:true}]],
        "wood":[["depth",-1],["type","room"],["state","wood"],["hit",Block.hit],["kick",Block.slide],["frame",Block.fall],["ability",{block:true,hit:true}]],
        "iron":[["depth",5],["type","room"],["state","iron"],["hit",Block.block],["kick",Block.slide],["frame",Block.fall],["ability",{block:true,hit:true}]],
        "box":[["depth",-1],["type","room"],["state","box"],["hit",Block.hit],["kick",Block.slide],["frame",Block.fall],["ability",{block:true,hit:true}]],
        "key":[["depth",4],["type","room"],["state","key1"],["ability",{pick:true}],["pick",Block.key],["frame",Block.fall]],
        "lad":[["depth", 10], ["type", "room"], ["state", "lad1"],["ability",{climb:true}]],
        "acs":[["depth",20],["type","room"],["anim",{"move":[[0,"acs0"],[10,"acs1"],[20,"acs2"],[29,"goto",-1]]}],["animState","move"]],
        "start":[["depth",20],["type","room"],["state","door0"],["ability",{door:true}]],
        "lock":[["depth",19],["type","room"],["state","holl"],["ability",{lock:true}]],
        "goal":[["depth",20],["type","room"],["state","door1"],["ability",{door:true}],["open",Block.open] ],
        "hap":[["depth",1],["type","room"],["state","happen"],["ability",{pick:true}],["pick",Happening.pick]]
    }
    
    public var stageMap:Array = [];   
    
    
    static public const cellWidth:int=27,cellHeight:int=27;
    //各オブジェクトに使うビットマップデータの設定
    public var MAP_SET:Object = {
        "mirai":"mirai0",
        "room":"room0"
    }
    
    //ビットマップを記録したオブジェクト。ロード後に使用可能
    public var imageMap:Object = {};
    public var imageCell:Object = {};
    public var imageRect:Object = {};
    
    private var　loaders:Vector.<Loader> = new Vector.<Loader>();
    
    //画像をロード。ローダーの配列を作る。
    public function load():Vector.<Loader>{
        for each(var url:String in URL){
            var loader:Loader = new Loader(); 
            loaders.push(loader);
        }
        loaders[0].load(new URLRequest(URL[URL_NAME[0]]), new LoaderContext(true));
        loaders[0].contentLoaderInfo.addEventListener("complete",onLoad,false,1000);
        return loaders;
    }
    //bitmapdataに画像を描画する
    public function draw(target:BitmapData,type:String,name:String,x:int=0,y:int=0,dir:Boolean=true):void{
        var map:String = MAP_SET[type];
        var mtr:Matrix = new Matrix(-1,0,0,1,x+cellWidth,y)
        if (dir) { mtr.a = 1, mtr.tx = x }
        if(-1 < IMG_NAME[type].indexOf(name)){
            target.draw( imageCell[map][ IMG_NAME[type].indexOf(name) ],mtr)
        }
    }
    
    //指定した条件で部屋に物体を設置する。
    static public function setObject(room:Room, x:int,y:int,name:String,param:String):GameObject{
        if(name != null && OBJECT[name] != null){
            var arr:Array = clone( OBJECT[name] );         
            var gObj:GameObject = new GameObject();
            for each(var data:Array in arr){
                gObj[data[0]] = data[1];
            }
            gObj.room=room;
            gObj.param=param;
            gObj.objectName=name;
            gObj.mapX=x; gObj.x=x*cellWidth;
            gObj.mapY=y; gObj.y=y*cellHeight;
            //深度が低い順に並べる
            for(var i:int=0;i<room.objects.length;i++){
                if( room.objects[i].depth < gObj.depth ){break;}
            }
            room.objects.splice(i,0, gObj );
        }
        return gObj;
    }
    //指定した条件で部屋に物体を移動する。
    static public function jumpObject(room:Room, x:int, y:int, gObj:GameObject):void {
        gObj.room=room;
        gObj.mapX=x; gObj.x=x*cellWidth;
        gObj.mapY=y; gObj.y=y*cellHeight;
        //深度が低い順に並べる
        for(var i:int=0;i<room.objects.length;i++){
            if( room.objects[i].depth < gObj.depth ){break;}
        }
        room.objects.splice(i,0, gObj );
    }
    
    
    
    static private var loadNum:int = 0;
    private function onLoad(e:Event):void{
        e.currentTarget.removeEventListener("complete",onLoad);
        var rect:Rectangle = e.currentTarget.content.getRect(e.currentTarget.content);
        imageMap[URL_NAME[loadNum]]=new BitmapData(rect.width,rect.height,true,0x000000);
        imageMap[URL_NAME[loadNum]].draw( e.currentTarget.content );
        imageMap[URL_NAME[loadNum]].lock();
        setImageRect(URL_NAME[loadNum]);
        loadNum++;
        if(URL_NAME.length>loadNum){
            loaders[loadNum].load(new URLRequest(URL[URL_NAME[loadNum]]), new LoaderContext(true));
            loaders[loadNum].contentLoaderInfo.addEventListener("complete",onLoad,false,1000);
        }
    }
    
    private function setImageRect(name:String):void{
        imageCell[name] = [];
        var map:BitmapData = imageMap[name];
        var lineColor:uint = map.getPixel32(map.width-1,map.height-1);
        var x:int = 0; var y:int=0; var height:int=0; var width:int=0; var count:int=0;
        while(true){
            width=0;height=0;
            if(lineColor != map.getPixel32(x,y) ){
                for(var i:int=1;i+x<map.width;i++){
                    if( lineColor == map.getPixel32(x+i,y) ){break;}
                }
                width=i;
                for(var j:int=1;j+y<map.width;j++){
                    if( lineColor == map.getPixel32(x,y+j) ){break;}
                }
                height=j;
                var rect:Rectangle = new Rectangle(x,y,width,height);
                var rect2:Rectangle = new Rectangle(0,0,width,height);
                
                var cell:BitmapData = new BitmapData(rect.width,rect.height,true,0x0)
                cell.setVector( rect2,map.getVector( rect ) );
                imageCell[name].push( cell );
            }
            x+=width+1;
            if(x>=map.width){ y+=height+1;x=0; }
            if(y>=map.height){ break; }
            count++;
        }
        
    }
}



//ロード画面
class NowLoading extends Sprite{
    static public const COMPLETE:String = "complete";
    public var loaders:Vector.<Object> = new Vector.<Object>;
    public var bytesTotal:uint=0,bytesLoaded:uint=0;
    private var _loaderNum:uint=0,_completedNum:uint=0,_openNum:uint=0; //ローダーの数
    private var text:Bitmap, sprite:ProgressSprite;
    private var onLoaded:Function;
    private var LETTER:Object = {
        "1":[[0,1,1],[0,0,1],[0,0,1],[0,0,1],[0,0,1]],"2":[[1,1,1],[0,0,1],[0,1,1],[1,0,0],[1,1,1]],"3":[[1,1,1],[0,0,1],[1,1,1],[0,0,1],[1,1,1]],"4":[[1,0,1],[1,0,1],[1,0,1],[1,1,1],[0,0,1]],"5":[[1,1,1],[1,0,0],[1,1,1],[0,0,1],[1,1,1]],
        "6":[[1,1,1],[1,0,0],[1,1,1],[1,0,1],[1,1,1]],"7":[[1,1,1],[0,0,1],[0,0,1],[0,0,1],[0,0,1]],"8":[[1,1,1],[1,0,1],[1,1,1],[1,0,1],[1,1,1]],"9":[[1,1,1],[1,0,1],[1,1,1],[0,0,1],[0,0,1]],"0":[[1,1,1],[1,0,1],[1,0,1],[1,0,1],[1,1,1]],
        ".":[[0],[0],[0],[0],[1]]," ":[[0],[0],[0],[0],[0]],"n":[[0,0,0],[0,0,0],[1,1,1],[1,0,1],[1,0,1]],"w":[[0,0,0,0,0],[0,0,0,0,0],[1,0,1,0,1],[1,0,1,0,1],[1,1,1,1,1]],"o":[[0,0,0],[0,0,0],[1,1,1],[1,0,1],[1,1,1]],
        "a":[[0,0,0],[0,0,1],[1,1,1],[1,0,1],[1,1,1]],"l":[[1],[1],[1],[1],[1]],"i":[[1],[0],[1],[1],[1]],"d":[[0,0,1],[0,0,1],[1,1,1],[1,0,1],[1,1,1]],"g":[[0,0,0],[0,0,0],[1,1,1],[1,0,1],[1,1,1],[0,0,1],[1,1,1]],
        "C":[[1,1,1],[1,0,0],[1,0,0],[1,0,0],[1,1,1]],"O":[[1,1,1],[1,0,1],[1,0,1],[1,0,1],[1,1,1]],"M":[[1,1,1,1,1],[1,0,1,0,1],[1,0,1,0,1],[1,0,1,0,1],[1,0,1,0,1]],"P":[[1,1,1],[1,0,1],[1,1,1],[1,0,0],[1,0,0]],
        "T":[[1,1,1],[0,1,0],[0,1,0],[0,1,0],[0,1,0]],"L":[[1,0,0],[1,0,0],[1,0,0],[1,0,0],[1,1,1]],"E":[[1,1,1],[1,0,0],[1,1,1],[1,0,0],[1,1,1]]
    }
    //ステージと関数を渡す
    public function NowLoading(stage:Stage, onLoaded:Function = null){
        if(onLoaded == null){ this.onLoaded=nullFunc }else{ this.onLoaded=onLoaded }
        sprite = new ProgressSprite(stage.stageWidth,stage.stageHeight);
        text = new Bitmap( new BitmapData(30*4,8,true,0x00000000 ) ); 
        stage.addChild(this); addChild(sprite); addChild(text);
        with(text){scaleX=scaleY=1; blendMode="invert"; x=stage.stageWidth-text.width; y=stage.stageHeight-text.height;}
    }
    //ローダーの追加
    public function addLoader(loader:Loader):Loader{ setListener(loader.contentLoaderInfo);_loaderNum++;return loader;}
    public function addURLLoader(loader:URLLoader):URLLoader{setListener(loader); _loaderNum++; return loader;}
    
    
    private function nullFunc():void{}
    private function setListener(loader:*):void{
        loader.addEventListener("open", onOpen);
        loader.addEventListener("complete", onComplete);
        loader.addEventListener("progress", update);
    }
    private function update(e:Event=null):void{
        bytesLoaded=0; bytesTotal=0;
        for each(var loadObj:Object in loaders){
            bytesLoaded += loadObj.bytesLoaded;
            bytesTotal += loadObj.bytesTotal;
        };
        sprite.progress(bytesLoaded/bytesTotal * _openNum/_loaderNum);
        if(bytesTotal!=0){ setText( "now loading... "+(bytesLoaded/bytesTotal* _openNum/_loaderNum*100).toFixed(1) ); }
    }
    private function onOpen(e:Event):void{ _openNum++;loaders.push(e.currentTarget); bytesTotal+=e.currentTarget.bytesTotal; }
    private function onComplete(e:Event):void{ _completedNum++;if(_loaderNum == _completedNum){ setText( "COMPLETE" );onLoaded(); } }
    private function setText(str:String):void{
        var b:BitmapData = text.bitmapData; var l:int = str.length; var position:int = b.width;
        b.lock();b.fillRect(b.rect,0x000000);
        for(var i:int=0;i<l;i++){
            var letterData:Array = LETTER[str.substr(l-i-1,1)];position-=letterData[0].length+1;
            for(var n:int=0;n<letterData.length;n++){ for(var m:int=0;m<letterData[n].length;m++){ 
                if(letterData[n][m]==1){b.setPixel32(m+position,n+1,0xFF000000);} 
            } }
        }
        b.unlock();
    }
}
//このスプライトを編集することでロード画面を変えることができる。
class ProgressSprite extends Sprite{
    private var mapData:BitmapData,sphereData:BitmapData,noizeData:BitmapData;
    private var bfRate:Number=0; //前の段階での進行度
    private var drawRate:Number=0;
    private var maxLevel:int = 5; 
    private var meter:Array = new Array();
    
    //コンストラクタ
    public function ProgressSprite(width:int,height:int):void{
        mapData = new BitmapData(width,height,true,0x00000000); 
        addChild(new Bitmap(mapData)).blendMode="invert";
        for(var i:int=0;i<maxLevel;i++){
            meter[i]=0;
        }
        addEventListener("enterFrame",onFrame);
    }
    
    //ロードが進行したときに呼び出される。 rateはロードの進行度で0-1
    public function progress(rate:Number):void{
        bfRate = rate;
    }
    
    private function draw(rate:Number, level:int=0):void{
        var thick:int = mapData.height*(0.61803)/1.61803;
        var floor:int = 0;
        for(var i:int=1;i<level+1;i++){
            thick*=(0.61803)/1.61803;
            floor+=thick;
        }
        mapData.fillRect( new Rectangle(0,mapData.height-floor,mapData.width*rate,thick), 0x1000000*int(0xFF*(maxLevel-level+1)/(maxLevel)));
    }
    
    private function onFrame(e:Event):void{
        for(var i:int=0;i<maxLevel;i++){
            var n:int = Math.pow(2,i+2);
            meter[i]=(bfRate+ meter[i]*(n-1))/n;
            draw(meter[i],i);
        }
    }  
}

import frocessing.color.ColorHSV;
class EffectMap extends Bitmap{
    public var color:ColorHSV = new ColorHSV();
    function EffectMap(w:int,h:int){
        super( new BitmapData(w,h,true,0) );
        addEventListener( "enterFrame", onFrame );
        color.h = 0;
        color.s = 0;
        color.v = 1;
        color.a = 0;
    }
    private function onFrame(e:Event):void{
        var b:BitmapData = bitmapData;
        b.fillRect( b.rect, color.value32 ); 
    }
}


//SiON
import org.si.sion.*;
import org.si.sound.*;
class MyDriver extends SiONDriver {
    public var dm:DrumMachine = new DrumMachine(0, 0, 0, 1, 1, 1);
    public var fill:SiONData;
    function MyDriver():void{
        super(); 
        volume = 2.0
        dm.volume = 0.05
        setVoice(0, new SiONVoice(5,2,63,63,-10,0,2,20));
        fill = compile("#A=c&ccrccrc&cccrc&c&c&c;#B=<c&c>bragrf&fedrc&c&c&c;#C=<c&c>bragra&ab<crc&c&c&c>;%1@8,l16B;#D=rrrrrrrrrrrrcerg;#E=<c>bagfedcfedrc&c&c&c;#F=cdefgab<c>fgar<c&c&c&c>;");
        setSamplerData(0, render("%2@4 v8 l24 c<<c"));
        setSamplerData(1, render("%2@4 l60 ccc"));
        setSamplerData(2, render("%3@8 l12 <<<<<a0b0c0b0e0d0g"));
        setSamplerData(3, render("%3@4 l60 <<<<<c>c"));
        setSamplerData(4, render("%2@60 v2 l48 c<c"));
        setSamplerData(5, render("%3@0q0,c"));
        setSamplerData(6, render("%2@4, l24q0 <<c<<c>>c<<c>>"));
        setSamplerData(7, render("%3@8, v15 l32q2 <<c&c>bragrf&fedrc&c&c&c"));
        play() ;
    }
}
class Sound{
    static public var driver:MyDriver = new MyDriver();
    static public function se(i:int,delay:int=0):void{
        driver.playSound(i,0,delay);
    }
    static public function music(i:int=1):void{
        switch(i) {
            case 1:
                driver.dm.play();
                driver.dm.fadeIn(6);
                break;
            case 2:
                driver.dm.fadeOut(3);
                se(7,12);
                break;
        }
    }
}






//配列の複製を返す
import flash.utils.getQualifiedClassName;
function clone(arg:*):*{
    var cl:*;
    var name:String = getQualifiedClassName(arg);
    if( name == "Object" || name == "Array" || name == "Vector" ){
        if( name == "Object" ){ cl = {}; }
        else if( name == "Array" ){ cl = []; }
        else if( name == "Vector" ){ cl = Vector([]); }
        for( var s:String in arg ){
            cl[s] = clone( arg[s] );
        }
        return cl;
    }else if( arg is Object && arg.hasOwnProperty("clone") && arg.clone is Function ){
        return arg.clone();
    }
    return arg;
}

