/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n22R
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;    
    /**
     * ...
     * @author Jacky Riawan
     */
    public class Main extends Sprite 
    {
        private var scale:Number = .55;
        private var bitmapData:BitmapData = new BitmapData(255 * 2*scale, 255 * 2.5*scale, false);
        public function Main():void 
        {                                    
            addLayer(0);
            var bitmap:Bitmap = new Bitmap(bitmapData);
            bitmap.x = (stage.stageWidth - bitmap.width) / 2;
            bitmap.y = (stage.stageHeight - bitmap.height) / 2;
            addChild(bitmap);
            var timer:Timer = new Timer(10, 255 * scale);
            timer.addEventListener(TimerEvent.TIMER, update);
            timer.start();
        }
        private function addLayer(_b:int):void {
            bitmapData.lock();
            for (var _r:int = 0; _r < 255*scale; _r++) {
                for (var _g:int = 0; _g < 255*scale; _g++) {
                    var plotX:int = _g-_r;
                    var plotY:int = _r + _g-_b/2;
                    var color:uint = (_r/scale) << 16 | (_g/scale) << 8 | (_b/scale);
                    bitmapData.setPixel(bitmapData.width / 2 + plotX, 128*scale+plotY, color);
                }
            }
            bitmapData.unlock();
        }
        private function update(e:TimerEvent):void 
        {
            var timer:Timer = Timer(e.target);
            addLayer(timer.currentCount);
        }
    }
}