/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n1xL
 */

// forked from codeonwort's grid making test
// forked from codeonwort's stage3D base
package {
    
    import flash.display.Sprite
    import flash.events.Event
    
    import flash.display3D.Context3D
    
    public class Stage3DBase extends Sprite {
        
        private var context:Context3D
        
        public function Stage3DBase() {
            // write as3 code here..
            stage ? init() : addEventListener("addedToStage", init)
        }
        
        private function init(e:Event = null):void {
            // never mind
            if(e) removeEventListener(e.type, arguments.callee)
            
            // request context 3d
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contextGained)
            stage.stage3Ds[0].requestContext3D("auto")
        }
        
        // when I request context3D by Stage3D::requestContext3D
        // or when device loss occurs this listener is called.
        // make this listener to handle both situations.
        private function contextGained(e:Event):void {
            context = e.target.context3D
            
            var study:StudyBase = new GridStudy
            study.init(this, context)
        }
        
    }
    
}

import flash.display.Stage
import flash.display.Sprite
import flash.display3D.Context3D
import flash.display3D.Program3D
import flash.display3D.IndexBuffer3D
import flash.display3D.VertexBuffer3D
import com.adobe.utils.AGALMiniAssembler
class StudyBase {
    
    protected var document:Sprite
    protected var stage:Stage
    protected var context:Context3D
    protected var asm:AGALMiniAssembler
    
    protected var hardwareAccelerated:Boolean
    
    protected var vertBuf:VertexBuffer3D
    protected var idxBuf:IndexBuffer3D
    protected var program:Program3D
    
    public function StudyBase() {
        asm = new AGALMiniAssembler
    }
    
    public function init(doc:Sprite, cont:Context3D):void {
        if(context) context.dispose()
        context = cont
        document = doc
        stage = document.stage
        
        hardwareAccelerated = context.driverInfo.toLowerCase().indexOf("software") == -1
        
        program = context.createProgram()
    }
    
    protected function makeVertBuf(verts:Vector.<Number>, data32PerVert:uint):void {
        vertBuf = context.createVertexBuffer(verts.length / data32PerVert, data32PerVert)
        vertBuf.uploadFromVector(verts, 0, verts.length / data32PerVert)
    }
    protected function makeIdxBuf(indices:Vector.<uint>):void {
        idxBuf = context.createIndexBuffer(indices.length)
        idxBuf.uploadFromVector(indices, 0, indices.length)
    }
    
}

import flash.display.BitmapData
import flash.geom.Vector3D
import flash.geom.Matrix3D;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.ByteArray
import com.adobe.utils.PerspectiveMatrix3D
class GridStudy extends StudyBase {
    
    private var indices:Vector.<uint> = new Vector.<uint>
    
    private var projection:PerspectiveMatrix3D = new PerspectiveMatrix3D(); // (extends Matrix3D, provides perspectiveFieldOfViewRH method)
    private var model:Matrix3D = new Matrix3D();
    private var view:Matrix3D = new Matrix3D();
    private var modelViewProjection:Matrix3D = new Matrix3D();
    
    public override function init(doc:Sprite, cont:Context3D):void {
        super.init(doc, cont)
        context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, false)
        context.setCulling("back")
        
        var verts:Vector.<Number> = new Vector.<Number>
        
        const num_cols:uint = 100, num_rows:uint = 100
        const left:Number = -1, top:Number = -1
        const width:Number = 2, height:Number = 2
        
        var mt:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false)
        mt.perlinNoise(mt.width/2, mt.height/2, 8, Math.random()*151323, true, true)
        
        var x:Number, y:Number, z:Number
        var rand_color:uint
        var r:Number, g:Number, b:Number
        var ia:uint, ib:uint, ic:uint, id:uint
        for(var i:int = 0 ; i <= num_cols ; i++){
            for(var j:int = 0 ; j <= num_rows ; j++){
                // vertex attributes
                rand_color = mt.getPixel(Math.min(mt.width-1, i * mt.width/num_cols), Math.min(mt.height-1, j * mt.height/num_rows))
                r = (rand_color & 0xff) / 255
                g = (rand_color >> 8 & 0xff) / 255
                b = (rand_color >> 16 & 0xff) / 255
                x = left + width * i/num_cols
                y = top + height * j/num_rows
                z = (r + g + b) / 3
                verts.push(x, y, z, r, g, b)
                
                // indices
                if( i != num_cols && j != num_rows){
                    ia = i * (num_rows + 1) + j
                    ib = ia + 1
                    ic = (i + 1) * (num_rows + 1) + j
                    id = ic + 1
                    indices.push(ia,ib,ic, ib,id,ic)
                }
            }
        }
        
        makeVertBuf(verts, 3 + 3)
        makeIdxBuf(indices)
        
        context.setVertexBufferAt(0, vertBuf, 0, "float3")
        context.setVertexBufferAt(1, vertBuf, 3, "float3")
        
        var vertShader:ByteArray = asm.assemble("vertex",
                                                "mov v0, va1\n" +
                                                "m44 op, va0, vc0");
        var fragShader:ByteArray = asm.assemble("fragment", "mov oc, v0")
        program.upload(vertShader, fragShader)
        context.setProgram(program)
        
        model.identity()
        model.appendScale(100, 100, 100)
        model.appendRotation(50, Vector3D.X_AXIS)
      
        view.identity();
        view.appendTranslation(0, 0, 100.0);

        projection.identity();
        // fov, width/height, z_near, z_far
        projection.perspectiveFieldOfViewLH(45.0, 465/465, 10.0, 1000.0);
        
        stage.addEventListener("mouseMove", render)
        render()
    }
    
    private var prevX:Number = 0, prevY:Number = 0
    private function render(e:MouseEvent=null):void {
        if(e){
            var degrees:Number = (prevX - e.stageX) / 2
            prevX = e.stageX
            model.prependRotation(degrees, Vector3D.Z_AXIS)
            
            degrees = (prevY - e.stageY) / 2
            prevY = e.stageY
            view.appendTranslation(0, 0, -degrees)
        }
        
        context.clear(0, 0, 0)
        
        modelViewProjection.copyFrom(model);
        modelViewProjection.append(view);
        modelViewProjection.append(projection);
        context.setProgramConstantsFromMatrix("vertex", 0, modelViewProjection, true)
        
        context.drawTriangles(idxBuf, 0, indices.length / 3)
        
        context.present()
    }
    
}
