/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n1s4
 */

package 
{
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.net.FileReference;
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.*;
    
    [SWF(width = 465, height = 465, frameRate = 30, backgroundColor = 0)]
    
    public class Main extends Sprite
    {

        private var _rtmfp:RTMFPConnect;
        private var _msgID:int;
        private var _msg:String = "";
        
        private var _fr:FileReference = new FileReference();
        private var _saveBmd:BitmapData;
        private var _bm:Bitmap;
        
        private var _saveBtn:PushButton;

        public function Main()
        {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x33393F)));
            var tx:TextField = new TextField();
            var tfmt:TextFormat = new TextFormat("_typewriter", 14, 0xFFFFFF, null, null, null, null, null, "center");
            tx.defaultTextFormat = tfmt;  tx.width = 465;  tx.text = "Please photograph it\nby the Camera Apps of the Android";
            tx.y = 210;
            addChild(tx);
            //
            setup();
        }
        
        private function setup():void
        {
            _rtmfp = RTMFPConnect.getInstance();
            _rtmfp.doConnect();
            //
            _rtmfp.addEventListener(RTMFPConnect.NC_CONNECTED, onNcConnect);
            _rtmfp.addEventListener(RTMFPConnect.GROUP_CONNECTED, onGroupConnect);
            _rtmfp.addEventListener(RTMFPConnect.GROUP_NEIGHBOR, onGroupNeighbor);
            _rtmfp.addEventListener(RTMFPConnect.GROUP_POSTED, onGroupPosted);
        }

        private function onNcConnect(e:Event):void
        {
            var scale:Number = 465 / 640;
            _saveBmd = new BitmapData(640, 480, false, 0);
            _bm = new Bitmap(_saveBmd, "auto", true);  _bm.scaleX = _bm.scaleY = scale;
            _bm.y = (465 - 480 * scale) * .5;  _bm.visible = false;
            addChild(_bm);
            //
            _saveBtn = new PushButton(this, 185, 435, "Save Image", onSave);
            _saveBtn.visible = false;
        }

        private function onGroupConnect(e:Event):void
        {
        }

        private function onGroupNeighbor(e:Event):void
        {
        }

        private function onGroupPosted(e:Event):void
        {
            _bm.visible = true;  _saveBtn.visible = true;
            var rect:Rectangle = new Rectangle(_rtmfp.x, _rtmfp.y, _rtmfp.w, _rtmfp.h);
            _saveBmd.copyPixels(new BitmapImage(rect, _rtmfp.vec), _saveBmd.rect, new Point());
        }


        private function onSave(e:MouseEvent):void
        {
            _bm.visible = false;
            _saveBtn.visible = false;
            fileSave(_saveBmd);
        }
        
        // ImageFile Save
        private function fileSave(bmd:BitmapData):void
        {
            var png:ByteArray = PNGEncoder.encode(bmd);
            _fr.addEventListener(Event.COMPLETE, complete);
            _fr.addEventListener(Event.CANCEL, cancel);
            _fr.addEventListener(IOErrorEvent.IO_ERROR, ioError);
            var date:Date = new Date  ;
            _fr.save(png, "image_" + date.getTime() + ".png");
            //
            function complete(e:Event):void
            {
                removedEventListener();
            }
            function cancel(e:Event):void
            {
                removedEventListener();
            }
            function ioError(e:IOErrorEvent):void
            {
                removedEventListener();
            }
            //
            function removedEventListener():void
            {
                _fr.removeEventListener(Event.COMPLETE, complete);
                _fr.removeEventListener(Event.CANCEL, cancel);
                _fr.removeEventListener(IOErrorEvent.IO_ERROR, ioError);
            }
        }
    }
}


//
import flash.geom.Rectangle;
import flash.display.BitmapData;

internal class BitmapImage extends BitmapData
{
    public function BitmapImage(rect:Rectangle, vec:Vector.<uint>)
    {
        super(rect.width, rect.height, true, 0);
        super.setVector(rect, vec);
    }
}


//
//package  {
    
    import flash.events.EventDispatcher;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.NetGroup;
    import flash.net.GroupSpecifier;
    import flash.events.NetStatusEvent;
    import flash.events.Event;
    import flash.geom.Rectangle;
    
    internal class RTMFPConnect extends EventDispatcher {
        
        // EventConst
        public static const NC_CONNECTED:String = "nc_connected";
        public static const NC_CONNECT_FAILED:String = "nc_connect_failed";
        
        public static const GROUP_CONNECTED:String = "group_connected";
        public static const GROUP_NEIGHBOR:String = "group_Neighbor";
        public static const GROUP_DISCONNECT:String = "group_disconnect";
        public static const GROUP_POSTED:String = "group_posted";
        
        public static const NS_CONNECTED:String = "ns_connected";
        public static const NS_START_PUBLISH:String = "ns_start_publish";
        
        // GroupName
        private const GROUP_NAME:String = "toppig_catch"
    
        //
        private var _nc:NetConnection;
        private var _rns:NetStream;
            
        private var _ng:NetGroup;
        private var _gs:GroupSpecifier;
        
        public var msg:String;
        
        public var w:Number;
        public var h:Number;
        public var x:Number;
        public var y:Number;
        public var vec:Vector.<uint>;
        
        private static var _instance:RTMFPConnect;
        
        //
        public function RTMFPConnect(enforcer:SingletonEnforcer) { }
        
        public static function getInstance():RTMFPConnect {
            if(RTMFPConnect._instance ==  null){
                RTMFPConnect._instance = new RTMFPConnect(new SingletonEnforcer());
            }
            return RTMFPConnect._instance;
        }
        
        public function doConnect():void {
            _nc = new NetConnection();
            _nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
            _nc.connect("rtmfp:");
        }
        
        private function netStatusHandler(e:NetStatusEvent):void {
            trace(e.target, e.info.code)
            switch(e.info.code){
                case "NetConnection.Connect.Success":
                    dispatchEvent(new Event(NC_CONNECTED));
                    addNetGroup();
                    break;
                case "NetConnection.Connect.Failed":
                    dispatchEvent(new Event(NC_CONNECT_FAILED));
                    break;
                case "NetConnection.Connect.Rejected":
                    //
                    break;
                case "NetGroup.Connect.Success":
                    dispatchEvent(new Event(GROUP_CONNECTED));
                    recavedMsg();
                    break;
                case "NetGroup.Connect.Failed":
                    //
                    break;
                case "NetGroup.Connect.Rejected":
                    //
                    break;
                case "NetGroup.Neighbor.Connect":
                    dispatchEvent(new Event(GROUP_NEIGHBOR));
                    break;
                case "NetGroup.Neighbor.Disconnect":
                    dispatchEvent(new Event(GROUP_DISCONNECT));
                    break;
                case "NetGroup.Posting.Notify":
                    //msg = e.info.message.text;
                    w = e.info.message.width;
                    h = e.info.message.height;
                    x = e.info.message.x;
                    y = e.info.message.y;
                    vec = e.info.message.img;
                    dispatchEvent(new Event(GROUP_POSTED));
                    break;
                case "NetStream.Connect.Success":
                    dispatchEvent(new Event(NS_CONNECTED));
                    break;
                case "NetStream.Publish.Start":
                    dispatchEvent(new Event(NS_START_PUBLISH));
                    break;
                }
            }
        
        //NetGroup
        public function addNetGroup():void{
            _gs = new GroupSpecifier(GROUP_NAME);
            _gs.postingEnabled = true;
            _gs.ipMulticastMemberUpdatesEnabled = true;
            _gs.multicastEnabled = true;
            _gs.addIPMulticastAddress("225.225.0.1:30303");
                
            // NetGroup
            _ng = new NetGroup(_nc, _gs.groupspecWithAuthorizations());
            _ng.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }
        
        //SendMsg
        public function sendMsg(str:String = ""):void{
            var message:Object = new Object();
            message.text = str;
            message.sender = _ng.convertPeerIDToGroupAddress(_nc.nearID); 
            _ng.post(message);
        }
        
        //SendImage
        public function sendImage(rec:Rectangle, v:Vector.<uint>):void{
            var message:Object = new Object();
            message.img = v;
            message.width = rec.width;
            message.height = rec.height;
            message.x = rec.x;
            message.y = rec.y;
            message.sender = _ng.convertPeerIDToGroupAddress(_nc.nearID); 
            _ng.post(message);
        }
            
        //recavedMsg
        public function recavedMsg():void{
            _rns = new NetStream(_nc, _gs.groupspecWithAuthorizations());
            _rns.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }
    }   
//}


internal class SingletonEnforcer {}