/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/n0ND
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;

    [SWF(width = "465",height = "465",frameRate = "60",backgroundColor = "0")]

    public class Main extends Sprite
    {
        private var _canvas:BitmapData;  private var _bm:Bitmap;
        private var _ctf:ColorTransform = new ColorTransform(.94, .93, .9);
        public function Main()
        {
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
            _bm = new Bitmap(_canvas);  addChild(_bm);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            var line:Shape = new Shape();  var g:Graphics = line.graphics;  var pitch:int = 120;  var len:int = stage.width / 2 * Math.sqrt(4);  var r:int = 360;
            g.beginFill(0xFFFFFF);  g.moveTo(-0.5, 0);  g.lineTo(0.5, 0);  g.lineTo(0, -0.5);  g.lineTo(-0.5, 0);
            _canvas.lock();  _canvas.colorTransform(_canvas.rect, _ctf);
            while (0 < r)
            {
                var x:Number = Math.sin(r * Math.PI / 180) * len + stage.stageWidth / 2;  var y:Number = Math.cos(r * Math.PI / 180) * len + stage.stageHeight / 2;
                var mtx:Matrix = new Matrix();  mtx.scale(6, Math.random() * len + len / 2);  mtx.rotate((-r) * Math.PI / 180);  mtx.translate(x, y);
                _canvas.draw(line, mtx);
                r -=  Math.round(Math.random() * pitch);
            }
            _canvas.unlock();
        }
    }
}