/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mzd5
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    public class FlashTest extends Sprite {
        
        public const LOOP:int = 100000;
        
        public const txt:TextField = new TextField();
        
        public var tests:Vector.<Tester> = new Vector.<Tester>();
        
        public function FlashTest() {
            
            
            tests[tests.length] = new Tester("Math.sqrt(2) : ", function():Number
            {
                var i:int = LOOP;
				var result:Number;
                while (i--)
                {
                    result = Math.sqrt(2);
                }
				return result;
            });
            
            tests[tests.length] = new Tester("sqrt(2) : ", function():Number
            {
                var i:int = LOOP;
				var result:Number;
                while (i--)
                {
                    result = sqrt(2);
                }
				return result;
            });
            
            tests[tests.length] = new Tester("sqrt(2, 3) : ", function():Number
            {
                var i:int = LOOP;
				var result:Number;
                while (i--)
                {
                    result = sqrt(2, 3);
                }
				return result;
            });
            
            tests.reverse();
            txt.width = 500;
            txt.height = 500;
            addChild(txt);
            
            // write as3 code here..
            addEventListener(Event.ENTER_FRAME, test);
        }
		
		[Inline]
		final private function sqrt(value:Number,quality:int=-1):Number
		{
			var t:Number;
			var s:Number = value;
			
			if (value == 0) return 0;
			do
			{
				t = s;
				s = (t + value / t) * 0.5;
				quality--;
			}
			while (s < t && quality);
			return t;
		}
        
        private function test(e:Event):void 
        {
            var str:String = "";
            var i:int = tests.length;
            while (i--)
            {
                str += tests[i].start();
            }
            txt.text = str;
        }
    }
}

import flash.utils.getTimer;
class Tester
{
    public var time:Number = 0;
    
    public var name:String;
    
    public var test:Function;
    
    public var count:int = 1;
    
    public function start():String
    {
        const startTime:int = getTimer();
        var result:String = test().toString();
        time += getTimer() - startTime;
        return name + "result = "+ result + "; " + (time / (count++)) + " ms. \n";
    }
    
    public function Tester(name:String, test:Function)
    {
        this.name = name;
        this.test = test;
    }
}