/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mzSF
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
        public var tri1a:Vec3 = new Vec3();
        public var tri1b:Vec3 = new Vec3();
        public var tri1c:Vec3 = new Vec3();
           
        public var tri2a:Vec3 = new Vec3();
        public var tri2b:Vec3 = new Vec3();
        public var tri2c:Vec3 = new Vec3();
           
           
           public var deb:TextField;
       
       
        public function FlashTest() 
        {
            deb = new TextField();
            addChild(deb);
            deb.width = 300;
            deb.height = 100;
            deb.multiline = true;
            
            tri1a.x = 20;
            tri1a.y = 80;
            tri1b.x = 160;
            tri1b.y = 160;
            tri1c.x = 10;
            tri1c.y = 160;
            /*
            tri2a.x = 20;
            tri2a.y = 80;
            tri2b.x = 160;
            tri2b.y = 160;
            tri2c.x = 10;
            tri2c.y = 160;
            */
            
           tri2a.x = 120;
            tri2a.y = 200;
            tri2b.x = 280;
            tri2b.y = 280;
            tri2c.x = 60;
            tri2c.y = 340;
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        //public var w:Vec3 = new Vec3();
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            
            graphics.moveTo(tri1a.x, tri1a.y);
            graphics.lineTo(tri1b.x, tri1b.y);
            graphics.lineTo(tri1c.x, tri1c.y);
            graphics.lineTo(tri1a.x, tri1a.y);
            
            graphics.moveTo(tri2a.x, tri2a.y);
            graphics.lineTo(tri2b.x, tri2b.y);
            graphics.lineTo(tri2c.x, tri2c.y);
            graphics.lineTo(tri2a.x, tri2a.y);
            
            graphics.drawCircle(mouseX, mouseY, 4);
            
            deb.text = "";
            
            deb.appendText("mouse: x "+mouseX +" y " + mouseY+"\n");
            
            var w:Vec3;
            w = getBary2(mouseX, mouseY, 0,
            tri1a.x, tri1a.y, 0,
            tri1b.x, tri1b.y, 0,
            tri1c.x, tri1c.y, 0);
            deb.appendText("bary: x "+w.x+" y " + w.y+"\n");
            
            w = getFromBary(w.x, w.y,
            tri2a.x, tri2a.y, 0,
            tri2b.x, tri2b.y, 0,
            tri2c.x, tri2c.y, 0);
            
            
            deb.appendText("frombary: x "+w.x+" y " + w.y+"\n");
            
            graphics.drawCircle(w.x, w.y, 8);
            
        }//onenter
        
        
      
        public var ret:Vec3 = new Vec3();
        
        //based on
        //http://web.archive.org/web/20090609111431/http://www.crackthecode.us/barycentric/barycentric_coordinates.html
        
        public function getBary2(
        px:Number, py:Number, pz:Number,
        x1:Number, y1:Number, z1:Number,
        x2:Number, y2:Number, z2:Number,
        x3:Number, y3:Number, z3:Number):Vec3
        {
            var x4:Number;
            var y4:Number;
            var z4:Number;
            
            x4 = px;
            y4 = py;
            z4 = pz;
            
            var deta:Number;
            var deta1b:Number;
            var deta2b:Number;
            
            deta = (x1 * y2) - (x1 * y3) - (x2 * y1) + (x2 * y3) + (x3 * y1) - (x3 * y2);
            deta1b = (x4 * y2) - (x4 * y3) - (x2 * y4) + (x2 * y3) + (x3 * y4) - (x3 * y2);
            deta2b =  (x1 * y4) - (x1 * y3) - (x4 * y1) + (x4 * y3) + (x3 * y1) - (x3 * y4);
         
         var u:Number;
         var v:Number;
         var w:Number;
         
         u = deta1b/deta;
         v = deta2b/deta;
         w = 1 - (u+v);
         
         ret.x = u;
         ret.y = v;
         ret.z = w;
         
         
         return ret;   
        }//getbary2
    
      //based on
        ////http://www.blackpawn.com/texts/pointinpoly/default.html
        
        
        public function getBary(
        px:Number, py:Number, pz:Number,
        x1:Number, y1:Number, z1:Number,
        x2:Number, y2:Number, z2:Number,
        x3:Number, y3:Number, z3:Number):Vec3
        {
          var u:Number;
          var v:Number;
          var vx1:Number;
          var vy1:Number;
          var vz1:Number;
          var vx2:Number;
          var vy2:Number;
          var vz2:Number;
          var vx0:Number;
          var vy0:Number;
          var vz0:Number;
          var dot00:Number;
          var dot01:Number;
          var dot02:Number;
          var dot11:Number;
          var dot12:Number;
          var invDenom:Number;
          
          vx0 = x3 - x1;
          vy0 = y3 - y1;
          vz0 = z3 - z1;
          
  
          vx1 = x2 - x1;
          vy1 = y2 - y1;
          vz1 = z2 - z1;
          
          vx2 = px - x1;
          vy2 = py - y1;
          vz2 = pz - z1;
         
          
          dot00 = vx0*vx0 + vy0*vy0 + vz0*vz0;
          dot01 = vx0*vx1 + vy0*vy1 + vz0*vz1;
          dot02 = vx0*vx2 + vy0*vy2 + vz0*vz2;
          dot11 = vx1*vx1 + vy1*vy1 + vz1*vz1;
          dot12 = vx1*vx2 + vy1*vy2 + vz1*vz2; 
         
          invDenom = 1.0 / (dot00*dot11 - dot01*dot01);   
          u = (dot11 * dot02 - dot01 * dot12) * invDenom;
          v = (dot00 * dot12 - dot01 * dot02) * invDenom; 
            
            ret.x = u;
            ret.y = v;
            ret.z = 1 - ( u + v );
            
           return ret;
        }//getbary
        
         public function getFromBary(
        u:Number, v:Number,
        x1:Number, y1:Number, z1:Number,
        x2:Number, y2:Number, z2:Number,
        x3:Number, y3:Number, z3:Number):Vec3
        {
          //u = ( 1 - u); 
            
          var w:Number;
          w = 1 - (u+v);
            
          ret.x = (u*x1 + v*x2 + w*x3);  
          ret.y = (u*y1 + v*y2 + w*y3);  
          ret.z = (u*z1 + v*z2 + w*z3);  
            
            
            return ret;
        }//frombary
        
        
    }//classend
}

internal class Vec3
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
 };//v3