/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mxrP
 */

/**
***************************************************************
 * 風に揺れる葉.
 * @author itoz　(http://www.romatica.com/).
 * shadeで作成
 **************************************************************
 */
package 
{
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;

    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;

    [SWF(backgroundColor="#FFFFFF", frameRate="40", width="486", height="486")]
    public class Leaf extends BasicView 
    {
        //*********************************************************************
        private const _domain:String       = "http://www.romatica.com/dev/wonderfl/ARetty/";
        private const _daeURL:String         = _domain + "leaf.dae";
        //*********************************************************************
        private const _cameraZ:Number = -100;
        private const _cameraY:Number = 0;
        private const _modelScale:Number = 0.75;
        //*********************************************************************
        private var mouseDownX:Number;
        private var mouseDownY:Number;
        private var isDragging:Boolean = false;
        //*********************************************************************
        private var _leafArr:Array;
        private var _DAEArr:Array;
        private var _wrap:DisplayObject3D;
        private var leaf1:DAE = new DAE( );
        private var leaf2:DAE = new DAE( );
        private var leaf3:DAE = new DAE( );
        //*********************************************************************
        private var windSpeed:Number = 10;
        //*********************************************************************
        private var bg:Sprite;

        public function Leaf() 
        {
            camera.z = -_cameraZ;
            camera.y = _cameraY;
            stage.addEventListener( MouseEvent.MOUSE_DOWN , onMouseDownHandler );
            stage.addEventListener( MouseEvent.MOUSE_MOVE , onMouseMoveHandler );
            stage.addEventListener( MouseEvent.MOUSE_UP , onMouseUpHandler );
            setBG();
            daeLoadStart( );
        }

        private function setBG():void 
        {
            var gradType:String = GradientType.LINEAR;
            var gradColors:Array = [ 0xa4d7fc , 0xfeffec ];
            var gradAlphas:Array = [ 1, 1 ];
            var gradRadios:Array = [ 0, 255 ];
            var gradMrx:Matrix = new Matrix( );
            gradMrx.createGradientBox( 468,  468 , Math.PI/2, 0,0);
            var gradSpread:String = SpreadMethod.PAD;
            bg=addChild(new Sprite()) as Sprite;
            bg.graphics.beginGradientFill( gradType , gradColors ,  gradAlphas , gradRadios , gradMrx ,gradSpread);
            bg.graphics.drawRect( 0 , 0, 468, 468);
            this.setChildIndex(bg, 0);
        }

        private function daeLoadStart():void 
        {
            _wrap = scene.addChild( new DisplayObject3D( ) ) as DisplayObject3D;    
            _wrap.scale = _modelScale;
            leaf1.addEventListener( FileLoadEvent.LOAD_COMPLETE , daeLoadComplete );
            leaf1.load( _daeURL );
        }

        private function daeLoadComplete(event:FileLoadEvent):void 
        {
            leaf2 = leaf1.clone( ) as DAE;
            leaf3 = leaf1.clone( ) as DAE;
            _wrap.addChild( leaf1 );
            _wrap.addChild( leaf2 );
            _wrap.addChild( leaf3 );
            //
            _DAEArr = [ leaf1,leaf2,leaf3 ];
            _leafArr = new Array( );
            for (var i:int = 0; i < 3; i++) {
                _leafArr.push( {"DAE":_DAEArr[i] , "startWindAng":i * 30} );
            }
            //-------------------
            leaf1.rotationX = 25;
            leaf1.rotationZ = -25;
            //-------------------
            leaf2.x = 20;
            leaf2.y = 20;
            leaf2.z = -30;
            leaf2.rotationX = 20;
            leaf2.rotationY = 35;
            leaf2.scaleX=-1;
            //-------------------
            leaf3.x = -10;
            leaf3.y = 45;
            leaf3.z = -10;
            leaf3.rotationX = 30;
            leaf3.rotationY = -20;
            //-------------------
            super.startRendering( );
        }

        override protected function onRenderTick(event:Event = null):void 
        {
            super.onRenderTick( );
            camera.y = (mouseY / stage.stageHeight) * 100;
            doWind( );//風
        }

        private function doWind():void 
        {
            for (var i:int = 0; i < _leafArr.length; i++) {
                var trgLeaf:DAE = _leafArr[i]["DAE"];
                var wind:Number = _leafArr[i]["startWindAng"];
                wind = (wind >= 360) ? wind - 360 : wind;
                var windRad:Number = wind * (Math.PI / 180);
                var windX:Number = Math.cos( windRad ) ;
                trgLeaf.rotationX += windX;
                _leafArr[i]["startWindAng"] += windSpeed;
            }
        }

        private function onMouseMoveHandler(e:MouseEvent):void 
        {
            var xx:Number = (mouseX - mouseDownX) / 3;
            if (isDragging) {
                _wrap.rotationY -= xx;
                if(_wrap.rotationY>90)_wrap.rotationY=90;
                if(_wrap.rotationY<-90)_wrap.rotationY=-90;
                mouseDownX = mouseX;
                mouseDownY = mouseY;
            }
        }

        private function onMouseDownHandler(e:MouseEvent):void 
        {
            isDragging = true;
            mouseDownX = mouseX;
            mouseDownY = mouseY;
        }

        private function onMouseUpHandler(e:MouseEvent):void 
        {
            isDragging = false;
        }
    }
}

