/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mwVD
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            this.graphics.beginFill(0xfff0f0);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            this.addEventListener(Event.ENTER_FRAME, proc);            
        }
        
        private function proc(e:Event):void {
            var r:uint = 255;
            var g:uint = 80 + (Math.random() * 50);
            var b:uint = 80;
            var color:uint = (r << 0) + (g << 2) + (b << 8);
            
            var size:Number = 10 + (Math.random() * 10);
            var flower:Flower = new Flower(color, size);
            flower.x = Math.random() * 465;
            flower.y = -50;
            this.addChild(flower);
        }
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;

class Flower extends Sprite
{
    private var _speed:Number;
    private var _size:Number;
    
    public function Flower(color:uint, size:Number) {
        _speed = 2 + (Math.random() * 2);
        _size = size;
        var min:Number = 0.4;
        var mid:Number = 0.85;
        var max:Number = 1.0;
        
        var g:Graphics = this.graphics;
        g.beginFill(color);
        g.moveTo(Math.cos(Math.PI * -0.5) * size, Math.sin(Math.PI * -0.5) * size);
        for(var index:uint = 0; index < 5; ++index) {
            var rad:Number = (Math.PI * -0.5) + (Math.PI * 2 * index / 5);
            var rad2:Number = rad + (Math.PI * 2 / 5 * 0.3);
            var rad3:Number = rad + (Math.PI * 2 / 5 * 0.5);
            var rad4:Number = rad + (Math.PI * 2 / 5 * 0.7);
            var rad5:Number = rad + (Math.PI * 2 / 5 * 1);
            g.lineTo(Math.cos(rad2) * size * mid, Math.sin(rad2) * size * mid);
            g.lineTo(Math.cos(rad3) * size * min, Math.sin(rad3) * size * min);
            g.lineTo(Math.cos(rad4) * size * mid, Math.sin(rad4) * size * mid);
            g.lineTo(Math.cos(rad5) * size * max, Math.sin(rad5) * size * max);
        }
        g.endFill();
        
        this.addEventListener(Event.ENTER_FRAME, proc);
    }
    
    private function proc(e:Event):void {
        this.y += _speed;
        this.rotationZ += _speed * 0.7;
        
        if(this.y > 465 + _size) {
            this.removeEventListener(Event.ENTER_FRAME, proc);
            parent.removeChild(this);
        }
    }
}



