/**
 * Copyright Dan_Po ( http://wonderfl.net/user/Dan_Po )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mwHd
 */

package
{
    import flash.text.TextFieldAutoSize;
    import flash.utils.getTimer;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.utils.getQualifiedClassName;
    import flash.text.TextField;
    /**
     * ...
     * @author DanPo
     */
    public class ColorScreen extends Sprite 
    {
        
        private var color:Number = 0;
        private var bitmap:Bitmap = new Bitmap();
        private var tf:TextField = new TextField();
        private var bpm:Number = 100;
        private var time:int;
        private var tfTime:int = 0;
        
        public function ColorScreen()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            addChild(bitmap);
            tf.background = true;
            tf.autoSize = TextFieldAutoSize.LEFT;
            updateText();
            addChild(tf);
            resize();
            stage.addEventListener(Event.RESIZE, onResize);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.frameRate = 120;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            time = getTimer();
        }
        
        private function updateText():void
        {
            tf.text = "BPM: " + bpm;
            tf.visible = true;
            tfTime = getTimer() + 5000;
        }

        
        private function onKeyDown(e:KeyboardEvent):void 
        {
            if (e.keyCode == 38)
            {
                stage.frameRate++;
            }
            else if(e.keyCode == 40)
            {
                stage.frameRate--;
            }
            else if(e.keyCode == 37)
            {
                bpm--;
            }
            else if(e.keyCode == 39)
            {
                bpm++;
            }
            updateText();
        }
        
        private function onResize(e:Event):void 
        {
            resize();
        }
        
        private function resize():void 
        {
            bitmap.bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false);
        }
        
        private function onClick(e:MouseEvent):void 
        {
            stage.displayState = StageDisplayState.FULL_SCREEN;
        }
        
        private function onEnterFrame(e:Event):void 
        {
            var currentTime:int = getTimer();
            if(time < currentTime)
            {
                color = 0xFFFFFF;
                flash();
                time = currentTime + 60/bpm*1000;
            }
            else if(color == 0xFFFFFF)
            {
                color = 0;
                flash();
            }
            
            if(tfTime < currentTime)
            {
                tf.visible = false;
            }

        }
        
        private function flash():void
        {
            bitmap.bitmapData.lock();
            bitmap.bitmapData.fillRect(bitmap.bitmapData.rect, color);
            bitmap.bitmapData.unlock();
        }

        
        private function getHUE(value:Number):Number
        {
            value = value % 360;
            var n:int = value / 60;
            var k:Number = (value - 60*n)/60;
            var red:int=0;
            var green:int=0;
            var blue:int=0;
            if (n == 0)
            {
                red = 0xFF;
                green = k * 0xFF;
            }
            else if (n == 1)
            {
                green = 0xFF;
                red = (1 - k) * 0xFF;
            }
            else if (n == 2)
            {
                green = 0xFF;
                blue = k * 0xFF;
            }
            else if (n == 3)
            {
                blue = 0xFF;
                green = (1 - k) * 0xFF;
            }
            else if (n == 4)
            {
                blue = 0xFF;
                red = k * 0xff;
            }
            else if (n == 5)
            {
                red = 0xFF;
                blue = (1 - k) * 0xFF;
            }
            else if (value < 0 || value>=360)
            {
                return 0xFF0000;
            }
            return red * 0x10000 + green * 0x100 + blue;
        }
        
    }
    
}