/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mvoB
 */

package 
{
    import com.bit101.components.TextArea;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.utils.describeType;
    /**
    /*Sopas
    */
    public class QuickBox2DTesterRevoluteJoints extends MovieClip 
    {
        private var quickBox:SCQuickBox2D;
        
        private var size:Number=3;
        private var textArea:TextArea;
        private var proportion:Number= 0.62;
        private var abstractSimulation:AbstractSimulation;
        
        public function QuickBox2DTesterRevoluteJoints():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            trace( "QuickBox2DTester.init > e : " + e );
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            abstractSimulation = new AbstractSimulation();
            addChild(abstractSimulation);
            quickBox = abstractSimulation.quickBox;
            abstractSimulation.loopHook = onLoop;
            textArea = new TextArea(this, 30, 40);
            textArea.visible = false;
            
            
            limitedRevoluteJoint(3,  3, 1.1 );
            limitedRevoluteJoint(3, 10,  0  );
            
            //new com.bit101.components.PushButton(this, 10, 10, "step it", onLoop);
        }
        
        private function limitedRevoluteJoint(cx:Number,cy:Number, angleArg:Number = 0, referenceAngleArg:Number=0):void 
        {
            var symetricalLimit:Number = Math.PI * 0.25;
            var structure:Structure = new Structure(quickBox);
            textArea.setSize(textArea.width, stage.stageHeight - textArea.y);
            textArea.text += "body----a"; 
            textArea.text += traceObject(structure.a,'structure.a');
            textArea.text += "\nbody----b"; 
            textArea.text += traceObject(structure.a,'structure.b');
            textArea.text += "\njoint---"; 
            textArea.text += traceObject(structure.joint, 'structure.joint');
            
            //body----
            var a1:SCBoxObject = structure.a;
            //structure.a.fixedRotation = true;
            a1.width = size;
            a1.height = size*proportion; 
            a1.x = cx
            a1.y = cy
            a1.density = 0;
            a1.angle = angleArg;
            a1.fillAlpha = 0.6
            
            //body----
            //structure.b.fixedRotation = true;
            structure.b.width = size;
            structure.b.height = size*proportion; 
            structure.b.x = a1.x + Math.cos(angleArg)*a1.width;
            structure.b.y = a1.y + Math.sin(angleArg) * a1.width;
            structure.b.angle = angleArg;
            structure.b.fillColor = 0x66ff;
            structure.b.fillAlpha = 0.6;
            
            //joint---
            structure.joint.x1 = a1.x + Math.cos(angleArg) * a1.width * 0.5;
            structure.joint.y1 = a1.y + Math.sin(angleArg) * a1.width * 0.5;
            structure.joint.upperAngle = symetricalLimit;
            structure.joint.referenceAngle = referenceAngleArg; 
            structure.joint.enableLimit = true;
            structure.joint.lowerAngle = -symetricalLimit;
            
            structure.init();
            textArea.text += traceObject(structure.qj, 'qj');
        }
        
        
        private function onLoop(e:Event=null):void 
        {
            textArea.text = Math.random().toFixed(4);
            quickBox.w.Step(quickBox.timeStep, quickBox.iterations);
            quickBox.updateBodies();
        }
        
        private function traceObject(objArg:Object,nameArg:String=""):String 
        {
            //trace( "objArg : " + objArg );
            var def : XML = describeType(objArg);
            //trace( "def : " + def );
            var output:String = "";
            var properties : XMLList = def..variable.@name + def..accessor.@name;
            var number:Number = 0;
            trace("accesors and variables:");
            var p:String;
            for each ( var property : String in properties ) 
            {
                number++;
                //p = property + ": " + objArg[property];
                p = nameArg+"."+property + " = "+ objArg[property];
                trace(number + "." + p);
                output += "\n" + p;
            }
            
            return output;
        }
    }
    
}
    
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickContacts;
    import com.actionsnippet.qbox.QuickObject;
    import com.bit101.components.Component;
    import com.bit101.components.HBox;
    import com.bit101.components.PushButton;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.describeType;
    
    class AbstractSimulation extends MovieClip 
    {
        public var loopHook:Function;
        public var quickBox:SCQuickBox2D;
        
        protected var count:uint;
        protected var quickBox2D:QuickBox2D;
        protected var cy:Number = 5;
        protected var cx:Number = 5;
        protected var controlPanel:HBox;
        
        public function AbstractSimulation():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        public function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var params:SCQuickBox2DObject = new SCQuickBox2DObject();
            //params.debug = true;
            quickBox = new SCQuickBox2D(this,params.generateObject());
            quickBox2D = quickBox.quickBox2D;
            quickBox.mouseDrag();
            quickBox.gravity = new b2Vec2(0,0);
            quickBox.start();
            quickBox.createStageWalls();
            quickBox.grid(30,0xaaaaaa);
            
            controlPanel = new HBox(this, 0, 0);
            var resetButton:Component = PushButton(addComponent(new PushButton(null, 0, 0, 'stop',resetButtonHandle)));
            var playButton:PushButton = PushButton(addComponent(new PushButton(null, 0, 0, 'play', playButtonHandle)));
            //addEventListener(Event.ENTER_FRAME, loop);
            controlPanel.visible = false;
            
            
        }
        private function playButtonHandle(e:Event):void 
        {
            quickBox.start();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function resetButtonHandle(e:Event):void 
        {
            quickBox.stop();
            removeEventListener(Event.ENTER_FRAME, loop);
        }
        protected function loop(e:Event):void 
        {
            count++;
            loopHook();
        }
        protected function addComponent(oComponenetArg:Component):Component 
        {
            var input:Component = oComponenetArg;
            controlPanel.addChildAt(oComponenetArg,controlPanel.numChildren);
            return input;
        }
    }
    class SCQuickBox2D 
    {
        
        private var _quickBox2D:QuickBox2D;
        
        public function SCQuickBox2D(mainArg:MovieClip,paramsArg:Object=null) 
        {
            _quickBox2D = new QuickBox2D(mainArg,paramsArg);
        }
        
        public function addChild(input:AbstractGenerator):QuickObject
        {
            var output:QuickObject;
            if (input is SCCircleObject) 
            {
                output= _quickBox2D.addCircle(input.generateObject());
            }
            else if (input is AbstractJointObject) 
            {
                output = _quickBox2D.addJoint(input.generateObject());
            }
            else if (input is SCBoxObject) 
            {
                output = _quickBox2D.addBox(input.generateObject());
            }
            return output;
        }
        
        /* DELEGATE com.actionsnippet.qbox.QuickBox2D */
        
        public function addBox(params:Object):QuickObject 
        {
            return _quickBox2D.addBox(params);
        }
        
        public function addCircle(params:Object):QuickObject 
        {
            return _quickBox2D.addCircle(params);
        }
        
        public function addContactListener():QuickContacts 
        {
            return _quickBox2D.addContactListener();
        }
        
        public function addGroup(params:Object):QuickObject 
        {
            return _quickBox2D.addGroup(params);
        }
        
        public function addJoint(params:Object):QuickObject 
        {
            return _quickBox2D.addJoint(params);
        }
        
        public function addPoly(params:Object):QuickObject 
        {
            return _quickBox2D.addPoly(params);
        }
        
        public function addTimeStepSequence(...sequence:Array):void 
        {
            _quickBox2D.addTimeStepSequence.apply(null, [].concat(sequence));
        }
        
        public function create(type:String, params:Object):QuickObject 
        {
            return _quickBox2D.create(type, params);
        }
        
        public function createMouse(evt:MouseEvent):void 
        {
            _quickBox2D.createMouse(evt);
        }
        
        public function createStageWalls(params:Object = null):void 
        {
            _quickBox2D.createStageWalls(params);
        }
        
        public function destroy():void 
        {
            _quickBox2D.destroy();
        }
        
        public function grid(size:int = 30, lineColor:uint = 0xFFFF00, lineAlpha:Number = 1):void 
        {
            _quickBox2D.grid(size, lineColor, lineAlpha);
        }
        
        public function mouseDrag():void 
        {
            _quickBox2D.mouseDrag();
        }
        
        public function setDefault(params:Object = null):void 
        {
            _quickBox2D.setDefault(params);
        }
        
        public function setMouse(xp:Number, yp:Number):void 
        {
            _quickBox2D.setMouse(xp, yp);
        }
        
        public function start():void 
        {
            _quickBox2D.start();
        }
        
        public function stop():void 
        {
            _quickBox2D.stop();
        }
        
        public function traceMouse():void 
        {
            _quickBox2D.traceMouse();
        }
        
        public function updateBodies():void 
        {
            _quickBox2D.updateBodies();
        }
        
        public function updateMouse():void 
        {
            _quickBox2D.updateMouse();
        }
        
        public function get quickBox2D():QuickBox2D 
        {
            return _quickBox2D;
        }
        
        public function set quickBox2D(value:QuickBox2D):void 
        {
            _quickBox2D = value;
        }
        
        public function get gravity():b2Vec2 
        {
            return _quickBox2D.gravity;
        }
        
        public function set gravity(value:b2Vec2):void 
        {
            _quickBox2D.gravity = value;
        }
        
        public function get frim():Boolean 
        {
            return _quickBox2D.frim;
        }
        
        public function set frim(value:Boolean):void 
        {
            _quickBox2D.frim = value;
        }
        
        public function get iterations():int 
        {
            return _quickBox2D.iterations;
        }
        
        public function set iterations(value:int):void 
        {
            _quickBox2D.iterations= value;
        }
        
        public function get main():MovieClip 
        {
            return _quickBox2D.main;
        }
        
        public function get timeStep():Number 
        {
            return _quickBox2D.timeStep;
        }
        
        public function set timeStep(value:Number):void 
        {
            _quickBox2D.timeStep = value;
        }
        
        public function get totalTimeSteps():int 
        {
            return _quickBox2D.totalTimeSteps;
        }
        
        public function set totalTimeSteps(value:int):void 
        {
            _quickBox2D.totalTimeSteps = value;
        }
        
        public function get w():b2World 
        {
            return _quickBox2D.w;
        }
        
        public function set w(value:b2World):void 
        {
            _quickBox2D.w = value;
        }
        
        public function get worldAABB():b2AABB 
        {
            return _quickBox2D.worldAABB;
        }
        
        public function set worldAABB(value:b2AABB):void 
        {
            _quickBox2D.worldAABB = value;
        }
        
        
    }
    class AbstractGenerator 
    {
        
        public function AbstractGenerator() 
        {
            
        }
        public function generateObject():Object 
        {
            var output:Object = {};
            var def : XML = describeType(this);
 
            var properties : XMLList = def..variable.@name + def..accessor.@name;
            var number:Number = 0;
            for each ( var property : String in properties ) 
            {
                number++;
                output[property] = this[property];
            }
            return output;
        }
        
    }
    class AbstractQuickObject extends AbstractGenerator
    {
        private var _x:Number;
        private var _y:Number;
        private var _angle:Number;
        private var _draggable:Boolean;
        
        private var _lineColor:uint;
        private var _lineAlpha:Number;
        private var _lineThickness:Number;
        private var _fillColor:uint;
        private var _fillAlpha:Number;
        
        private var _density:Number;
        private var _friction:Number;
        private var _restitution:Number;
        private var _linearDamping:Number;
        private var _angularDamping:Number;
        
        //private var _mass:Number;
        
        private var _isBullet:Boolean;
        private var _fixedRotation:Boolean;
        private var _allowSleep:Boolean;
        private var _isSleeping:Boolean;
        
        private var _maskBits:int;
        private var _groupIndex:int;
        private var _categoryBits:int;
        
        
        public function AbstractQuickObject() 
        {
            x = 0;
            y = 0;
            angle = 0;
            draggable = true;
            
            lineColor = 0x000000;
            lineAlpha = 1.;
            lineThickness = 0.;
            fillColor = 0xCCCCCC;
            fillAlpha = 1.0;
            
            density = 1;
            friction = 0.5;
            restitution = 0.2;
            linearDamping = 0.0;
            angularDamping = 0.0;
            
            isBullet = true;
            
            fixedRotation = false;
            allowSleep = true;
            isSleeping = false;
            
            maskBits = 0xffff;
            groupIndex = 1;
            categoryBits = 1;
        }
        
        public function get draggable():Boolean 
        {
            return _draggable;
        }
        
        public function set draggable(value:Boolean):void 
        {
            _draggable = value;
        }
        
        public function get y():Number 
        {
            return _y;
        }
        
        public function set y(value:Number):void 
        {
            _y = value;
        }
        
        public function get angle():Number 
        {
            return _angle;
        }
        
        public function set angle(value:Number):void 
        {
            _angle = value;
        }
        
        public function get x():Number 
        {
            return _x;
        }
        
        public function set x(value:Number):void 
        {
            _x = value;
        }
        
        public function get fillAlpha():Number 
        {
            return _fillAlpha;
        }
        
        public function set fillAlpha(value:Number):void 
        {
            _fillAlpha = value;
        }
        
        public function get fillColor():uint 
        {
            return _fillColor;
        }
        
        public function set fillColor(value:uint):void 
        {
            _fillColor = value;
        }
        
        public function get lineThickness():Number 
        {
            return _lineThickness;
        }
        
        public function set lineThickness(value:Number):void 
        {
            _lineThickness = value;
        }
        
        public function get lineAlpha():Number 
        {
            return _lineAlpha;
        }
        
        public function set lineAlpha(value:Number):void 
        {
            _lineAlpha = value;
        }
        
        public function get lineColor():uint 
        {
            return _lineColor;
        }
        
        public function set lineColor(value:uint):void 
        {
            _lineColor = value;
        }
        
        public function get categoryBits():int 
        {
            return _categoryBits;
        }
        
        public function set categoryBits(value:int):void 
        {
            _categoryBits = value;
        }
        
        public function get groupIndex():int 
        {
            return _groupIndex;
        }
        
        public function set groupIndex(value:int):void 
        {
            _groupIndex = value;
        }
        
        public function get isSleeping():Boolean 
        {
            return _isSleeping;
        }
        
        public function set isSleeping(value:Boolean):void 
        {
            _isSleeping = value;
        }
        
        public function get maskBits():int 
        {
            return _maskBits;
        }
        
        public function set maskBits(value:int):void 
        {
            _maskBits = value;
        }
        
        public function get allowSleep():Boolean 
        {
            return _allowSleep;
        }
        
        public function set allowSleep(value:Boolean):void 
        {
            _allowSleep = value;
        }
        
        public function get fixedRotation():Boolean 
        {
            return _fixedRotation;
        }
        
        public function set fixedRotation(value:Boolean):void 
        {
            _fixedRotation = value;
        }
        
        public function get isBullet():Boolean 
        {
            return _isBullet;
        }
        
        public function set isBullet(value:Boolean):void 
        {
            _isBullet = value;
        }
        
        public function get angularDamping():Number 
        {
            return _angularDamping;
        }
        
        public function set angularDamping(value:Number):void 
        {
            _angularDamping = value;
        }
        
        public function get linearDamping():Number 
        {
            return _linearDamping;
        }
        
        public function set linearDamping(value:Number):void 
        {
            _linearDamping = value;
        }
        
        public function get restitution():Number 
        {
            return _restitution;
        }
        
        public function set restitution(value:Number):void 
        {
            _restitution = value;
        }
        
        public function get friction():Number 
        {
            return _friction;
        }
        
        public function set friction(value:Number):void 
        {
            _friction = value;
        }
        
        public function get density():Number 
        {
            return _density;
        }
        
        public function set density(value:Number):void 
        {
            _density = value;
        }
    }
    class SCQuickBox2DObject extends AbstractGenerator 
    {
        private var _debug:Boolean;
        private var _gravityX:Number;
        private var _gravityY:Number;
        private var _timeStep:Number;
        private var _iterations:Number;
        private var _frim:Boolean;
        private var _bounds:Array;
        private var _renderJoints:Boolean;
        private var _simpleRender:Boolean;
        private var _customMouse:Boolean;
        public function SCQuickBox2DObject() 
        {
            debug = false;
            gravityX = 0;
            gravityY = 20;
            timeStep = 1/60;
            iterations = 20;
            frim = true;
            bounds = [ -100, -100, 100, 100];
            renderJoints = true;
            simpleRender = true;
            customMouse = false;
        }
        
        public function get customMouse():Boolean 
        {
            return _customMouse;
        }
        
        public function set customMouse(value:Boolean):void 
        {
            _customMouse = value;
        }
        
        public function get simpleRender():Boolean 
        {
            return _simpleRender;
        }
        
        public function set simpleRender(value:Boolean):void 
        {
            _simpleRender = value;
        }
        
        public function get renderJoints():Boolean 
        {
            return _renderJoints;
        }
        
        public function set renderJoints(value:Boolean):void 
        {
            _renderJoints = value;
        }
        
        public function get bounds():Array 
        {
            return _bounds;
        }
        
        public function set bounds(value:Array):void 
        {
            _bounds = value;
        }
        
        public function get frim():Boolean 
        {
            return _frim;
        }
        
        public function set frim(value:Boolean):void 
        {
            _frim = value;
        }
        
        public function get iterations():Number 
        {
            return _iterations;
        }
        
        public function set iterations(value:Number):void 
        {
            _iterations = value;
        }
        
        public function get timeStep():Number 
        {
            return _timeStep;
        }
        
        public function set timeStep(value:Number):void 
        {
            _timeStep = value;
        }
        
        public function get gravityY():Number 
        {
            return _gravityY;
        }
        
        public function set gravityY(value:Number):void 
        {
            _gravityY = value;
        }
        
        public function get gravityX():Number 
        {
            return _gravityX;
        }
        
        public function set gravityX(value:Number):void 
        {
            _gravityX = value;
        }
        
        public function get debug():Boolean 
        {
            return _debug;
        }
        
        public function set debug(value:Boolean):void 
        {
            
            _debug = value;
        }
        
        
        
    }
    class SCCircleObject extends AbstractQuickObject 
    {
        private var _radius:Number;
        
        public function SCCircleObject() 
        {
            radius = 0;
        }
        
        public function get radius():Number 
        {
            return _radius;
        }
        
        public function set radius(value:Number):void 
        {
            _radius = value;
        }
        
    }
    class SCBoxObject extends AbstractQuickObject 
    {
        private var _width:Number;
        private var _height:Number;
        
        public function SCBoxObject() 
        {
            
        }
        
        
        public function get height():Number 
        {
            return _height;
        }
        
        public function set height(value:Number):void 
        {
            _height = value;
        }
        
        public function get width():Number 
        {
            return _width;
        }
        
        public function set width(value:Number):void 
        {
            _width = value;
        }
        
    }
    class AbstractJointObject extends AbstractGenerator
    {
        protected var _a:b2Body;
        protected var _b:b2Body;
        protected var _y2:Number;
        protected var _y1:Number;
        protected var _x2:Number;
        protected var _x1:Number;
        protected var _lineThickness:uint;
        protected var _lineAlpha:uint;
        protected var _lineColor:uint;
        protected var _collideConnected:Boolean;
        protected var _type:String;
        protected var skin:*;
        
        public function AbstractJointObject() 
        {
            lineAlpha = 1;
        }
        public function get collideConnected():Boolean 
        {
            return _collideConnected;
        }
        
        public function set collideConnected(value:Boolean):void 
        {
            _collideConnected = value;
        }
        
        public function get lineColor():uint 
        {
            return _lineColor;
        }
        
        public function set lineColor(value:uint):void 
        {
            _lineColor = value;
        }
        
        public function get lineAlpha():uint 
        {
            return _lineAlpha;
        }
        
        public function set lineAlpha(value:uint):void 
        {
            _lineAlpha = value;
        }
        
        public function get lineThickness():uint 
        {
            return _lineThickness;
        }
        
        public function set lineThickness(value:uint):void 
        {
            _lineThickness = value;
        }
        
        public function get x1():Number 
        {
            return _x1;
        }
        
        public function set x1(value:Number):void 
        {
            _x1 = value;
        }
        
        public function get x2():Number 
        {
            return _x2;
        }
        
        public function set x2(value:Number):void 
        {
            _x2 = value;
        }
        
        public function get y1():Number 
        {
            return _y1;
        }
        
        public function set y1(value:Number):void 
        {
            _y1 = value;
        }
        
        public function get y2():Number 
        {
            return _y2;
        }
        
        public function set y2(value:Number):void 
        {
            _y2 = value;
        }
        
        public function get b():b2Body 
        {
            return _b;
        }
        
        public function set b(value:b2Body):void 
        {
            _b = value;
        }
        
        public function get a():b2Body 
        {
            return _a;
        }
        
        public function set a(value:b2Body):void 
        {
            _a = value;
            
        }
        
        public function get type():String 
        {
            return _type;
        }
        
        public function set type(value:String):void 
        {
            _type = value;
        }
        
    }
    class SCDistanceJointObject extends AbstractJointObject 
    {
        private var _frequencyHz:Number;
        private var _dampingRatio:Number;
        private var _length:Number;
        
        public function SCDistanceJointObject() 
        {
            frequencyHz = 0;
            dampingRatio = 0;
            length = 0;
        }
        
        public function get length():Number 
        {
            return _length;
        }
        
        public function set length(value:Number):void 
        {
            _length = value;
        }
        
        public function get dampingRatio():Number 
        {
            return _dampingRatio;
        }
        
        public function set dampingRatio(value:Number):void 
        {
            _dampingRatio = value;
        }
        
        public function get frequencyHz():Number 
        {
            return _frequencyHz;
        }
        
        public function set frequencyHz(value:Number):void 
        {
            _frequencyHz = value;
            
        }
        
    }
    class SCRevoluteJointObject extends AbstractJointObject 
    {
        private var _enableLimit:Boolean;
        private var _enableMotor:Boolean;
        private var _motorSpeed:Number;
        private var _referenceAngle:Number;
        private var _upperAngle:Number;
        private var _maxMotorTorque:Number;
        private var _lowerAngle:Number;
        
        public function SCRevoluteJointObject() 
        {
            //lowerAngle = 0;
            //upperAngle = 0;
            //referenceAngle = 0;
            type = QuickBox2D.REVOLUTE;
        }
        
        public function get upperAngle():Number 
        {
            return _upperAngle;
        }
        
        public function set upperAngle(value:Number):void 
        {
            _upperAngle = value;
        }
        
        public function get referenceAngle():Number 
        {
            return _referenceAngle;
        }
        
        public function set referenceAngle(value:Number):void 
        {
            _referenceAngle = value;
        }
        
        public function get motorSpeed():Number 
        {
            return _motorSpeed;
        }
        
        public function set motorSpeed(value:Number):void 
        {
            _motorSpeed = value;
        }
        
        public function get enableMotor():Boolean 
        {
            return _enableMotor;
        }
        
        public function set enableMotor(value:Boolean):void 
        {
            _enableMotor = value;
        }
        
        public function get enableLimit():Boolean 
        {
            return _enableLimit;
        }
        
        public function set enableLimit(value:Boolean):void 
        {
            
            _enableLimit = value;
        }
        
        public function get lowerAngle():Number 
        {
            return _lowerAngle;
        }
        
        public function set lowerAngle(value:Number):void 
        {
            _lowerAngle = value;
        }
        
        public function get maxMotorTorque():Number 
        {
            return _maxMotorTorque;
        }
        
        public function set maxMotorTorque(value:Number):void 
        {
            _maxMotorTorque = value;
        }
        
    }
    class Structure
    {
        private var _joint:SCRevoluteJointObject;
        private var _b:SCBoxObject;
        private var _a:SCBoxObject;
        private var q:SCQuickBox2D;
        private var _qa:QuickObject;
        private var _qb:QuickObject;
        private var _qj:b2RevoluteJoint;
        public function Structure(quickBoxArg:SCQuickBox2D)
        {
            q = quickBoxArg;
            _a = new SCBoxObject();
            _b = new SCBoxObject();
            _joint = new SCRevoluteJointObject();
        }
        
        public function init():void 
        {
            _qa = q.addChild(_a);
            _qb = q.addChild(_b);
            _joint.a = qa.body;
            _joint.b = qb.body;
            qj = b2RevoluteJoint(q.addChild(_joint).joint);
            
        }
        public function get joint():SCRevoluteJointObject 
        {
            return _joint;
        }
        
        public function set joint(value:SCRevoluteJointObject):void 
        {
            _joint = value;
        }
        
        public function get b():SCBoxObject 
        {
            return _b;
        }
        
        public function set b(value:SCBoxObject):void 
        {
            _b = value;
        }
        
        public function get a():SCBoxObject 
        {
            return _a;
        }
        
        public function set a(value:SCBoxObject):void 
        {
            _a = value;
        }
        
        public function get qa():QuickObject 
        {
            return _qa;
        }
        
        
        public function set qa(value:QuickObject):void 
        {
            _qa = value;
        }
        
        public function get qb():QuickObject 
        {
            return _qb;
        }
        
        public function set qb(value:QuickObject):void 
        {
            _qb = value;
        }
        
        public function get qj():b2RevoluteJoint 
        {
            return _qj;
        }
        
        public function set qj(value:b2RevoluteJoint):void 
        {
            _qj = value;
        }
        public function clone():Structure
        {
            return this;
        }
    }
    