/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mvhz
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends Sprite {
		
		private var emitter:TriangleEmitter;
		
		public function Main():void {
			emitter = new TriangleEmitter(new SteadyClock(0.5));
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function mainLoop(e:Event):void {
			emitter.field.x = mouseX;
			emitter.field.y = mouseY;
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Oriented;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.RadialField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class TriangleEmitter extends Emitter2D {
	
	public var field:RadialField;
	
	public function TriangleEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		addInitializer(new DisplayObjectClass(Triangle));
		addInitializer(new Life(new UniformRandom(40, 0)));
		addInitializer(new Position(new SinglePoint(232.5, 232.5)));
		addInitializer(new Velocity(new LazySectorZone(4, 0)));
		
		//actions
		field = new RadialField();
		field.strength = -0.3;
		var gravity:Gravity = new Gravity();
		gravity.addField(field);
		
		addAction(gravity);
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new ScaleCurve(10, 10));
		addAction(new Oriented());
	}
}

//------------------------------------------------------------------------------------------------

class Triangle extends Shape {
	
	public static const WIDTH:Number = 20;
	public static const HEIGHT:Number = 30;
	public static const ONE_THIRD:Number = 1 / 3;
	public static const TWO_THIRD:Number = 2 / 3;
	
	public function Triangle() {
		graphics.lineStyle(0, 0x004400);
		graphics.beginFill(0xFFFFFF);
		
		graphics.moveTo(0, -HEIGHT * TWO_THIRD);
		graphics.lineTo(0.5 * WIDTH, HEIGHT * ONE_THIRD);
		graphics.lineTo( -0.5 * WIDTH, HEIGHT * ONE_THIRD);
		graphics.lineTo(0, -HEIGHT * TWO_THIRD);
	}
}