/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/muo4
 */




package 
{
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.filters.DropShadowFilter;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    import com.greensock.*;
    import com.greensock.easing.*;

    
    public class FlashTest extends Sprite 
    {        
        public var player:Array = new Array();
        public var maxNumber:int = 200; //400;
        public var playerSize:Number;        
        public var star:Array = new Array();
        public var i:int;
        public var starsNumber:int = 100;        
        public var introText:TextField = new TextField();
        public var myFormat:TextFormat = new TextFormat();        
        public var time:Timer;
        public var starCount:int = 0;
        public var stats:Stats = new Stats();

        
        public function FlashTest() 
        {   
            time = new Timer(5,0);
            time.start();
            time.addEventListener(TimerEvent.TIMER, timeProgression);
            stage.addChild( stats );
             
            var background:Sprite = new Sprite();
            background.graphics.beginFill(0x000000,1);
            background.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            background.graphics.endFill();
            addChild(background);
            
            myFormat.font = "Helvetica Neue";
            myFormat.bold = false;
            myFormat.italic = true;
            myFormat.color = 0xFFFFFF;
            myFormat.size = 18;//25;
            introText.defaultTextFormat = myFormat;
            introText.text = "Lost in Space";
            introText.x = stage.stageWidth/2-200;
            introText.y = stage.stageHeight/2-10;
            introText.width = stage.stageWidth;
            introText.wordWrap = true;
            introText.alpha = 0;
            introText.selectable = false;
            addChild(introText);
                       
            star[0] = new Array();
            star[1] = new Array();
            star[2] = new Array();
            
            for (i = 0; i<maxNumber; i++)
            {
                playerSize  =  ( i/maxNumber*14 );
                player[i]   =  new Player(playerSize,stage.stageWidth/2,stage.stageHeight/2,0xFFFFFF,0.13 ); 
                
                addChild( player[i].gfx );           
            }
            
            
            addEventListener(Event.ENTER_FRAME, progression);
            
            
        }
        public function timeProgression(e:TimerEvent):void{
            star[0][starCount] = new Star(Math.random()*3, Math.random()*0.8, (stage.stageWidth+20), Math.random()*stage.stageHeight);
            star[1][starCount] = Math.random()*star[0][starCount].gfx.alpha*star[0][starCount].gfx.width;
            star[2][starCount] = (Math.random()*2-1)*0.1;
            addChild(star[0][starCount].gfx);
            starCount++;
        }

        
        public function progression(e:Event):void{
            var xSpeed:Number = 0;
            var ySpeed:Number = 0;

             if(time.currentCount>50){
                if(introText.alpha<0.8){introText.alpha+=0.02};
            }
            if(time.currentCount>200){
                introText.alpha-=0.06;                  
            }
               
            for(var i:int = maxNumber-1; i>=0; i--){
                if(i==maxNumber-1){
                    xSpeed = (mouseX- player[i].gfx.x)/20;
                    ySpeed = (mouseY - player[i].gfx.y)/20;
                }else{
                    xSpeed = (player[i+1].gfx.x - player[i].gfx.x)/1.1;
                    ySpeed = (player[i+1].gfx.y - player[i].gfx.y)/1.1;
                }                         
                
                player[i].gfx.x += xSpeed;
                player[i].gfx.y += ySpeed;
            }
            
            for(i = 0; i<star[0].length; i++){
                if(star[0][i].beyond==false){
                    star[0][i].gfx.x-=star[1][i];
                    star[0][i].gfx.y+=star[2][i];
                    if(star[0][i].gfx.x<0){
                        star[0][i].beyond = true;
                        removeChild(star[0][i].gfx)
                    }
                }
            }
        }
    }
}
import flash.geom.Vector3D;
//--------------CLASSES---------------------






import flash.display.*;

class Player {
    public var gfx:Sprite = new Sprite();
    public function Player(r:Number, x:Number, y:Number, c:Number, a:Number) {
        
        gfx.graphics.beginFill(c,a);
        gfx.graphics.drawCircle(0,0,r);
        gfx.graphics.endFill();

        gfx.x = x;
        gfx.y = y; 
        //gfx.z = z;
        //gfx.w = w;
        
    }
}

class Star {
    public var gfx:Sprite = new Sprite();
    public var beyond:Boolean = false;
    public function Star(r:Number,a:Number,x:Number, y:Number){
        gfx.graphics.beginFill(0xFFFFFF);
        gfx.graphics.drawCircle(0,0,r);
        gfx.graphics.endFill();
        gfx.x = x;
        gfx.y = y;
        gfx.alpha = a;
    }
}

