/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/muYR
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class ScrollingContents extends Sprite {
        public var contents:Sprite;
        public var page:Sprite;
        public var revealcontents:Boolean = false;
        
        public function ScrollingContents() {
            contents = new Sprite();
            contents.x = -125;
            contents.graphics.beginFill(0x999999, 1);
            contents.graphics.drawRect(0, 0, 150, 465);
            contents.graphics.endFill();
            this.addChild(contents);
            
            page = new Sprite();
            page.x = 25;
            page.graphics.beginFill(0xcccccc, 1);
            page.graphics.drawRect(0, 0, 465, 465);
            page.graphics.endFill();
            this.addChild(page);
            
            var format:TextFormat = new TextFormat();
            format.font = "Segoe UI Light";
            format.size = 24;
            
            var ctitle:TextField = new TextField();
            ctitle.selectable = false;
            ctitle.text = "Contents";
            ctitle.setTextFormat(format);
            ctitle.width = ctitle.textWidth + 4;
            ctitle.height = ctitle.textHeight + 4;
            ctitle.x = 20;
            ctitle.y = 10;
            
            var ptitle:TextField = new TextField();
            ptitle.selectable = false;
            ptitle.text = "Page";
            ptitle.setTextFormat(format);
            ptitle.width = ptitle.textWidth + 4;
            ptitle.height = ptitle.textHeight + 4;
            ptitle.x = 20;
            ptitle.y = 10;
            
            contents.addChild(ctitle);
            page.addChild(ptitle);
            
            this.addEventListener(Event.ENTER_FRAME, scrollingcontents);
            
            contents.addEventListener(MouseEvent.MOUSE_MOVE, function (me:MouseEvent):void {revealcontents = true});
            contents.addEventListener(MouseEvent.MOUSE_OUT, function (me:MouseEvent):void {revealcontents = false});
        }
        
        public function scrollingcontents(e:Event):void {
            if (revealcontents) {
                if (contents.x < 0) {
                    contents.x += -contents.x / 5;
                    page.alpha -= (page.alpha - .5) / 5;
                } else {
                    contents.x = 0;
                    page.alpha = .5;
                }
            } else {
                if (contents.x > -125) {
                    contents.x += (-125 - contents.x) / 5;
                    page.alpha += (1 - page.alpha) / 5;
                } else {
                    contents.x = -125;
                    page.alpha = 1;
                }
            }
            
            page.x = contents.x + 150;
        }
    }
}