/**
 * Copyright inippo ( http://wonderfl.net/user/inippo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/muPM
 */

// forked from inippo's ParticleClock
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    
    [SWF(width = 465, height = 465, frameRate = 60 , backgroundColor = "#F6f6f6")]  
    public class ParticleClock extends Sprite {
        
        public var tf:TextField;
        public var tfm:TextFormat;
        public var baseBmd:BitmapData;
        public var canvasBmd:BitmapData;
        public var copyBmd:BitmapData;
        
        public var canvas:Bitmap;
        public var p:Particle;
        public var date:Date;
        public var prev_s:String;
        
        /**
         * ここでパラメーター変えれば少しは調整できる
         */
        public const FONT_SIZE:int = 80;
        public const FONT_COLOR:uint = 0xFF3366;
        public const CANVAS_DELAY:int = 10; // フィルタ処理をした場合の透過具合
        public const IS_SMOOTH:Boolean = true; // フィルタ処理をするか
        public const IS_SHUFFLE:Boolean = true; // 更新ごとにパーティクルをシャッフル
        public const INTERVAL:int = 2; // パーティクルの間隔（1はちょっと厳しい、、、）
        public const COUNT:int = 2; // 何秒おきに更新するか
        
        public function ParticleClock() {
            
            canvas = addChild(new Bitmap()) as Bitmap;
            
            date = new Date();
            var h:int = date.getHours();
            var m:int = date.getMinutes();
            var s:int = date.getSeconds();
            
            var str_h:String = (h < 10)? "0" + h.toString() : h.toString();
            var str_m:String = (m < 10)? "0" + m.toString() : m.toString();
            var str_s:String = (s < 10)? "0" + s.toString() : s.toString();
            
            // コピー元のテキストを作成
            tf = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            tfm = new TextFormat("Arial Black", FONT_SIZE, FONT_COLOR);
            tf.defaultTextFormat = tfm;
            tf.text = str_h + ":" + str_m + ":" + str_s;
            
            // 描画用のビットマップデータを作成
            baseBmd = new BitmapData(tf.width, tf.height * 2);
            copyBmd = baseBmd.clone();
            canvasBmd = baseBmd.clone();
            copyBmd.draw(tf);
            
            // パーティクル作成
            p = new Particle(INTERVAL,IS_SHUFFLE,FONT_COLOR,COUNT);
            p.createParticles(copyBmd);
            
            // 初回の更新
            update(str_h,str_m,str_s);
            
            // タイマーで監視
            var t:Timer = new Timer(33, 0);
            t.addEventListener(TimerEvent.TIMER, check);
            t.start();
            
        }
        
        /**
         * 時間がが更新されているか監視
         */
        public function check(e:TimerEvent):void
        {
            date = new Date();
            var s:int = date.getSeconds();
            var str_s:String = (s < 10)? "0" + s.toString() : s.toString();
            
            // 更新されていたら
            if (str_s != prev_s)
            {
                var h:int = date.getHours();
                var m:int = date.getMinutes();
                var str_h:String = (h < 10)? "0" + h.toString() : h.toString();
                var str_m:String = (m < 10)? "0" + m.toString() : m.toString();
                
                // 文字列の更新
                update(str_h, str_m, str_s);
            }
            
            // 描画の更新
            draw();
        }
        
        
        /**
         * 文字列の更新
         */
        public function update(h:String,m:String,s:String):void
        {
            
            tf.text = h + ":" + m + ":" + s;
            prev_s = s;
            
            if (int(s) % COUNT != 0) return;
            
            copyBmd = baseBmd.clone();
            copyBmd.draw(tf);
            p.updateParticles(copyBmd);
            
            
        }
        
        /**
         * 繰り返し描画を更新
         */
        public function draw():void
        {
            // フィルターで滑らかにする
            if(!IS_SMOOTH) canvasBmd = baseBmd.clone();
            
            // パーティクルを取得
            var particles:Array = p.getParticles();
            
            canvasBmd.lock();
            
            // パーティクルの描画
            for (var i:int; i < particles.length; i++)
                canvasBmd.setPixel(particles[i].x, particles[i].y + tf.height / 2, particles[i].color);
            
            if (IS_SMOOTH)
            {
                // 徐々に描画を消す
                canvasBmd.applyFilter(canvasBmd, canvasBmd.rect, new Point(), new ColorMatrixFilter([
                 1,    0,    0,    0,    CANVAS_DELAY,
                 0,    1,    0,    0,    CANVAS_DELAY,
                 0,    0,    1,    0,    CANVAS_DELAY,
                 0,    0,    0,    1,    0
              ])); 
              canvasBmd.applyFilter(canvasBmd,canvasBmd.rect,new Point(),new BlurFilter(2,2,10));
            }
            
            canvas.bitmapData = canvasBmd;
            
            canvasBmd.unlock();
            
            canvas.x = (stage.stageWidth - canvas.width) / 2;
            canvas.y = (stage.stageHeight - canvas.height) / 2;
        }
    }
}

import flash.display.*;
import org.libspark.betweenas3.*;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.*;

class Particle {
    
    public var particles:Array;
    public var INTERVAL:int; // パーティクルの間隔
    public var IS_SHUFFLE:Boolean; // 更新ごとにパーティクルをシャッフル
    public var FONT_COLOR:uint;
    public var COUNT:int;
    
    public function Particle(interval:int, isShuffle:Boolean, fontColor:uint,count:int):void
    {
        INTERVAL = interval;
        IS_SHUFFLE = isShuffle;
        FONT_COLOR = fontColor;
        COUNT = count;
    }
    
    /**
     * パーティクルを作成
     */ 
    public function createParticles(bmd:BitmapData):void
    {
        particles = [];
        
        // 文字のピクセル情報を取得
        for (var xx:int; xx < bmd.width; xx+=INTERVAL)
        {
            for (var yy:int = 0; yy < bmd.height; yy+=INTERVAL)
            {
                var col:uint = bmd.getPixel(xx, yy);
                
                if (col != 0xFFFFFF) 
                    particles.push( { x:xx, y:yy,color:col  } );
                
            }
        }
        
    }
    
    public function getParticles():Array{return particles}
    
    public function updateParticles(bmd:BitmapData):void
    {
        var i:int;
        
        if(IS_SHUFFLE) particles.sort(function():int { return int(Math.random() * 3) - 1 } );
        
        for (var xx:int; xx < bmd.width; xx+=INTERVAL)
        {
            for (var yy:int = 0; yy < bmd.height; yy+=INTERVAL)
            {
                var col:uint = bmd.getPixel(xx, yy);
                
                if (col != 0xFFFFFF) {
                    var t:ITween;
                    if (IS_SHUFFLE)
                    {
                        t = BetweenAS3.bezier(
                        particles[i++], 
                        { x:xx, y:yy, color:col }, 
                        null, 
                        { 
                            x:Math.random() * (bmd.width * 2) - bmd.width / 2, 
                            y:Math.random() * (bmd.height * 2) -  bmd.height / 2 
                        }, 
                        COUNT * 0.9,
                        Sine.easeInOut
                        );
                    }
                    else
                    {
                        t = BetweenAS3.tween(
                        particles[i++], 
                        { x:xx, y:yy, color:col }, 
                        null, 
                        COUNT * 0.9,
                        Sine.easeInOut
                        );
                    }
                    
                    t.play();
                    if (i >= particles.length)
                        particles.push( { x:xx, y:yy, color:col } );
                }
            }
        }
        
        // 余ったパーティクルの処理
        for (var n:int = particles.length; n > i; n--)
            particles.pop();
    }
    
}