/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/msjF
 */

package {

    import flash.display.Sprite;
    public class Loading extends Sprite {
        public function Loading() {
            var obj:Object = { radius: 15, height: 10, color: 0Xcc0000 };
            var icon:LoaderIcon = new LoaderIcon( obj );
            icon.x = stage.stageWidth / 2;
            icon.y = stage.stageHeight / 2;
            addChild( icon );
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
	
class LoaderIcon extends Sprite {
    /* デフォルト設定 */
    private var obj:Object = {
        width: 2,
        height: 5,
        color: 0X000000,
        num: 12,
        radius: 5
    };
		
    /* コンストラクタ */
    public function LoaderIcon( ...arg:Array ) {
        for ( var item:Object in arg[0] ) {
            obj[item] = arg[0][item];
        }
        for (var i:int = 0; i < obj.num; i++ ) { 
            createRect( i ); 
        }
        addEventListener(Event.ENTER_FRAME, boxRotation);
    }
		
    /* 図形の描画 */
    private function createRect( i:int ):void {
        var posX:Number = obj.radius * Math.sin(Math.PI * 2 * i / obj.num);
        var posY:Number = obj.radius * Math.cos(Math.PI * 2 * i / obj.num);

        var box:Sprite = new Sprite();
        box.graphics.beginFill( obj.color );
        box.graphics.drawRect( obj.x / -2, 0, obj.width, obj.height );
        box.graphics.endFill();
        box.rotation = 360 - ( i * 360 / obj.num );
        box.alpha = 1 - (1 / obj.num * i);
        box.x = posX;
        box.y = posY;
        addChild( box );
    }
		
    /* 回転 */
    private function boxRotation(e:Event):void {
        rotation += 360 / obj.num;
    }
		
    /* アイコンを削除 */
    public function deleteIcon():void {
        var parentObj:Object = Object(parent);
        parentObj.removeChild( this );
    }
}