/**
 * Copyright minodisk ( http://wonderfl.net/user/minodisk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ms0B
 */

package  
{
	import com.bit101.components.CheckBox;
	import com.bit101.components.Slider;
	import flash.display.Graphics;
	import flash.display.GraphicsSolidFill;
	import flash.display.GraphicsStroke;
	import flash.display.IGraphicsData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextFormat;
	
	/**
	 * http://ferv.jp/blog/2009/10/28/graphicspath-drawroundrect/
	 * 
	 * @langversion ActionScript 3.0
	 * @playerversion Flash 10.0
	 * 
	 * @author dsk
	 * @since 2009/10/27
	 */
	public class RountRectGraphicsPath extends Sprite
	{
		
		//--------------------------------------
		// CLASS CONSTANTS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE VARIABLES
		//--------------------------------------
		
		private var _tl:CheckBox;
		private var _tr:CheckBox;
		private var _bl:CheckBox;
		private var _br:CheckBox;
		private var _width:Slider;
		private var _height:Slider;
		private var _ellipseWidth:Slider;
		private var _ellipseHeight:Slider;
		
		
		//--------------------------------------
		// GETTER/SETTERS
		//--------------------------------------
		
		
		//--------------------------------------
		// CONSTRUCTOR
		//--------------------------------------
		
		public function RountRectGraphicsPath() 
		{
			_tl = new CheckBox(this, 70, 70, 'TOP_LEFT', _onChange);
			_tl.selected = true;
			_tr = new CheckBox(this, 385, 70, 'TOP_RIGHT', _onChange);
			_tr.selected = true;
			_bl = new CheckBox(this, 70, 385, 'BOTTOM_LEFT', _onChange);
			_bl.selected = true;
			_br = new CheckBox(this, 390, 385, 'BOTTOM_RIGHT', _onChange);
			_br.selected = true;
			_width = new Slider(Slider.HORIZONTAL, this, 190, 0, _onChange);
			_height = new Slider(Slider.VERTICAL, this, 0, 190, _onChange);
			_ellipseWidth = new Slider(Slider.HORIZONTAL, this, 190, 15, _onChange);
			_ellipseHeight = new Slider(Slider.VERTICAL, this, 15, 190, _onChange);
			_height.maximum = 300;
			_width.maximum = 300;
			_width.value = 300;
			_height.value = 300;
			_ellipseWidth.value = 50;
			_ellipseHeight.value = 50;
			
			_onChange();
		}
		
		
		//--------------------------------------
		// PUBLIC METHODS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE METHODS
		//--------------------------------------
		
		private function _onChange(e:Event = null):void 
		{
			var width:Number = _width.value;
			var height:Number = _height.value;
			var x:Number = (stage.stageWidth - width) / 2;
			var y:Number = (stage.stageHeight - height) / 2;
			var ellipseWidth:Number = _ellipseWidth.value;
			var ellipseHeight:Number = _ellipseHeight.value;
			var tl:int = (_tl.selected)? GraphicsPathUtil.TOP_LEFT: GraphicsPathUtil.NONE;
			var tr:int = (_tr.selected)? GraphicsPathUtil.TOP_RIGHT: GraphicsPathUtil.NONE;
			var bl:int = (_bl.selected)? GraphicsPathUtil.BOTTOM_LEFT: GraphicsPathUtil.NONE;
			var br:int = (_br.selected)? GraphicsPathUtil.BOTTOM_RIGHT: GraphicsPathUtil.NONE;
			
			var g:Graphics = graphics;
			g.clear();
			g.lineStyle(4, 0x008CD2);
			g.drawRoundRect(x, y, width, height, ellipseWidth, ellipseHeight);
			
			g.drawGraphicsData(Vector.<IGraphicsData>([
				new GraphicsStroke(2, false, 'normal', 'none', 'round', 3, new GraphicsSolidFill(0x000000, 1)),
				GraphicsPathUtil.createRoundRect(x, y, width, height, ellipseWidth, ellipseHeight, tl | tr | bl | br)
			]));
		}
		
		
	}
	
	
}



import flash.display.GraphicsPath;
import flash.display.GraphicsPathCommand;

internal class GraphicsPathUtil 
{
	public static const NONE:int         = 0;
	public static const TOP_LEFT:int     = 1;
	public static const TOP_RIGHT:int    = 2;
	public static const BOTTOM_LEFT:int  = 4;
	public static const BOTTOM_RIGHT:int = 8;
	public static const ALL:int          = TOP_LEFT | TOP_RIGHT | BOTTOM_LEFT | BOTTOM_RIGHT;
	
	public static function createRoundRect(x:Number, y:Number, width:Number, height:Number, ellipseWidth:Number, ellipseHeight:Number, 
										   option:int = 15, winding:String = 'evenOdd'):GraphicsPath 
	{
		ellipseWidth = (ellipseWidth > width)? width: ellipseWidth;
		ellipseHeight = (ellipseHeight > height)? height: ellipseHeight;
		ellipseWidth /= 2;
		ellipseHeight /= 2;
		
		var anchorX:Number = ellipseWidth * (1 - Math.SQRT1_2);
		var anchorY:Number = ellipseHeight * (1 - Math.SQRT1_2);
		var handleX:Number = ellipseWidth * (2 - Math.SQRT2);
		var handleY:Number = ellipseHeight * (2 - Math.SQRT2);
		
		var commands:Vector.<int> = new Vector.<int>();
		var data:Vector.<Number> = new Vector.<Number>();
		
		if ((option & TOP_LEFT) == TOP_LEFT) {
			commands.push(GraphicsPathCommand.MOVE_TO, GraphicsPathCommand.CURVE_TO);
			data.push(
				x + anchorX, y + anchorY, 
				x + handleX, y, x + ellipseWidth, y
			);
		} else {
			commands.push(GraphicsPathCommand.MOVE_TO);
			data.push(x, y);
		}
		if ((option & TOP_RIGHT) == TOP_RIGHT) {
			commands.push(GraphicsPathCommand.LINE_TO, GraphicsPathCommand.CURVE_TO, GraphicsPathCommand.CURVE_TO);
			data.push(
				x + width - ellipseWidth, y, 
				x + width - handleX, y, x + width - anchorX, y + anchorY, 
				x + width, y + handleY, x + width, y + ellipseHeight
			);
		} else {
			commands.push(GraphicsPathCommand.LINE_TO);
			data.push(x + width, y);
		}
		if ((option & BOTTOM_RIGHT) == BOTTOM_RIGHT) {
			commands.push(GraphicsPathCommand.LINE_TO, GraphicsPathCommand.CURVE_TO, GraphicsPathCommand.CURVE_TO);
			data.push(
				x + width, y + height - ellipseHeight, 
				x + width, y + height - handleY, x + width - anchorX, y + height - anchorY, 
				x + width - handleX, y + height, x + width - ellipseWidth, y + height
			);
		} else {
			commands.push(GraphicsPathCommand.LINE_TO);
			data.push(x + width, y + height);
		}
		if ((option & BOTTOM_LEFT) == BOTTOM_LEFT) {
			commands.push(GraphicsPathCommand.LINE_TO, GraphicsPathCommand.CURVE_TO, GraphicsPathCommand.CURVE_TO);
			data.push(
				x + ellipseWidth, y + height, 
				x + handleX, y + height, x + anchorX, y + height - anchorY, 
				x, y + height - handleY, x, y + height - ellipseHeight
			);
		} else {
			commands.push(GraphicsPathCommand.LINE_TO);
			data.push(x, y + height);
		}
		if ((option & TOP_LEFT) == TOP_LEFT) {
			commands.push(GraphicsPathCommand.LINE_TO, GraphicsPathCommand.CURVE_TO);
			data.push(
				x, y + ellipseHeight, 
				x, y + handleY, x + anchorX, y + anchorY
			);
		} else {
			commands.push(GraphicsPathCommand.LINE_TO);
			data.push(x, y);
		}
		
		return new GraphicsPath(commands, data, winding);
	}
	
	
}









