/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mrFx
 */

package {
	import flash.accessibility.Accessibility;
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.events.MouseEvent;
	
	public class FlashTest extends Sprite {
		private var webCam:WebCamera;
		public function FlashTest() {
			Wonderfl.disable_capture();
			webCam = new WebCamera(465,465,30);
			addChild(webCam);
			webCam.addEventListener(MouseEvent.CLICK, capture);
		}
		private function capture(event:MouseEvent):void{
			switch(this.numChildren){
				case 1:
					addChild(new Bitmap(webCam.capture()));
				break;
				case 2:
					removeChildAt(1);
				break;
			}
			//webCam.removeEventListener(MouseEvent.CLICK, capture);
		}
	}
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.media.Camera;
import flash.media.Video;
import flash.events.Event;

class WebCamera extends Sprite{
	private var camera:Camera;
	private var video:Video;
	
	public function WebCamera(_width:Number=160, _height:Number = 120, _fps:uint = 15):void{
		camera = Camera.getCamera();
		if(camera){
			camera.setMode(_width, _height, _fps);
			video = new Video(camera.width, camera.height);
			setupCamera();
			return;
		}
		dispatchEvent(new Event("connectionError"));
	}
	private function setupCamera():void{
		video.attachCamera(camera);
		addChild(video);
	}
	
	/*** method ***/
	public function capture():BitmapData{
		var _capture:BitmapData = new BitmapData(video.width, video.height);
		_capture.draw(video);
		return _capture;
	}
	
	/*** property ***/
	override public function set width(_width:Number):void{
	scale = _width/ camera.width;
	}
	override public function get width():Number{
		return camera.width;
	}
	override public function set height(_height:Number):void{
		scale = _height/camera.height;
	}
	override public function get height():Number{
		return camera.height;
	}
	public function set scale(_scale:Number):void{
		if(_scale < 0) return;
		camera.setMode(camera.width*_scale, camera.height*_scale, camera.fps);
		video.width = camera.width;
		video.height = camera.height;
	}
}