/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mqUO
 */

/*
 * delicious hotlist のサムネールを
 * HeartRails Captureを使って表示してみる。
 * 
 * Delicious
 * http://delicious.com/
 * 
 * HeartRails Capture
 * http://capture.heartrails.com/
 * */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.net.navigateToURL;
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite 
	{
		public function Main():void 
		{
			var myLoader:URLLoader = new URLLoader();
			myLoader.addEventListener (Event.COMPLETE,COMPLETE);
			myLoader.load(new URLRequest("http://feeds.delicious.com/v2/rss/?count=15"));
		}
           
		private function COMPLETE(e:Event):void 
		{
			var xml:XML = new XML(e.currentTarget.data);
			default xml namespace = new Namespace(xml.namespace());
			var title:TextField = new TextField();
			title.text = "delicious hotlist + HeartRails Capture";
			title.width = 465;
			title.height = 20;
			addChild(title);
			
			var _length:int = Math.min(12,xml.channel.item.length());
			for (var i:int = 0; i < _length; i++) {
				var imgURL:String = "http://capture.heartrails.com/small?" + xml.channel.item[i].link;
				var myLoader:Loader = new Loader();
				myLoader.load(new URLRequest(imgURL));
				myLoader.x = 23 + (i % 3) * 150;
				myLoader.y = 25 + Math.floor(i / 3) * 110;
				myLoader.filters = [new DropShadowFilter()];
				myLoader.name = xml.channel.item[i].link;
				var tf:TextField = new TextField();
				tf.text = xml.channel.item[i].title;
				tf.width = 140;
				tf.height = 20;
				tf.x = 13 + (i % 3) * 150;
				tf.y = 90 + 25 + Math.floor(i / 3) * 110;
				addChildAt(myLoader, 0);
				addChildAt(tf, 0);
			}
			addEventListener(MouseEvent.CLICK,CLICK)
			function CLICK(e:Event):void 
			{
				navigateToURL(new URLRequest( e.target.name) );
			}
			
		}
	}
}