/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mqF1
 */

/*
    エフェクトの練習
    マウスの位置によって色が変わります。
    色変更の計算は適当。
*/
package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.effects.utils.BitmapDrawCommand;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends Sprite
    {
        private var viewport:Viewport3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var rootNode:DisplayObject3D;
        private var bfx:BitmapEffectLayer;
        private var cube:Cube;
        private var ct:ColorTransform;
        
        public function Main()
        {
            viewport=new Viewport3D(0, 0, true, true);
            scene=new Scene3D();
            camera=new Camera3D();
            renderer=new BasicRenderEngine();
            rootNode=scene.addChild(new DisplayObject3D("rootNode"));
            addEventListener(Event.ENTER_FRAME, onFrame);
            
            addChild(viewport);
            camera.zoom=30;
            camera.focus=200;
            camera.target=DisplayObject3D.ZERO;
            
            bfx=new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 4)));
            bfx.addEffect(new BitmapColorEffect(0.99, 0.98, 0.98, 0.98));
            ct=new ColorTransform(0.1, 1, 0.1, 0.25);
            bfx.drawCommand=new BitmapDrawCommand(null, ct, BlendMode.ADD);
            bfx.clippingPoint=new Point(0, -7);
            bfx.drawLayer.blendMode=BlendMode.OVERLAY;
            viewport.containerSprite.addLayer(bfx);
            
            var materials:MaterialsList=new MaterialsList({all:new ColorMaterial(Math.floor(0xFFFFFF), 0.5)});
            cube=new Cube(materials, 30, 30, 30, 4, 4, 4);
            rootNode.addChild(cube);
            bfx.addDisplayObject3D(cube);
        }
        
        public function onFrame(e:Event):void
        {
            cube.rotationX++;
            cube.rotationY++;
            
            // 色変更（計算適当）
            ct.blueMultiplier=mouseX / 500;
            ct.greenMultiplier=mouseY / 500;
            ct.redMultiplier=50 / mouseX;
            bfx.drawCommand.colorTransform=ct;
            
            renderer.renderScene(scene, camera, viewport);
        }
    }
}